/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.shared.media.items.ItemPrintout;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class ItemPrintoutRenderer
extends ItemMapLikeRenderer {
    private static final ItemPrintoutRenderer INSTANCE = new ItemPrintoutRenderer();

    private ItemPrintoutRenderer() {
    }

    @SubscribeEvent
    public static void onRenderInHand(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.func_77973_b() instanceof ItemPrintout)) {
            return;
        }
        event.setCanceled(true);
        INSTANCE.renderItemFirstPerson(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getHand(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), event.getItemStack());
    }

    @Override
    protected void renderItem(MatrixStack transform, IRenderTypeBuffer render, ItemStack stack, int light) {
        transform.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        transform.func_227862_a_(0.42f, 0.42f, -0.42f);
        transform.func_227861_a_(-0.5, (double)-0.48f, 0.0);
        ItemPrintoutRenderer.drawPrintout(transform, render, stack, light);
    }

    @SubscribeEvent
    public static void onRenderInFrame(RenderItemInFrameEvent event) {
        ItemStack stack = event.getItem();
        if (!(stack.func_77973_b() instanceof ItemPrintout)) {
            return;
        }
        event.setCanceled(true);
        MatrixStack transform = event.getMatrix();
        transform.func_227861_a_(0.0, 0.0, (double)-0.001f);
        transform.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        transform.func_227862_a_(0.95f, 0.95f, -0.95f);
        transform.func_227861_a_(-0.5, -0.5, 0.0);
        ItemPrintoutRenderer.drawPrintout(transform, event.getBuffers(), stack, event.getLight());
    }

    private static void drawPrintout(MatrixStack transform, IRenderTypeBuffer render, ItemStack stack, int light) {
        int pages = ItemPrintout.getPageCount(stack);
        boolean book = ((ItemPrintout)stack.func_77973_b()).getType() == ItemPrintout.Type.BOOK;
        double width = 176.0;
        double height = 211.0;
        if (!book) {
            width += (double)PrintoutRenderer.offsetAt(pages - 1);
        }
        double visualWidth = width;
        double visualHeight = height;
        if (book) {
            visualWidth += (double)(24.0f + 2.0f * PrintoutRenderer.offsetAt(pages));
            visualHeight += 24.0;
        }
        double max = Math.max(visualHeight, visualWidth);
        float scale = (float)(1.0 / max);
        transform.func_227862_a_(scale, scale, scale);
        transform.func_227861_a_((max - width) / 2.0, (max - height) / 2.0, 0.0);
        Matrix4f matrix = transform.func_227866_c_().func_227870_a_();
        PrintoutRenderer.drawBorder(matrix, render, 0.0f, 0.0f, -0.01f, 0, pages, book, light);
        PrintoutRenderer.drawText(matrix, render, 13, 11, 0, light, ItemPrintout.getText(stack), ItemPrintout.getColours(stack));
    }
}

