/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.command.text.TableFormatter;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class ClientTableFormatter
implements TableFormatter {
    public static final ClientTableFormatter INSTANCE = new ClientTableFormatter();
    private static final Int2IntOpenHashMap lastHeights = new Int2IntOpenHashMap();

    private static FontRenderer renderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    @Nullable
    public ITextComponent getPadding(ITextComponent component, int width) {
        int extraWidth = width - this.getWidth(component);
        if (extraWidth <= 0) {
            return null;
        }
        FontRenderer renderer = ClientTableFormatter.renderer();
        float spaceWidth = renderer.func_78256_a(" ");
        int spaces = MathHelper.func_76141_d((float)((float)extraWidth / spaceWidth));
        int extra = extraWidth - (int)((float)spaces * spaceWidth);
        return ChatHelpers.coloured(StringUtils.repeat((char)' ', (int)spaces) + StringUtils.repeat((char)'\u02c8', (int)extra), TextFormatting.GRAY);
    }

    @Override
    public int getColumnPadding() {
        return 3;
    }

    @Override
    public int getWidth(ITextComponent component) {
        return ClientTableFormatter.renderer().func_238414_a_((ITextProperties)component);
    }

    @Override
    public void writeLine(int id, ITextComponent component) {
        Minecraft mc = Minecraft.func_71410_x();
        NewChatGui chat = mc.field_71456_v.func_146158_b();
        chat.func_146234_a(component, id);
    }

    @Override
    public int display(TableBuilder table) {
        NewChatGui chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        int lastHeight = lastHeights.get(table.getId());
        int height = TableFormatter.super.display(table);
        lastHeights.put(table.getId(), height);
        for (int i = height; i < lastHeight; ++i) {
            chat.func_146242_c(i + table.getId());
        }
        return height;
    }
}

