/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.GuiComputer;
import dan200.computercraft.client.gui.GuiDiskDrive;
import dan200.computercraft.client.gui.GuiPrinter;
import dan200.computercraft.client.gui.GuiPrintout;
import dan200.computercraft.client.gui.GuiTurtle;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.render.TileEntityMonitorRenderer;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TurtleModelLoader;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Colour;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ClientRegistry {
    private static final String[] EXTRA_MODELS = new String[]{"turtle_modem_normal_off_left", "turtle_modem_normal_on_left", "turtle_modem_normal_off_right", "turtle_modem_normal_on_right", "turtle_modem_advanced_off_left", "turtle_modem_advanced_on_left", "turtle_modem_advanced_off_right", "turtle_modem_advanced_on_right", "turtle_crafting_table_left", "turtle_crafting_table_right", "turtle_speaker_upgrade_left", "turtle_speaker_upgrade_right", "turtle_colour", "turtle_elf_overlay"};

    private ClientRegistry() {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("computercraft", "turtle"), (IModelLoader)TurtleModelLoader.INSTANCE);
        for (String model : EXTRA_MODELS) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("computercraft", model), "inventory"));
        }
    }

    @SubscribeEvent
    public static void onItemColours(ColorHandlerEvent.Item event) {
        if (Registry.ModItems.DISK == null || Registry.ModBlocks.TURTLE_NORMAL == null) {
            ComputerCraft.log.warn("Block/item registration has failed. Skipping registration of item colours.");
            return;
        }
        event.getItemColors().func_199877_a((stack, layer) -> layer == 1 ? ((ItemDisk)stack.func_77973_b()).getColour(stack) : 0xFFFFFF, new IItemProvider[]{(IItemProvider)Registry.ModItems.DISK.get()});
        event.getItemColors().func_199877_a((stack, layer) -> layer == 1 ? ItemTreasureDisk.getColour(stack) : 0xFFFFFF, new IItemProvider[]{(IItemProvider)Registry.ModItems.TREASURE_DISK.get()});
        event.getItemColors().func_199877_a((stack, layer) -> {
            switch (layer) {
                default: {
                    return 0xFFFFFF;
                }
                case 1: {
                    return IColouredItem.getColourBasic(stack);
                }
                case 2: 
            }
            int light = ItemPocketComputer.getLightState(stack);
            return light == -1 ? Colour.BLACK.getHex() : light;
        }, new IItemProvider[]{(IItemProvider)Registry.ModItems.POCKET_COMPUTER_NORMAL.get(), (IItemProvider)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get()});
        event.getItemColors().func_199877_a((stack, tintIndex) -> tintIndex == 0 ? ((IColouredItem)stack.func_77973_b()).getColour(stack) : 0xFFFFFF, new IItemProvider[]{(IItemProvider)Registry.ModBlocks.TURTLE_NORMAL.get(), (IItemProvider)Registry.ModBlocks.TURTLE_ADVANCED.get()});
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.TURTLE_NORMAL.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.TURTLE_ADVANCED.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.MONITOR_NORMAL.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.MONITOR_ADVANCED.get()), (RenderType)RenderType.func_228643_e_());
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.MONITOR_NORMAL.get()), TileEntityMonitorRenderer::new);
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.MONITOR_ADVANCED.get()), TileEntityMonitorRenderer::new);
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.TURTLE_NORMAL.get()), TileEntityTurtleRenderer::new);
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.TURTLE_ADVANCED.get()), TileEntityTurtleRenderer::new);
        event.enqueueWork(() -> {
            ClientRegistry.registerContainers();
            ClientRegistry.registerItemProperty("state", (stack, world, player) -> ItemPocketComputer.getState(stack).ordinal(), new Supplier[]{Registry.ModItems.POCKET_COMPUTER_NORMAL, Registry.ModItems.POCKET_COMPUTER_ADVANCED});
            ClientRegistry.registerItemProperty("coloured", (stack, world, player) -> IColouredItem.getColourBasic(stack) != -1 ? 1.0f : 0.0f, new Supplier[]{Registry.ModItems.POCKET_COMPUTER_NORMAL, Registry.ModItems.POCKET_COMPUTER_ADVANCED});
        });
    }

    @SafeVarargs
    private static void registerItemProperty(String name, IItemPropertyGetter getter, Supplier<? extends Item> ... items) {
        ResourceLocation id = new ResourceLocation("computercraft", name);
        for (Supplier<? extends Item> item : items) {
            ItemModelsProperties.func_239418_a_((Item)item.get(), (ResourceLocation)id, (IItemPropertyGetter)getter);
        }
    }

    private static void registerContainers() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.COMPUTER.get()), GuiComputer::create);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.POCKET_COMPUTER.get()), GuiComputer::createPocket);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.POCKET_COMPUTER_NO_TERM.get()), NoTermComputerScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.TURTLE.get()), GuiTurtle::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.PRINTER.get()), GuiPrinter::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.DISK_DRIVE.get()), GuiDiskDrive::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.PRINTOUT.get()), GuiPrintout::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.VIEW_COMPUTER.get()), GuiComputer::createView);
    }
}

