/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.filesystem;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;

final class FileAttributes
implements BasicFileAttributes {
    private static final FileTime EPOCH = FileTime.from(Instant.EPOCH);
    private final boolean isDirectory;
    private final long size;

    FileAttributes(boolean isDirectory, long size) {
        this.isDirectory = isDirectory;
        this.size = size;
    }

    @Override
    public FileTime lastModifiedTime() {
        return EPOCH;
    }

    @Override
    public FileTime lastAccessTime() {
        return EPOCH;
    }

    @Override
    public FileTime creationTime() {
        return EPOCH;
    }

    @Override
    public boolean isRegularFile() {
        return !this.isDirectory;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object fileKey() {
        return null;
    }
}

