/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinFactory;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.FactoryGenerator;
import codechicken.mixin.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.objectweb.asm.tree.ClassNode;

public class MixinFactoryImpl<B, F>
implements MixinFactory<B, F> {
    protected final AtomicInteger counter = new AtomicInteger();
    protected final List<BiConsumer<Class<? extends B>, ImmutableSet<MixinFactory.TraitKey>>> compileCallbacks = new ArrayList<BiConsumer<Class<? extends B>, ImmutableSet<MixinFactory.TraitKey>>>();
    protected final Map<ImmutableSet<MixinFactory.TraitKey>, Class<? extends B>> classCache = new HashMap<ImmutableSet<MixinFactory.TraitKey>, Class<? extends B>>();
    protected final Map<ImmutableSet<MixinFactory.TraitKey>, F> factoryCache = new HashMap<ImmutableSet<MixinFactory.TraitKey>, F>();
    protected final Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> traitLookup = new HashMap();
    protected final Map<String, MixinFactory.TraitKey> registeredTraits = new HashMap<String, MixinFactory.TraitKey>();
    protected final MixinCompiler mixinCompiler;
    protected final Class<B> baseType;
    protected final Class<F> factoryClass;
    protected final String classSuffix;
    protected final FactoryGenerator factoryGenerator;

    public MixinFactoryImpl(MixinCompiler mixinCompiler, Class<B> baseType, Class<F> factoryClass, String classSuffix) {
        this.mixinCompiler = mixinCompiler;
        this.baseType = baseType;
        this.factoryClass = factoryClass;
        this.classSuffix = classSuffix;
        this.factoryGenerator = new FactoryGenerator(mixinCompiler);
        this.factoryGenerator.findMethod(factoryClass);
    }

    @Override
    public MixinCompiler getMixinCompiler() {
        return this.mixinCompiler;
    }

    @Override
    public synchronized MixinFactory.TraitKey registerTrait(String tName) {
        ClassInfo baseInfo;
        MixinFactory.TraitKey key;
        ClassNode cNode = this.mixinCompiler.getClassNode(tName);
        if (cNode == null) {
            Utils.throwUnchecked(new ClassNotFoundException(tName));
        }
        if ((key = this.registeredTraits.get(tName)) != null) {
            return key;
        }
        ClassInfo info = this.mixinCompiler.getClassInfo(cNode);
        String parentName = info.concreteParent().orElseThrow(RuntimeException::new).getName();
        if (!this.checkParent(parentName, baseInfo = this.mixinCompiler.getClassInfo(this.baseType))) {
            throw new IllegalArgumentException("Trait '" + tName + "' with resolved parent '" + parentName + "' does not extend base type '" + Utils.asmName(this.baseType) + "'");
        }
        this.mixinCompiler.registerTrait(cNode);
        key = new TraitKeyImpl(tName);
        this.registeredTraits.put(tName, key);
        return key;
    }

    @Override
    public F construct(ImmutableSet<MixinFactory.TraitKey> traits) {
        return (F)this.factoryCache.computeIfAbsent(traits, this::compile);
    }

    @Override
    public ImmutableSet<MixinFactory.TraitKey> getTraitsForClass(Class<?> clazz) {
        return this.traitLookup.get(clazz);
    }

    @Override
    public void addCompilationCallback(BiConsumer<Class<? extends B>, ImmutableSet<MixinFactory.TraitKey>> callback) {
        this.compileCallbacks.add(callback);
    }

    private boolean checkParent(String parentName, ClassInfo info) {
        return info.getName().equals(parentName) || info.getSuperClass().filter(e -> this.checkParent(parentName, (ClassInfo)e)).isPresent();
    }

    private synchronized F compile(ImmutableSet<MixinFactory.TraitKey> traits) {
        Class clazz = this.classCache.computeIfAbsent(traits, e -> {
            Set traitNames = (Set)traits.stream().map(MixinFactory.TraitKey::getTName).collect(ImmutableSet.toImmutableSet());
            Class compiled = this.mixinCompiler.compileMixinClass(this.nextName(), Utils.asmName(this.baseType), traitNames);
            this.traitLookup.put(compiled, traits);
            this.compileCallbacks.forEach(callback -> callback.accept(compiled, traits));
            return compiled;
        });
        return this.factoryGenerator.generateFactory(clazz, this.factoryClass);
    }

    private String nextName() {
        return this.baseType.getSimpleName() + "_" + this.classSuffix + "$$" + this.counter.getAndIncrement();
    }

    private static class TraitKeyImpl
    implements MixinFactory.TraitKey {
        private final String tName;

        private TraitKeyImpl(String tName) {
            this.tName = tName;
        }

        @Override
        public String getTName() {
            return this.tName;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (!(obj instanceof TraitKeyImpl)) {
                return false;
            }
            TraitKeyImpl other = (TraitKeyImpl)obj;
            return Objects.equals(this.getTName(), other.getTName());
        }

        public int hashCode() {
            return Objects.hash(this.tName);
        }
    }
}

