/*
 * Decompiled with CFR 0.152.
 */
package me.cael.capes;

import com.mojang.authlib.GameProfile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.cael.capes.CapeConfig;
import me.cael.capes.Capes;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lme/cael/capes/CapeType;", "", "stylized", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getStylized", "()Ljava/lang/String;", "cycle", "getText", "Lnet/minecraft/text/Text;", "getToggleText", "enabled", "", "getURL", "profile", "Lcom/mojang/authlib/GameProfile;", "MINECRAFT", "OPTIFINE", "LABYMOD", "WYNNTILS", "MINECRAFTCAPES", "COSMETICA", "CLOAKSPLUS", "capes"})
public final class CapeType
extends Enum<CapeType> {
    @NotNull
    private final String stylized;
    public static final /* enum */ CapeType MINECRAFT = new CapeType("Minecraft");
    public static final /* enum */ CapeType OPTIFINE = new CapeType("OptiFine");
    public static final /* enum */ CapeType LABYMOD = new CapeType("LabyMod");
    public static final /* enum */ CapeType WYNNTILS = new CapeType("Wynntils");
    public static final /* enum */ CapeType MINECRAFTCAPES = new CapeType("MinecraftCapes");
    public static final /* enum */ CapeType COSMETICA = new CapeType("Cosmetica");
    public static final /* enum */ CapeType CLOAKSPLUS = new CapeType("Cloaks+");
    private static final /* synthetic */ CapeType[] $VALUES;

    private CapeType(String stylized) {
        this.stylized = stylized;
    }

    @NotNull
    public final String getStylized() {
        return this.stylized;
    }

    @NotNull
    public final CapeType cycle() {
        CapeType capeType;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                capeType = OPTIFINE;
                break;
            }
            case 2: {
                capeType = LABYMOD;
                break;
            }
            case 3: {
                capeType = WYNNTILS;
                break;
            }
            case 4: {
                capeType = COSMETICA;
                break;
            }
            case 5: {
                capeType = MINECRAFTCAPES;
                break;
            }
            case 6: {
                capeType = CLOAKSPLUS;
                break;
            }
            case 7: {
                capeType = MINECRAFT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return capeType;
    }

    @Nullable
    public final String getURL(@NotNull GameProfile profile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        CapeConfig config = Capes.INSTANCE.getCONFIG();
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 2: {
                if (config.getEnableOptifine()) {
                    string = "http://s.optifine.net/capes/" + profile.getName() + ".png";
                    break;
                }
                string = null;
                break;
            }
            case 3: {
                if (config.getEnableLabyMod()) {
                    string = "https://dl.labymod.net/capes/" + profile.getId();
                    break;
                }
                string = null;
                break;
            }
            case 4: {
                if (config.getEnableWynntils()) {
                    string = "https://athena.wynntils.com/user/getInfo";
                    break;
                }
                string = null;
                break;
            }
            case 5: {
                if (config.getEnableCosmetica()) {
                    string = "https://api.cosmetica.cc/get/cloak?username=" + profile.getName() + "&uuid=" + profile.getId() + "&nothirdparty";
                    break;
                }
                string = null;
                break;
            }
            case 6: {
                if (config.getEnableMinecraftCapesMod()) {
                    StringBuilder stringBuilder = new StringBuilder().append("https://api.minecraftcapes.net/profile/");
                    String string2 = profile.getId().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"profile.id.toString()");
                    string = stringBuilder.append(StringsKt.replace$default((String)string2, (String)"-", (String)"", (boolean)false, (int)4, null)).toString();
                    break;
                }
                string = null;
                break;
            }
            case 7: {
                if (config.getEnableCloaksPlus()) {
                    string = "http://161.35.130.99/capes/" + profile.getName() + ".png";
                    break;
                }
                string = null;
                break;
            }
            case 1: {
                string = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final class_2561 getToggleText(boolean enabled) {
        class_5250 class_52502 = class_5244.method_30619((class_2561)class_2561.method_30163((String)this.stylized), (boolean)enabled);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"composeToggleText(Text.of(stylized), enabled)");
        return (class_2561)class_52502;
    }

    @NotNull
    public final class_2561 getText() {
        Object[] objectArray = new Object[]{this.stylized};
        class_5250 class_52502 = class_2561.method_43469((String)"options.capes.capetype", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(\"options.capes.capetype\", stylized)");
        return (class_2561)class_52502;
    }

    public static CapeType[] values() {
        return (CapeType[])$VALUES.clone();
    }

    public static CapeType valueOf(String value) {
        return Enum.valueOf(CapeType.class, value);
    }

    static {
        $VALUES = capeTypeArray = new CapeType[]{CapeType.MINECRAFT, CapeType.OPTIFINE, CapeType.LABYMOD, CapeType.WYNNTILS, CapeType.MINECRAFTCAPES, CapeType.COSMETICA, CapeType.CLOAKSPLUS};
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CapeType.values().length];
            try {
                nArray[CapeType.MINECRAFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CapeType.OPTIFINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CapeType.LABYMOD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CapeType.WYNNTILS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CapeType.COSMETICA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CapeType.MINECRAFTCAPES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CapeType.CLOAKSPLUS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

