/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.xpple.clientarguments.arguments.CIdentifierArgumentType;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.arguments.CRecipeSuggestionProvider;
import net.jsa2025.calcmod.commands.arguments.RecipeSuggestionProvider;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2371;
import net.minecraft.class_5455;
import net.minecraft.class_7157;

public class Craft {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LCraft:\u00a7r\u00a7f\nGiven a desired item and the quantity to be crafted \u00a77\u00a7o(can be in expression form)\u00a7r\u00a7f, returns the amounts of the items needed to craft the amount of the desired item.\n    \u00a7eUsage: /calc craft <item> <amount>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command, class_7157 registry) {
        command.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"craft").then(ClientCommandManager.argument((String)"item", (ArgumentType)CIdentifierArgumentType.identifier()).suggests((SuggestionProvider)new CRecipeSuggestionProvider()).then(ClientCommandManager.argument((String)"amount", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Craft.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), CIdentifierArgumentType.getCRecipeArgument((CommandContext)ctx, (String)"item"), StringArgumentType.getString((CommandContext)ctx, (String)"amount"), ((FabricClientCommandSource)ctx.getSource()).method_30497());
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("craft");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command, class_7157 registry) {
        command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"craft").then(class_2170.method_9244((String)"item", (ArgumentType)class_2232.method_9441()).suggests((SuggestionProvider)new RecipeSuggestionProvider()).then(class_2170.method_9244((String)"amount", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Craft.execute(((class_2168)ctx.getSource()).method_9228(), class_2232.method_9442((CommandContext)ctx, (String)"item"), StringArgumentType.getString((CommandContext)ctx, (String)"amount"), ((class_2168)ctx.getSource()).method_30497());
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("craft");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_1297 player, class_1860 item, String amount, class_5455 registryManager) {
        class_2371 is = item.method_8117();
        int outputSize = item.method_8110(registryManager).method_7947();
        double inputAmount = Math.floor(CalcCommand.getParsedExpression(player, amount, new Integer[0]));
        int a = (int)Math.ceil(inputAmount / (double)outputSize);
        HashMap<String, Integer> ingredients = new HashMap<String, Integer>();
        HashMap<String, class_1799> ingredientsStacks = new HashMap<String, class_1799>();
        for (Object i : is) {
            class_1856 ingredient = (class_1856)i;
            if (ingredient.method_8105().length <= 0) continue;
            if (ingredients.containsKey(ingredient.method_8105()[0].method_7964().getString())) {
                ingredients.put(ingredient.method_8105()[0].method_7964().getString(), (Integer)ingredients.get(ingredient.method_8105()[0].method_7964().getString()) + a);
                continue;
            }
            ingredients.put(ingredient.method_8105()[0].method_7964().getString(), a);
            ingredientsStacks.put(ingredient.method_8105()[0].method_7964().getString(), ingredient.method_8105()[0]);
        }
        CalcMessageBuilder messageBuilder = new CalcMessageBuilder().addFromArray(new String[]{"Ingredients to craft ", "input", " ", "input", ": \n"}, new String[]{nf.format(inputAmount), item.method_8110(registryManager).method_7964().getString()}, new String[0]);
        for (Map.Entry entry : ingredients.entrySet()) {
            String key = (String)entry.getKey();
            Integer value = (Integer)entry.getValue();
            int stackSize = ((class_1799)ingredientsStacks.get(entry.getKey())).method_7914();
            double sb = Math.floor(value / (stackSize * 27));
            String sbString = nf.format(sb);
            int remainder = value % (stackSize * 27);
            double stacks = Math.floor(remainder / stackSize);
            String stacksString = nf.format(stacks);
            String items = nf.format(remainder %= stackSize);
            if (sb > 0.0) {
                messageBuilder.addString(key + ": ");
                messageBuilder.addResult("SBs: " + sbString + ", Stacks: " + stacksString + ", Items: " + items + "\n");
                continue;
            }
            if (stacks > 0.0) {
                messageBuilder.addString(key + ": ");
                messageBuilder.addResult("Stacks: " + stacksString + ", Items: " + items + "\n");
                continue;
            }
            messageBuilder.addString(key + ": ");
            messageBuilder.addResult("Items: " + items + "\n");
        }
        return messageBuilder;
    }
}

