/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.node;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.config.CableConfig;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredConstructorTileEntity;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.Position;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredConstructorNetworkNode
extends TieredNetworkNode<TieredConstructorNetworkNode>
implements IComparable,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DROP = "Drop";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private static final int SPEED_INCREASE = 4;
    private final BaseItemHandler itemFilters = new BaseItemHandler(this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.checkTierUpgrades()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private int compare = 1;
    private int type = 0;
    private boolean drop = false;
    private CoverManager coverManager = new CoverManager((NetworkNode)this);

    public TieredConstructorNetworkNode(World world, BlockPos pos, CableTier tier) {
        super(world, pos, ContentType.CONSTRUCTOR, tier);
    }

    private UpgradeItem.Type[] checkTierUpgrades() {
        if (this.getTier() == CableTier.ELITE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK, UpgradeItem.Type.CRAFTING};
        }
        if (this.getTier() == CableTier.ULTRA) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING};
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.CRAFTING};
        }
        return null;
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 4 * (RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 4 * (RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4 * (RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    public void update() {
        int baseSpeed;
        int speed;
        super.update();
        if (!(this.canUpdate() && this.world.func_195588_v(this.pos) && this.world.func_195588_v(this.pos.func_177972_a(this.getDirection())))) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && (speed = Math.max(1, this.upgrades.getSpeed(baseSpeed = 20 / this.getSpeedMultiplier(), 4))) > 1 && this.ticks % speed != 0) {
            return;
        }
        for (int i = 0; i < this.itemFilters.getSlots(); ++i) {
            if (this.type == 0 && !this.itemFilters.getStackInSlot(i).func_190926_b()) {
                ItemStack stack = this.itemFilters.getStackInSlot(i);
                if (this.drop) {
                    this.extractAndDropItem(stack);
                    continue;
                }
                if (stack.func_77973_b() == Items.field_196152_dE) {
                    this.extractAndSpawnFireworks(stack);
                    continue;
                }
                if (!(stack.func_77973_b() instanceof BlockItem)) continue;
                this.extractAndPlaceBlock(stack);
                continue;
            }
            if (this.type != 1 || this.fluidFilters.getFluid(i).isEmpty()) continue;
            this.extractAndPlaceFluid(this.fluidFilters.getFluid(i));
        }
    }

    private int getSpeedMultiplier() {
        switch (this.getTier()) {
            case ELITE: {
                return (Integer)CableConfig.ELITE_CONSTRUCTOR_SPEED.get();
            }
            case ULTRA: {
                return (Integer)CableConfig.ULTRA_CONSTRUCTOR_SPEED.get();
            }
        }
        throw new RuntimeException("illegal tier " + (Object)((Object)this.getTier()));
    }

    private boolean interactWithStacks() {
        return this.getTier() != CableTier.ELITE || this.upgrades.hasUpgrade(UpgradeItem.Type.STACK);
    }

    private void extractAndPlaceFluid(FluidStack stack) {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        for (int x = 0; x < this.network.extractFluid(stack, 1000, this.compare, Action.SIMULATE).getAmount(); ++x) {
            if (this.network.extractFluid(stack, 1000, this.compare, Action.SIMULATE).getAmount() < 1000) {
                if (!this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) continue;
                this.network.getCraftingManager().request((Object)this, stack, 1000);
                continue;
            }
            if (this.world.func_180495_p(front).func_204520_s().func_206889_d()) continue;
            FluidUtil.tryPlaceFluid((PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)((ServerWorld)this.world), (UUID)this.getOwner()), (World)this.world, (Hand)Hand.MAIN_HAND, (BlockPos)front, (IFluidHandler)new NetworkFluidHandler(StackUtils.copy((FluidStack)stack, (int)1000)), (FluidStack)stack);
        }
    }

    private void extractAndPlaceBlock(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, 1, this.compare, Action.SIMULATE);
        if (!took.func_190926_b()) {
            BlockItemUseContext ctx = new BlockItemUseContext(this.world, (PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)((ServerWorld)this.world), (UUID)this.getOwner()), Hand.MAIN_HAND, took, new BlockRayTraceResult(Vector3d.field_186680_a, this.getDirection(), this.pos, false));
            ActionResultType result = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)ctx);
            if (result.func_226246_a_()) {
                this.network.extractItem(stack, 1, Action.PERFORM);
            }
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            this.network.getCraftingManager().request((Object)this, stack, 1);
        }
    }

    private void extractAndDropItem(ItemStack stack) {
        int interactionCount = this.interactWithStacks() ? stack.func_77976_d() : 1;
        ItemStack took = this.network.extractItem(stack, interactionCount, this.compare, Action.PERFORM);
        if (!took.func_190926_b()) {
            DefaultDispenseItemBehavior.func_82486_a((World)this.world, (ItemStack)took, (int)6, (Direction)this.getDirection(), (IPosition)new Position(this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ()));
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            this.network.getCraftingManager().request((Object)this, stack, 1);
        }
    }

    private void extractAndSpawnFireworks(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, 1, this.compare, Action.PERFORM);
        if (!took.func_190926_b()) {
            this.world.func_217376_c((Entity)new FireworkRocketEntity(this.world, this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ(), took));
        }
    }

    private double getDispensePositionX() {
        return (double)this.pos.func_177958_n() + 0.5 + 0.8 * (double)this.getDirection().func_82601_c();
    }

    private double getDispensePositionY() {
        return (double)this.pos.func_177956_o() + (this.getDirection() == Direction.DOWN ? 0.45 : 0.5) + 0.8 * (double)this.getDirection().func_96559_d();
    }

    private double getDispensePositionZ() {
        return (double)this.pos.func_177952_p() + 0.5 + 0.8 * (double)this.getDirection().func_82599_e();
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_DROP, this.drop);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_DROP)) {
            this.drop = tag.func_74767_n(NBT_DROP);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TieredConstructorTileEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    private class NetworkFluidHandler
    implements IFluidHandler {
        private final FluidStack resource;

        public NetworkFluidHandler(FluidStack resource) {
            this.resource = resource;
        }

        public int getTanks() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            throw new UnsupportedOperationException();
        }

        public int getTankCapacity(int tank) {
            throw new UnsupportedOperationException();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            throw new UnsupportedOperationException();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return TieredConstructorNetworkNode.this.network.extractFluid(resource, resource.getAmount(), TieredConstructorNetworkNode.this.compare, action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return TieredConstructorNetworkNode.this.network.extractFluid(this.resource, this.resource.getAmount(), TieredConstructorNetworkNode.this.compare, action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }
    }
}

