/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.concurrent;

import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ServerTickingScheduler {
    private final BooleanSupplier runnable;
    private final EnumSet<TickEvent.Phase> phases;

    public static void runTicked(BooleanSupplier runUntilFalse) {
        new ServerTickingScheduler(runUntilFalse, EnumSet.of(TickEvent.Phase.START));
    }

    public static void runTickedAtEnd(BooleanSupplier runUntilFalse) {
        new ServerTickingScheduler(runUntilFalse, EnumSet.of(TickEvent.Phase.END));
    }

    public static void runTickedStartAndEnd(BooleanSupplier runUntilFalse) {
        new ServerTickingScheduler(runUntilFalse, EnumSet.allOf(TickEvent.Phase.class));
    }

    public static void runOnServerOnce(Runnable runnable) {
        ServerTickingScheduler.runTickedStartAndEnd(() -> {
            runnable.run();
            return false;
        });
    }

    private ServerTickingScheduler(BooleanSupplier runnable, EnumSet<TickEvent.Phase> phases) {
        this.runnable = runnable;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.phases = phases;
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (!this.phases.contains(event.phase)) {
            return;
        }
        if (!this.runnable.getAsBoolean()) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

