/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.network;

import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.tileentity.base.BaseInstrument;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayNotePacket {
    private BlockPos pos;
    private int note;

    public PlayNotePacket(BlockPos pos, int note) {
        this.pos = pos;
        this.note = note;
    }

    public static void encode(PlayNotePacket packet, PacketBuffer tag) {
        tag.func_179255_a(packet.pos);
        tag.writeInt(packet.note);
    }

    public static PlayNotePacket decode(PacketBuffer buf) {
        PlayNotePacket scp = new PlayNotePacket(buf.func_179259_c(), buf.readInt());
        return scp;
    }

    public static void handle(PlayNotePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    PlayNotePacket.sendUpdate(pkt.pos, player, pkt.note);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void sendUpdate(BlockPos pos, ServerPlayerEntity player, int note) {
        if (!((Boolean)Config.MIDI_ENABLED.get()).booleanValue()) {
            return;
        }
        BaseInstrument te = (BaseInstrument)player.field_70170_p.func_175625_s(pos);
        if (te != null) {
            te.playNote(note);
            SUpdateTileEntityPacket supdatetileentitypacket = te.func_189518_D_();
            if (supdatetileentitypacket != null) {
                player.field_71135_a.func_147359_a((IPacket)supdatetileentitypacket);
            }
        }
    }
}

