/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.blocks.base.ISeat;
import com.mrh0.buildersaddition.entity.SeatEntity;
import com.mrh0.buildersaddition.state.SofaState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Sofa
extends BaseDerivativeBlock
implements ISeat {
    public static final EnumProperty<SofaState> STATE = EnumProperty.func_177709_a((String)"state", SofaState.class);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape SHAPE_BASE = Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_BACK_NORTH = Block.func_208617_a((double)0.0, (double)9.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_BACK_EAST = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_BACK_SOUTH = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape SHAPE_BACK_WEST = Block.func_208617_a((double)12.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_ARM_NORTH = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
    protected static final VoxelShape SHAPE_ARM_EAST = Block.func_208617_a((double)14.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_ARM_SOUTH = Block.func_208617_a((double)0.0, (double)9.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_ARM_WEST = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0);

    public Sofa(String name) {
        super("sofa_" + name, Blocks.field_196556_aL);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)SofaState.Both))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE, FACING});
    }

    private VoxelShape getArm(Direction dir) {
        switch (dir) {
            case NORTH: {
                return SHAPE_ARM_NORTH;
            }
            case EAST: {
                return SHAPE_ARM_EAST;
            }
            case SOUTH: {
                return SHAPE_ARM_SOUTH;
            }
            case WEST: {
                return SHAPE_ARM_WEST;
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape getShape(BlockState state) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        SofaState s = (SofaState)((Object)state.func_177229_b(STATE));
        Direction d = (Direction)state.func_177229_b((Property)FACING);
        if (s == SofaState.Left) {
            shape = this.getArm(d.func_176746_e().func_176746_e().func_176746_e());
        }
        if (s == SofaState.Right) {
            shape = this.getArm(d.func_176746_e());
        }
        if (s == SofaState.Both) {
            shape = VoxelShapes.func_197872_a((VoxelShape)this.getArm(d.func_176746_e()), (VoxelShape)this.getArm(d.func_176746_e().func_176746_e().func_176746_e()));
        }
        switch (d) {
            case EAST: {
                return VoxelShapes.func_216384_a((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_EAST, shape});
            }
            case NORTH: {
                return VoxelShapes.func_216384_a((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_NORTH, shape});
            }
            case SOUTH: {
                return VoxelShapes.func_216384_a((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_SOUTH, shape});
            }
            case WEST: {
                return VoxelShapes.func_216384_a((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_WEST, shape});
            }
        }
        return SHAPE_BASE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public boolean connects(Direction current, IWorld worldIn, BlockPos pos, Direction dir, boolean disCheck) {
        BlockState adj = worldIn.func_180495_p(pos.func_177972_a(dir));
        if (adj.func_177230_c() instanceof Sofa) {
            SofaState s = (SofaState)((Object)adj.func_177229_b(STATE));
            Direction sd = (Direction)adj.func_177229_b((Property)FACING);
            if ((s == SofaState.Both || current == sd && dir == current.func_176746_e() && s == SofaState.Left || current == sd && dir == current.func_176735_f() && s == SofaState.Right) && !disCheck) {
                return false;
            }
            return current == adj.func_177229_b((Property)FACING);
        }
        return false;
    }

    public BlockState getState(Direction dir, IWorld worldIn, BlockPos pos, boolean disCheck) {
        boolean l = this.connects(dir, worldIn, pos, dir.func_176746_e(), disCheck);
        boolean r = this.connects(dir, worldIn, pos, dir.func_176735_f(), disCheck);
        if (l && !r) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)SofaState.Left))).func_206870_a((Property)FACING, (Comparable)dir);
        }
        if (!l && r) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)SofaState.Right))).func_206870_a((Property)FACING, (Comparable)dir);
        }
        if (l && r) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)SofaState.None))).func_206870_a((Property)FACING, (Comparable)dir);
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)SofaState.Both))).func_206870_a((Property)FACING, (Comparable)dir);
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        if (c.func_225518_g_()) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)c.func_195992_f().func_176734_d())).func_206870_a(STATE, (Comparable)((Object)SofaState.Both));
        }
        return this.getState(c.func_195992_f().func_176734_d(), (IWorld)c.func_195991_k(), c.func_195995_a(), true);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos otherPos) {
        return this.getState((Direction)stateIn.func_177229_b((Property)FACING), worldIn, pos, false);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return SeatEntity.createSeat(worldIn, pos, (LivingEntity)player, SoundEvents.field_187550_ag);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.func_226860_a_(entityIn);
        }
    }

    private void func_226860_a_(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * (double)0.66f * d0, vector3d.field_72449_c);
        }
    }
}

