/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.state.ShopSignState;
import com.mrh0.buildersaddition.tileentity.ShopSignTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ShopSign
extends BaseDerivativeBlock {
    public static final EnumProperty<ShopSignState> STATE = EnumProperty.func_177709_a((String)"state", ShopSignState.class);
    private static VoxelShape SHAPE_DOWN_X = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)14.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)14.0, (double)6.0, (double)4.0, (double)16.0, (double)10.0), Block.func_208617_a((double)12.0, (double)14.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0)});
    private static VoxelShape SHAPE_DOWN_Z = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)14.0, (double)2.0, (double)10.0, (double)16.0, (double)4.0), Block.func_208617_a((double)6.0, (double)14.0, (double)12.0, (double)10.0, (double)16.0, (double)14.0)});
    private static VoxelShape SHAPE_UP_X = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)2.0, (double)7.0, (double)15.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)6.0, (double)4.0, (double)2.0, (double)10.0), Block.func_208617_a((double)12.0, (double)0.0, (double)6.0, (double)14.0, (double)2.0, (double)10.0)});
    private static VoxelShape SHAPE_UP_Z = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.0, (double)2.0, (double)1.0, (double)9.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0, (double)4.0), Block.func_208617_a((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)2.0, (double)14.0)});
    private static VoxelShape SHAPE_NORTH = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)4.0, (double)16.0), Block.func_208617_a((double)6.0, (double)12.0, (double)14.0, (double)10.0, (double)14.0, (double)16.0)});
    private static VoxelShape SHAPE_EAST = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)2.0, (double)6.0, (double)2.0, (double)4.0, (double)10.0), Block.func_208617_a((double)0.0, (double)12.0, (double)6.0, (double)2.0, (double)14.0, (double)10.0)});
    private static VoxelShape SHAPE_SOUTH = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)2.0, (double)9.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)4.0, (double)2.0), Block.func_208617_a((double)6.0, (double)12.0, (double)0.0, (double)10.0, (double)14.0, (double)2.0)});
    private static VoxelShape SHAPE_WEST = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)7.0, (double)14.0, (double)15.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)14.0, (double)2.0, (double)6.0, (double)16.0, (double)4.0, (double)10.0), Block.func_208617_a((double)14.0, (double)12.0, (double)6.0, (double)16.0, (double)14.0, (double)10.0)});
    private static VoxelShape SHAPE_NORTH_PILLAR = SHAPE_NORTH.func_197751_a(0.0, 0.0, 0.125);
    private static VoxelShape SHAPE_EAST_PILLAR = SHAPE_EAST.func_197751_a(-0.125, 0.0, 0.0);
    private static VoxelShape SHAPE_SOUTH_PILLAR = SHAPE_SOUTH.func_197751_a(0.0, 0.0, -0.125);
    private static VoxelShape SHAPE_WEST_PILLAR = SHAPE_WEST.func_197751_a(0.125, 0.0, 0.0);
    private static VoxelShape SHAPE_NORTH_FENCE = SHAPE_NORTH.func_197751_a(0.0, 0.0, 0.375);
    private static VoxelShape SHAPE_EAST_FENCE = SHAPE_EAST.func_197751_a(-0.375, 0.0, 0.0);
    private static VoxelShape SHAPE_SOUTH_FENCE = SHAPE_SOUTH.func_197751_a(0.0, 0.0, -0.375);
    private static VoxelShape SHAPE_WEST_FENCE = SHAPE_WEST.func_197751_a(0.375, 0.0, 0.0);
    private static VoxelShape SHAPE_NORTH_WALL = SHAPE_NORTH.func_197751_a(0.0, 0.0, 0.25);
    private static VoxelShape SHAPE_EAST_WALL = SHAPE_EAST.func_197751_a(-0.25, 0.0, 0.0);
    private static VoxelShape SHAPE_SOUTH_WALL = SHAPE_SOUTH.func_197751_a(0.0, 0.0, -0.25);
    private static VoxelShape SHAPE_WEST_WALL = SHAPE_WEST.func_197751_a(0.25, 0.0, 0.0);

    public ShopSign(String name) {
        super("shop_sign_" + name, Blocks.field_196626_Q);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ShopSignTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE});
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)ShopSignState.getFor(c.func_196000_l(), c.func_195992_f().func_176746_e(), c.func_195995_a(), c.func_195991_k())));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShape((ShopSignState)((Object)state.func_177229_b(STATE)));
    }

    public VoxelShape getShape(ShopSignState state) {
        switch (state) {
            case Up_X: {
                return SHAPE_UP_X;
            }
            case Up_Z: {
                return SHAPE_UP_Z;
            }
            case Down_X: {
                return SHAPE_DOWN_X;
            }
            case Down_Z: {
                return SHAPE_DOWN_Z;
            }
            case North: {
                return SHAPE_NORTH;
            }
            case East: {
                return SHAPE_EAST;
            }
            case South: {
                return SHAPE_SOUTH;
            }
            case West: {
                return SHAPE_WEST;
            }
            case North_Pillar: {
                return SHAPE_NORTH_PILLAR;
            }
            case East_Pillar: {
                return SHAPE_EAST_PILLAR;
            }
            case South_Pillar: {
                return SHAPE_SOUTH_PILLAR;
            }
            case West_Pillar: {
                return SHAPE_WEST_PILLAR;
            }
            case North_Wall: {
                return SHAPE_NORTH_WALL;
            }
            case East_Wall: {
                return SHAPE_EAST_WALL;
            }
            case South_Wall: {
                return SHAPE_SOUTH_WALL;
            }
            case West_Wall: {
                return SHAPE_WEST_WALL;
            }
            case North_Fence: {
                return SHAPE_NORTH_FENCE;
            }
            case East_Fence: {
                return SHAPE_EAST_FENCE;
            }
            case South_Fence: {
                return SHAPE_SOUTH_FENCE;
            }
            case West_Fence: {
                return SHAPE_WEST_FENCE;
            }
        }
        return SHAPE_UP_Z;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof ShopSignTileEntity) {
            ShopSignTileEntity sste = (ShopSignTileEntity)te;
            ItemStack heald = player.func_184586_b(handIn);
            if (player.func_213453_ef()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)sste.getDisplayItem());
                sste.setDisplayItem(ItemStack.field_190927_a);
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                return ActionResultType.CONSUME;
            }
            if (heald != ItemStack.field_190927_a) {
                if (sste.hasDisplayItem()) {
                    return ActionResultType.PASS;
                }
                sste.setDisplayItem(heald);
                if (!player.func_184812_l_()) {
                    heald.func_190918_g(1);
                }
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            if (te instanceof ShopSignTileEntity) {
                ShopSignTileEntity sste = (ShopSignTileEntity)te;
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)sste.getDisplayItem());
            }
            te.func_145843_s();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }
}

