/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.config.Config;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Candle
extends BaseBlock {
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", p -> p != Direction.UP);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)13.0, (double)4.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)6.0, (double)3.0, (double)12.0, (double)10.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)3.0, (double)6.0, (double)4.0, (double)13.0, (double)10.0);
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)12.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    private IParticleData parts;

    public Candle(String name, IParticleData parts) {
        super(name, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150478_aa).func_235838_a_(s -> (Boolean)s.func_177229_b((Property)LIT) != false ? 15 : 0));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.parts = parts;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        if (c.func_196000_l() == Direction.DOWN || c.func_196000_l() == Direction.UP) {
            if (c.func_195999_j().func_184812_l_()) {
                return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACING, (Comparable)Direction.DOWN);
            }
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.DOWN);
        }
        if (c.func_195999_j().func_184812_l_()) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACING, (Comparable)c.func_196000_l().func_176746_e());
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)c.func_196000_l().func_176746_e());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack item = player.func_184586_b(handIn);
        boolean lit = (Boolean)state.func_177229_b((Property)LIT);
        if (player.func_184812_l_() || !((Boolean)Config.REQUIRE_FLINT_AND_STEEL.get()).booleanValue()) {
            if (!lit) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                if (!worldIn.func_201670_d()) {
                    worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
                }
            } else {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                if (!worldIn.func_201670_d()) {
                    worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
                }
            }
        } else if (item.func_190926_b()) {
            if (lit) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                if (!worldIn.func_201670_d()) {
                    worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
                }
            }
        } else if (item.func_77973_b() == Items.field_151033_d && !lit) {
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            if (!worldIn.func_201670_d()) {
                worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
                item.func_222118_a(1, (LivingEntity)player, e -> {});
            }
        }
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.CONSUME;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double x = 0.5;
        double y = 0.8125;
        double z = 0.5;
        double o = 0.1875;
        switch ((Direction)stateIn.func_177229_b((Property)FACING)) {
            case EAST: {
                z = 1.0 - o;
                break;
            }
            case NORTH: {
                x = 1.0 - o;
                break;
            }
            case SOUTH: {
                x = o;
                break;
            }
            case WEST: {
                z = o;
                break;
            }
            case DOWN: {
                y = 0.6875;
                break;
            }
        }
        if (!((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            return;
        }
        double d0 = (double)pos.func_177958_n() + x;
        double d1 = (double)pos.func_177956_o() + y;
        double d2 = (double)pos.func_177952_p() + z;
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
        worldIn.func_195594_a(this.parts, d0, d1, d2, 0.0, 0.0, 0.0);
    }
}

