/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.arcade.games;

import com.mrh0.buildersaddition.arcade.ArcadeGame;
import com.mrh0.buildersaddition.arcade.ArcadeManager;
import com.mrh0.buildersaddition.arcade.ArcadeScreen;
import com.mrh0.buildersaddition.gui.ArcadeGui;
import com.mrh0.buildersaddition.tileentity.ArcadeTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ArcadeMenu
extends ArcadeGame {
    public ArcadeGui gui = null;
    int selected;
    int size = ArcadeManager.instance.getGames().size();

    public ArcadeMenu(ArcadeScreen s, ArcadeTileEntity te) {
        super(s, te);
    }

    @Override
    public void start() {
        super.start();
        this.selected = 0;
        this.render();
    }

    private void logo() {
        String l1 = "  ___                    _      ";
        String l2 = " / _ \\                  | |     ";
        String l3 = "/ /_\\ \\_ __ ___ __ _  __| | ___ ";
        String l4 = "|  _  | '__/ __/ _` |/ _` |/ _ \\";
        String l5 = "| | | | | | (_| (_| | (_| |  __/";
        String l6 = "\\_| |_/_|  \\___\\__,_|\\__,_|\\___|";
        int x = this.s.width / 2 - l4.length() / 2;
        this.s.print(x, 0, l1);
        this.s.print(x, 1, l2);
        this.s.print(x, 2, l3);
        this.s.print(x, 3, l4);
        this.s.print(x, 4, l5);
        this.s.print(x, 5, l6);
        this.s.print(1, this.s.height - 3, (ITextComponent)new TranslationTextComponent("arcade.buildersaddition.menu.select"));
        this.s.print(1, this.s.height - 2, (ITextComponent)new TranslationTextComponent("arcade.buildersaddition.menu.start"));
    }

    private void render() {
        this.s.setColors(0, 15);
        this.s.clear();
        this.logo();
        for (int i = 0; i < this.size; ++i) {
            this.s.setColors(0, 15);
            if (this.selected == i) {
                this.s.setColors(0, 6);
            }
            this.s.print(1, i + 8, (this.selected == i ? ">" : " ") + ArcadeManager.instance.getGameName(i));
        }
    }

    @Override
    public void onKeyPressed(int key) {
        super.onKeyPressed(key);
        if (ArcadeMenu.isUp(key) && this.selected > 0) {
            --this.selected;
        }
        if (ArcadeMenu.isDown(key) && this.selected < this.size - 1) {
            ++this.selected;
        }
        this.render();
        if (ArcadeMenu.isEnter(key) || ArcadeMenu.isSpace(key)) {
            System.out.println();
            if (this.gui != null) {
                this.gui.setGame(ArcadeManager.instance.getGame(this.selected));
            }
        }
    }
}

