/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.arcade;

import com.mrh0.buildersaddition.arcade.ArcadeGame;
import com.mrh0.buildersaddition.arcade.ArcadeScreen;
import com.mrh0.buildersaddition.arcade.games.ArcadeCredits;
import com.mrh0.buildersaddition.arcade.games.ArcadeSnake;
import com.mrh0.buildersaddition.tileentity.ArcadeTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ArcadeManager {
    public static ArcadeManager instance = null;
    private final ArrayList<GameConstructor> games;
    private final ArrayList<ITextComponent> names;

    public ArcadeManager() {
        if (instance == null) {
            instance = this;
        }
        this.games = new ArrayList();
        this.names = new ArrayList();
    }

    public void add(GameConstructor game, String key) {
        this.games.add(game);
        this.names.add((ITextComponent)new TranslationTextComponent("arcade.buildersaddition.game." + key));
    }

    public List<GameConstructor> getGames() {
        return this.games;
    }

    public GameConstructor getGame(int index) {
        return this.games.get(index);
    }

    public String getGameName(int index) {
        return this.names.get(index).getString();
    }

    public static void init() {
        new ArcadeManager();
        instance.add(ArcadeSnake::new, "snake");
        instance.add(ArcadeCredits::new, "credits");
    }

    public static interface GameConstructor {
        public ArcadeGame construct(ArcadeScreen var1, ArcadeTileEntity var2);
    }
}

