/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.items.buddysteel;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.wildcard.buddycards.BuddyCards;
import com.wildcard.buddycards.client.models.PerfectBuddysteelArmorModel;
import com.wildcard.buddycards.items.buddysteel.BuddysteelArmorMaterial;
import com.wildcard.buddycards.util.BuddysteelGearHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BuddysteelArmorItem
extends ArmorItem {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final int[][] DAMAGE_REDUCTION_ARRAY = new int[][]{{1, 4, 5, 2}, {2, 5, 6, 2}, {3, 6, 8, 3}, {4, 7, 9, 4}, {5, 8, 10, 5}};

    public BuddysteelArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot) {
        super(materialIn, slot, new Item.Properties().func_200916_a(BuddyCards.TAB));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BuddysteelGearHelper.addInformation(stack, tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.field_200882_e.equals((Object)BuddysteelArmorMaterial.BUDDYSTEEL) ? Rarity.UNCOMMON : Rarity.EPIC;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BuddysteelGearHelper.setTag(playerIn, handIn);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == this.func_185083_B_() && stack.func_77942_o()) {
            multimap = LinkedHashMultimap.create();
            UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
            float ratio = 0.0f;
            if (stack.func_77978_p().func_74764_b("completion")) {
                ratio = stack.func_77978_p().func_74760_g("completion");
            }
            int perfect = this.field_200882_e.equals((Object)BuddysteelArmorMaterial.BUDDYSTEEL) ? 0 : 1;
            multimap.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)DAMAGE_REDUCTION_ARRAY[(int)(3.0f * ratio) + perfect][slot.func_188454_b()], AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)((int)(ratio * 2.0f) + perfect), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (this.field_200882_e.equals((Object)BuddysteelArmorMaterial.PERFECT_BUDDYSTEEL)) {
            return "buddycards:textures/models/armor/perfect_buddysteel.png";
        }
        if (this.field_200882_e.equals((Object)BuddysteelArmorMaterial.ZYLEX)) {
            return "buddycards:textures/models/armor/zylex.png";
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (this.field_200882_e.equals((Object)BuddysteelArmorMaterial.PERFECT_BUDDYSTEEL) || this.field_200882_e.equals((Object)BuddysteelArmorMaterial.ZYLEX)) {
            return (A)((Object)new PerfectBuddysteelArmorModel(this.field_77881_a));
        }
        return (A)super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }
}

