/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.items;

import com.wildcard.buddycards.BuddyCards;
import com.wildcard.buddycards.registries.BuddycardsItems;
import com.wildcard.buddycards.registries.BuddycardsMisc;
import com.wildcard.buddycards.util.ConfigManager;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class CardItem
extends Item {
    public final int SET_NUMBER;
    public final int CARD_NUMBER;
    private final Rarity RARITY;
    private final String MOD_ID;

    public CardItem(int setNumber, int cardNumber, Rarity rarity, String modId) {
        super(new Item.Properties().func_200916_a(BuddyCards.CARDS_TAB));
        this.SET_NUMBER = setNumber;
        this.CARD_NUMBER = cardNumber;
        this.RARITY = rarity;
        this.MOD_ID = modId;
    }

    public CardItem(int setNumber, int cardNumber, Rarity rarity, String modId, Item.Properties properties) {
        super(properties);
        this.SET_NUMBER = setNumber;
        this.CARD_NUMBER = cardNumber;
        this.RARITY = rarity;
        this.MOD_ID = modId;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.buddycards.card." + this.SET_NUMBER + "." + this.CARD_NUMBER + ".tooltip"));
        TranslationTextComponent cn = new TranslationTextComponent("item.buddycards.number_separator");
        cn.func_240702_b_("" + this.CARD_NUMBER);
        if (this.func_77636_d(stack)) {
            cn.func_230529_a_((ITextComponent)new TranslationTextComponent("item.buddycards.shiny_symbol"));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("item.buddycards.set." + this.SET_NUMBER).func_230529_a_((ITextComponent)cn));
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("grade") != 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.buddycards.grade_info").func_230529_a_((ITextComponent)new TranslationTextComponent("item.buddycards.grade_" + stack.func_77978_p().func_74762_e("grade"))));
        }
        if (((Boolean)ConfigManager.challengeMode.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.buddycards.points_info").func_240702_b_("" + ((CardItem)stack.func_77973_b()).getPointValue(stack)));
        }
        if (stack.func_77973_b().getRegistryName().toString().endsWith("s")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.buddycards.foil_warning"));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("foil") && stack.func_77978_p().func_74767_n("foil");
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.RARITY;
    }

    public Rarity getRarity() {
        return this.RARITY;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!ModList.get().isLoaded(this.MOD_ID)) {
            return;
        }
        super.func_150895_a(group, items);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn instanceof ServerWorld && playerIn.func_184586_b(handIn).func_77973_b().getRegistryName().toString().endsWith("s")) {
            CompoundNBT nbt = new CompoundNBT();
            if (playerIn.func_184586_b(handIn).func_77942_o()) {
                nbt = playerIn.func_184586_b(handIn).func_77978_p();
            }
            nbt.func_74757_a("foil", true);
            int count = playerIn.func_184586_b(handIn).func_190916_E();
            String name = playerIn.func_184586_b(handIn).func_77973_b().getRegistryName().toString();
            ItemStack card = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name.substring(0, name.length() - 1))), count);
            playerIn.func_184586_b(handIn).func_190918_g(count);
            card.func_77982_d(nbt);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)card);
        }
        if (handIn == Hand.MAIN_HAND) {
            return this.tryGrade((Item)BuddycardsItems.GRADING_SLEEVE.get(), worldIn, playerIn, handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResult<ItemStack> tryGrade(Item gradingSleeve, World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (playerIn.func_184586_b(Hand.OFF_HAND).func_77973_b().equals(gradingSleeve)) {
            CompoundNBT nbt = playerIn.func_184586_b(handIn).func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if (nbt.func_74762_e("grade") == 0) {
                playerIn.func_184586_b(Hand.OFF_HAND).func_190918_g(1);
                int i = (int)(Math.random() * 500.0) + 1;
                int k = 0;
                if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosHelper().findEquippedCurio((Item)BuddycardsItems.ZYLEX_RING.get(), (LivingEntity)playerIn).isPresent() && ((ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)((Item)BuddycardsItems.ZYLEX_RING.get()), (LivingEntity)playerIn).get()).right).func_77973_b().equals(BuddycardsItems.ZYLEX_RING.get())) {
                    ++k;
                }
                if (playerIn.func_70644_a((Effect)BuddycardsMisc.GRADING_LUCK.get())) {
                    k += playerIn.func_70660_b((Effect)BuddycardsMisc.GRADING_LUCK.get()).func_76458_c();
                }
                if (k > 0) {
                    for (int j = 0; j <= k && i < 400; ++j) {
                        i = (int)(Math.random() * 500.0) + 1;
                    }
                }
                int grade = i < 200 ? 1 : (i < 360 ? 2 : (i < 450 ? 3 : (i < 500 ? 4 : 5)));
                nbt.func_74768_a("grade", grade);
                ItemStack card = new ItemStack((IItemProvider)playerIn.func_184586_b(handIn).func_77973_b(), 1);
                card.func_77982_d(nbt);
                playerIn.func_184586_b(handIn).func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)card);
                return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public int getPointValue(ItemStack card) {
        double points = 0.0;
        points = card.func_77953_t() == Rarity.COMMON ? (double)((Integer)ConfigManager.challengePointsCommon.get()).intValue() : (card.func_77953_t() == Rarity.UNCOMMON ? (double)((Integer)ConfigManager.challengePointsUncommon.get()).intValue() : (card.func_77953_t() == Rarity.RARE ? (double)((Integer)ConfigManager.challengePointsRare.get()).intValue() : (double)((Integer)ConfigManager.challengePointsEpic.get()).intValue()));
        if (this.SET_NUMBER == 1) {
            points *= ((Double)ConfigManager.challengeSet1Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 2) {
            points *= ((Double)ConfigManager.challengeSet2Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 3) {
            points *= ((Double)ConfigManager.challengeSet3Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 4) {
            points *= ((Double)ConfigManager.challengeSet4Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 5) {
            points *= ((Double)ConfigManager.challengeSet5Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 6) {
            points *= ((Double)ConfigManager.challengeSet6Mult.get()).doubleValue();
        } else if (this.SET_NUMBER == 7) {
            points *= ((Double)ConfigManager.challengeSet7Mult.get()).doubleValue();
        }
        if (card.func_77978_p() != null) {
            int grade = card.func_77978_p().func_74762_e("grade");
            if (grade == 1) {
                points *= ((Double)ConfigManager.challengeGrade1Mult.get()).doubleValue();
            } else if (grade == 2) {
                points *= ((Double)ConfigManager.challengeGrade2Mult.get()).doubleValue();
            } else if (grade == 3) {
                points *= ((Double)ConfigManager.challengeGrade3Mult.get()).doubleValue();
            } else if (grade == 4) {
                points *= ((Double)ConfigManager.challengeGrade4Mult.get()).doubleValue();
            } else if (grade == 5) {
                points *= ((Double)ConfigManager.challengeGrade5Mult.get()).doubleValue();
            }
        }
        if (card.func_77962_s()) {
            points *= ((Double)ConfigManager.challengeShinyMult.get()).doubleValue();
        }
        return (int)(points + 0.5);
    }
}

