/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks.tiles;

import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;

public class CardDisplayTile
extends TileEntity
implements IClearable {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private boolean locked = false;
    private String player = "";

    public CardDisplayTile() {
        super((TileEntityType)BuddycardsEntities.CARD_DISPLAY_TILE.get());
    }

    public void putCardInSlot(ItemStack stack, int pos) {
        if (this.field_145850_b != null) {
            this.inventory.set(pos - 1, (Object)stack);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public ItemStack getCardInSlot(int pos) {
        return (ItemStack)this.inventory.get(pos - 1);
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean toggleLock(UUID playerUUID) {
        if (this.locked) {
            if (!this.player.equals(playerUUID.toString())) return false;
            this.locked = false;
        } else {
            this.player = playerUUID.toString();
            this.locked = true;
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        return true;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.inventory, (boolean)true);
        compound.func_74757_a("locked", this.locked);
        compound.func_74778_a("player", this.player);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        this.locked = nbt.func_74767_n("locked");
        this.player = nbt.func_74779_i("player");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int getCardsAmt() {
        int amt = 0;
        for (int i = 0; i < 6; ++i) {
            if (!(((ItemStack)this.inventory.get(i)).func_77973_b() instanceof CardItem)) continue;
            ++amt;
        }
        return amt;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }
}

