/*
 * Decompiled with CFR 0.152.
 */
package com.wildcard.buddycards.blocks.tiles;

import com.wildcard.buddycards.container.VaultContainer;
import com.wildcard.buddycards.items.CardItem;
import com.wildcard.buddycards.registries.BuddycardsEntities;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BuddysteelVaultTile
extends TileEntity
implements INamedContainerProvider {
    private LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> new ItemStackHandler(120){

        public boolean isItemValid(int slot, ItemStack stack) {
            return !BuddysteelVaultTile.this.locked && (slot >= 108 || stack.func_77973_b() instanceof CardItem) && super.isItemValid(slot, stack);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (BuddysteelVaultTile.this.locked) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    });
    private ITextComponent name;
    private boolean locked = false;
    private String player = "";

    public BuddysteelVaultTile() {
        super((TileEntityType)BuddycardsEntities.VAULT_TILE.get());
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        return new VaultContainer(p_createMenu_1_, p_createMenu_2_, (IItemHandler)this.handler.orElse((Object)new ItemStackHandler()), this);
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean toggleLock(UUID playerUUID) {
        if (this.locked) {
            if (!this.player.equals(playerUUID.toString())) return false;
            this.locked = false;
        } else {
            this.player = playerUUID.toString();
            this.locked = true;
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        return true;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("locked", this.locked);
        tag.func_74778_a("player", this.player);
        if (this.name != null) {
            tag.func_74778_a("name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        this.handler.ifPresent(stack -> {
            CompoundNBT compound = (CompoundNBT)stack.serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.locked = tag.func_74767_n("locked");
        this.player = tag.func_74779_i("player");
        if (tag.func_74764_b("name")) {
            this.name = ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("name"));
        }
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(stack -> stack.deserializeNBT((INBT)invTag));
    }

    public ITextComponent func_145748_c_() {
        if (this.name != null) {
            return this.name;
        }
        return new TranslationTextComponent("block.buddycards.buddysteel_vault");
    }

    public void setDisplayName(ITextComponent nameIn) {
        this.name = nameIn;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

