/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.worldentity;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.worldentity.ITickableWorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntitySaveData;
import com.brandon3055.brandonscore.worldentity.WorldEntityType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="brandonscore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEntityHandler {
    public static ForgeRegistry<WorldEntityType<?>> REGISTRY;
    private static final Map<UUID, WorldEntity> ID_ENTITY_MAP;
    private static final Map<RegistryKey<World>, List<WorldEntity>> WORLD_ENTITY_MAP;
    private static final Map<RegistryKey<World>, List<ITickableWorldEntity>> TICKING_ENTITY_MAP;
    private static final Map<RegistryKey<World>, List<WorldEntity>> ADDED_WORLD_ENTITIES;

    public static void createRegistry(RegistryEvent.NewRegistry event) {
        REGISTRY = (ForgeRegistry)new RegistryBuilder().setName(new ResourceLocation("brandonscore", "world_entity")).setType((Class)SneakyUtils.unsafeCast(WorldEntityType.class)).disableSaving().disableSync().create();
    }

    @SubscribeEvent
    public static void worldLoad(WorldEvent.Load event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        RegistryKey key = world.func_234923_W_();
        List<WorldEntity> oldEntities = WORLD_ENTITY_MAP.remove(key);
        TICKING_ENTITY_MAP.remove(key);
        if (oldEntities != null) {
            LogHelperBC.warn("Detected stray world entities for world " + key.toString() + ". These should have been removed when the world unloaded.");
            oldEntities.forEach(e -> ID_ENTITY_MAP.remove(e.getUniqueID()));
            WORLD_ENTITY_MAP.remove(key);
        }
        WorldEntitySaveData data = (WorldEntitySaveData)world.func_217481_x().func_215752_a(WorldEntitySaveData::new, "brandonscore_world_entity");
        data.setSaveCallback(() -> WorldEntityHandler.handleSave(data, (RegistryKey<World>)key));
        for (WorldEntity entity : data.getEntities()) {
            WorldEntityHandler.addWorldEntity((World)world, entity);
        }
    }

    private static void handleSave(WorldEntitySaveData data, RegistryKey<World> key) {
        List<WorldEntity> worldEntities = WORLD_ENTITY_MAP.get(key);
        data.updateEntities(worldEntities);
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        RegistryKey key = world.func_234923_W_();
        TICKING_ENTITY_MAP.remove(key);
        List<WorldEntity> removed = WORLD_ENTITY_MAP.get(key);
        if (removed != null) {
            removed.forEach(e -> ID_ENTITY_MAP.remove(e.getUniqueID()));
        }
    }

    public static void serverStopped() {
        WORLD_ENTITY_MAP.clear();
        TICKING_ENTITY_MAP.clear();
        ID_ENTITY_MAP.clear();
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (!(event.world instanceof ServerWorld)) {
            return;
        }
        World world = event.world;
        RegistryKey key = world.func_234923_W_();
        ID_ENTITY_MAP.entrySet().removeIf(entry -> {
            WorldEntity entity = (WorldEntity)entry.getValue();
            if (entity.isRemoved()) {
                RegistryKey removeKey = entity.world.func_234923_W_();
                if (WORLD_ENTITY_MAP.containsKey(removeKey)) {
                    WORLD_ENTITY_MAP.get(removeKey).remove(entity);
                }
                if (entity instanceof ITickableWorldEntity && TICKING_ENTITY_MAP.containsKey(removeKey)) {
                    TICKING_ENTITY_MAP.get(removeKey).remove(entity);
                }
                return true;
            }
            return false;
        });
        if (TICKING_ENTITY_MAP.containsKey(key)) {
            TICKING_ENTITY_MAP.get(key).forEach(e -> {
                if (e.getPhase() == event.phase) {
                    e.tick();
                }
            });
        }
        if (event.phase == TickEvent.Phase.END && ADDED_WORLD_ENTITIES.containsKey(key)) {
            List<WorldEntity> newEntities = ADDED_WORLD_ENTITIES.get(key);
            if (!newEntities.isEmpty()) {
                List worldEntities = WORLD_ENTITY_MAP.computeIfAbsent((RegistryKey<World>)key, e -> new ArrayList());
                List worldTickingEntities = TICKING_ENTITY_MAP.computeIfAbsent((RegistryKey<World>)key, e -> new ArrayList());
                for (WorldEntity entity : newEntities) {
                    if (entity.isRemoved()) {
                        worldEntities.remove(entity);
                        if (!(entity instanceof ITickableWorldEntity)) continue;
                        worldTickingEntities.remove(entity);
                        continue;
                    }
                    ID_ENTITY_MAP.put(entity.getUniqueID(), entity);
                    if (!worldEntities.contains(entity)) {
                        worldEntities.add(entity);
                    }
                    if (entity instanceof ITickableWorldEntity && !worldTickingEntities.contains(entity)) {
                        worldTickingEntities.add((ITickableWorldEntity)((Object)entity));
                    }
                    if (entity.getWorld() != world) {
                        entity.setWorld(world);
                    }
                    entity.onLoad();
                }
            }
            ADDED_WORLD_ENTITIES.remove(key);
        }
    }

    public static void addWorldEntity(World world, WorldEntity entity) {
        if (!(world instanceof ServerWorld)) {
            return;
        }
        RegistryKey key = world.func_234923_W_();
        ADDED_WORLD_ENTITIES.computeIfAbsent((RegistryKey<World>)key, e -> new ArrayList()).add(entity);
        entity.setWorld(world);
    }

    @Nullable
    public static WorldEntity getWorldEntity(World world, UUID id) {
        WorldEntity entity = ID_ENTITY_MAP.get(id);
        if (entity == null && ADDED_WORLD_ENTITIES.containsKey(world.func_234923_W_())) {
            entity = ADDED_WORLD_ENTITIES.get(world.func_234923_W_()).stream().filter(e -> e.getUniqueID().equals(id)).findAny().orElse(null);
        }
        return entity;
    }

    public static List<WorldEntity> getWorldEntities() {
        if (ADDED_WORLD_ENTITIES.isEmpty()) {
            return ImmutableList.copyOf(ID_ENTITY_MAP.values());
        }
        HashSet<WorldEntity> set = new HashSet<WorldEntity>();
        set.addAll(ID_ENTITY_MAP.values());
        set.addAll(ADDED_WORLD_ENTITIES.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        return ImmutableList.copyOf(set);
    }

    protected static void onEntityRemove(WorldEntity entity) {
        RegistryKey key = entity.getWorld().func_234923_W_();
        if (ADDED_WORLD_ENTITIES.containsKey(key)) {
            ADDED_WORLD_ENTITIES.get(key).remove(entity);
        }
    }

    static {
        ID_ENTITY_MAP = new HashMap<UUID, WorldEntity>();
        WORLD_ENTITY_MAP = new HashMap<RegistryKey<World>, List<WorldEntity>>();
        TICKING_ENTITY_MAP = new HashMap<RegistryKey<World>, List<ITickableWorldEntity>>();
        ADDED_WORLD_ENTITIES = new HashMap<RegistryKey<World>, List<WorldEntity>>();
    }
}

