/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.gui.GuiPlayerAccess;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.brandon3055.brandonscore.lib.datamanager.IDataManagerProvider;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc, IClientPlayNetHandler handler) {
        switch (packet.getType()) {
            case 1: {
                BlockPos pos = packet.readPos();
                TileEntity tile = mc.field_71441_e.func_175625_s(pos);
                if (!(tile instanceof IDataManagerProvider)) break;
                ((IDataManagerProvider)tile).getDataManager().receiveSyncData((MCDataInput)packet);
                break;
            }
            case 2: {
                BlockPos pos = packet.readPos();
                TileEntity tile = mc.field_71441_e.func_175625_s(pos);
                if (!(tile instanceof TileBCore)) break;
                int id = packet.readByte() & 0xFF;
                ((TileBCore)tile).receivePacketFromServer((MCDataInput)packet, id);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                boolean enable = packet.readBoolean();
                if (enable) {
                    BCEventHandler.noClipPlayers.add(mc.field_71439_g.func_110124_au());
                    break;
                }
                BCEventHandler.noClipPlayers.add(mc.field_71439_g.func_110124_au());
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                GuiPlayerAccess gui;
                GuiPlayerAccess guiPlayerAccess = gui = mc.field_71462_r instanceof GuiPlayerAccess ? (GuiPlayerAccess)mc.field_71462_r : null;
                if (gui == null) break;
                gui.name = packet.readString();
                gui.pos = packet.readPos();
                gui.dimension = packet.readInt();
                break;
            }
            case 7: {
                BrandonsCore.proxy.sendIndexedMessage((PlayerEntity)mc.field_71439_g, (ITextComponent)packet.readTextComponent(), packet.readInt());
                break;
            }
            case 8: {
                BlockPos pos = packet.readPos();
                TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
                if (!(tile instanceof TileBCore)) break;
                ((TileBCore)tile).getCapManager().receiveCapSyncData((MCDataInput)packet);
                break;
            }
            case 9: {
                ClientPacketHandler.handlePlaySound(packet, mc);
                break;
            }
            case 10: {
                ClientPacketHandler.handleEntitySpawn(packet, mc);
                break;
            }
            case 11: {
                ClientPacketHandler.handleParticleSpawn(packet, mc);
                break;
            }
            case 12: {
                ClientPacketHandler.handleEntityVelocity(packet, mc);
                break;
            }
            case 13: {
                mc.func_147108_a((Screen)new HudConfigGui());
            }
        }
    }

    private static void handlePlaySound(PacketCustom packet, Minecraft mc) {
        if (mc.field_71441_e == null) {
            return;
        }
        BlockPos pos = packet.readPos();
        SoundEvent sound = (SoundEvent)packet.readRegistryId();
        SoundCategory category = SoundCategory.values()[packet.readVarInt()];
        float volume = packet.readFloat();
        float pitch = packet.readFloat();
        boolean distanceDelay = packet.readBoolean();
        mc.field_71441_e.func_184156_a(pos, sound, category, volume, pitch, distanceDelay);
    }

    private static void handleEntitySpawn(PacketCustom packet, Minecraft mc) {
        if (mc.field_71441_e == null) {
            return;
        }
        EntityType type = (EntityType)Registry.field_212629_r.func_148745_a(packet.readVarInt());
        int entityID = packet.readInt();
        UUID uuid = packet.readUUID();
        double posX = packet.readDouble();
        double posY = packet.readDouble();
        double posZ = packet.readDouble();
        byte yaw = packet.readByte();
        byte pitch = packet.readByte();
        byte headYaw = packet.readByte();
        Vector3d velocity = new Vector3d((double)packet.readFloat(), (double)packet.readFloat(), (double)packet.readFloat());
        Entity entity = type.func_200721_a((World)mc.field_71441_e);
        if (entity == null) {
            return;
        }
        entity.func_213312_b(posX, posY, posZ);
        entity.func_70080_a(posX, posY, posZ, (float)(pitch * 360) / 256.0f, (float)(yaw * 360) / 256.0f);
        entity.func_70034_d((float)(headYaw * 360) / 256.0f);
        entity.func_181013_g((float)(headYaw * 360) / 256.0f);
        entity.func_145769_d(entityID);
        entity.func_184221_a(uuid);
        mc.field_71441_e.func_217411_a(entityID, entity);
        entity.func_70016_h(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
    }

    private static void handleEntityVelocity(PacketCustom packet, Minecraft mc) {
        if (mc.field_71441_e == null) {
            return;
        }
        int entityID = packet.readInt();
        Entity entity = mc.field_71441_e.func_73045_a(entityID);
        if (entity != null) {
            Vector3f motion = packet.readVec3f();
            entity.func_70016_h((double)motion.func_195899_a(), (double)motion.func_195900_b(), (double)motion.func_195902_c());
            if (packet.readBoolean()) {
                entity.field_70125_A = packet.readFloat();
                entity.field_70177_z = packet.readFloat();
                entity.func_230245_c_(packet.readBoolean());
            }
        }
    }

    private static void handleParticleSpawn(PacketCustom packet, Minecraft mc) {
        if (mc.field_71441_e == null) {
            return;
        }
        ParticleType type = (ParticleType)packet.readRegistryId();
        IParticleData data = type.func_197571_g().func_197543_b((ParticleType)SneakyUtils.unsafeCast((Object)type), packet.toPacketBuffer());
        Vector3 pos = packet.readVector();
        Vector3 motion = packet.readVector();
        boolean distanceOverride = packet.readBoolean();
        mc.field_71441_e.func_195590_a(data, distanceOverride, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }
}

