/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class FilterEntity
extends FilterBase {
    protected boolean whitelistEntity = true;
    protected String entityName = "";

    public FilterEntity(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistEntity(boolean whitelistEntity) {
        boolean prev = this.whitelistEntity;
        this.whitelistEntity = whitelistEntity;
        this.getFilter().nodeModified(this);
        this.whitelistEntity = prev;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
        this.getFilter().nodeModified(this);
    }

    public boolean isWhitelistEntity() {
        return this.whitelistEntity;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public boolean test(Entity entity) {
        ResourceLocation res = entity.func_200600_R().getRegistryName();
        if (this.entityName.isEmpty() || res == null) {
            return !this.whitelistEntity;
        }
        String name = this.entityName.contains(":") ? this.entityName : "minecraft:" + this.entityName;
        return res.toString().equals(name) == this.whitelistEntity;
    }

    @Override
    public FilterType getType() {
        return FilterType.ENTITY_TYPE;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("include", this.whitelistEntity);
        compound.func_74778_a("name", this.entityName);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.whitelistEntity = nbt.func_74767_n("include");
        this.entityName = nbt.func_74779_i("name");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistEntity);
        output.writeString(this.entityName);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistEntity = input.readBoolean();
        this.entityName = input.readString();
    }
}

