/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.lib.datamanager.IDataManager;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;

public class TileDataManager<T extends TileEntity>
implements IDataManager {
    protected LinkedList<IManagedData> managedDataList = new LinkedList();
    public final T tile;

    public TileDataManager(T tile) {
        this.tile = tile;
    }

    public <M extends IManagedData> M register(M managedData) {
        managedData.init(this, this.managedDataList.size());
        this.managedDataList.add(managedData);
        return managedData;
    }

    @Override
    public void detectAndSendChanges() {
        for (IManagedData data : this.managedDataList) {
            if (!data.flags().syncTile || !data.isDirty(true)) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToChunk(this.tile);
        }
    }

    public void detectAndSendChangesToListeners(List<IContainerListener> listeners) {
        for (IManagedData data : this.managedDataList) {
            if (!data.flags().syncContainer || !data.isDirty(true)) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            DataUtils.forEachMatch(listeners, p -> p instanceof ServerPlayerEntity, p -> syncPacket.sendToPlayer((ServerPlayerEntity)p));
        }
    }

    public void forceContainerSync(List<IContainerListener> listeners) {
        if (!this.tile.func_145831_w().field_72995_K) {
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncContainer) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                DataUtils.forEachMatch(listeners, p -> p instanceof ServerPlayerEntity, p -> syncPacket.sendToPlayer((ServerPlayerEntity)p));
            }
        }
    }

    public void forceSync() {
        if (!this.tile.func_145831_w().field_72995_K) {
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncTile) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                syncPacket.sendToChunk(this.tile);
            }
        }
    }

    public void forcePlayerSync(ServerPlayerEntity player) {
        if (!this.tile.func_145831_w().field_72995_K) {
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncContainer) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                syncPacket.sendToPlayer(player);
            }
        }
    }

    public void forceSync(IManagedData data) {
        if (!this.tile.func_145831_w().field_72995_K) {
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToChunk(this.tile);
        }
    }

    @Override
    public PacketCustom createSyncPacket() {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, 1);
        packet.writePos(this.tile.func_174877_v());
        return packet;
    }

    @Override
    public void receiveSyncData(MCDataInput input) {
        int index = input.readByte() & 0xFF;
        IManagedData data = this.getDataByIndex(index);
        if (data != null) {
            data.fromBytes(input);
            if (data.flags().triggerUpdate) {
                BlockState state = this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v());
                this.tile.func_145831_w().func_184138_a(this.tile.func_174877_v(), state, state, 3);
            }
        }
    }

    @Override
    public IManagedData getDataByName(String name) {
        return DataUtils.firstMatch(this.managedDataList, data -> data.getName().equals(name));
    }

    @Override
    public IManagedData getDataByIndex(int index) {
        return DataUtils.firstMatch(this.managedDataList, data -> data.getIndex() == index);
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        CompoundNBT dataTag = new CompoundNBT();
        DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveNBT, data -> data.toNBT(dataTag));
        compound.func_218657_a("bc_managed_data", (INBT)dataTag);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        if (compound.func_150297_b("bc_managed_data", 10)) {
            CompoundNBT dataTag = compound.func_74775_l("bc_managed_data");
            DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveNBT, data -> data.fromNBT(dataTag));
        }
    }

    @Override
    public void markDirty() {
        if (this.tile.func_145831_w() != null && !this.tile.func_145831_w().field_72995_K) {
            this.tile.func_70296_d();
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncOnSet || !data.isDirty(true)) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                syncPacket.sendToChunk(this.tile);
            }
        }
    }

    @Override
    public boolean isClientSide() {
        return this.tile.func_145830_o() && this.tile.func_145831_w().field_72995_K;
    }

    @Override
    public void sendToServer(IManagedData data) {
        Container container;
        PlayerEntity player;
        if (this.tile.func_145831_w().field_72995_K && data.flags().allowClientControl && (player = BrandonsCore.proxy.getClientPlayer()) != null && (container = player.field_71070_bA) instanceof ContainerBCTile && ((ContainerBCTile)container).tile == this.tile) {
            PacketCustom packet = ((ContainerBCTile)container).createServerBoundPacket(3);
            packet.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)packet);
            packet.sendToServer();
        }
    }

    public void receiveDataFromClient(MCDataInput input) {
        int index = input.readByte() & 0xFF;
        IManagedData data = this.getDataByIndex(index);
        if (data != null && data.flags().allowClientControl) {
            data.fromBytes(input);
            data.validate();
            data.markDirty();
        }
    }

    public void writeSyncNBT(CompoundNBT compound) {
        CompoundNBT dataTag = new CompoundNBT();
        DataUtils.forEachMatch(this.managedDataList, data -> data.flags().syncTile, data -> data.toNBT(dataTag));
        compound.func_218657_a("bc_managed_data", (INBT)dataTag);
    }

    public void readSyncNBT(CompoundNBT compound) {
        if (compound.func_150297_b("bc_managed_data", 10)) {
            CompoundNBT dataTag = compound.func_74775_l("bc_managed_data");
            DataUtils.forEachMatch(this.managedDataList, data -> data.flags().syncTile, data -> data.fromNBT(dataTag));
        }
    }

    public void writeToStackNBT(CompoundNBT compound) {
        CompoundNBT dataTag = new CompoundNBT();
        DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveItem, data -> data.toNBT(dataTag));
        if (!dataTag.isEmpty()) {
            compound.func_218657_a("bc_managed_data", (INBT)dataTag);
        }
    }

    public void readFromStackNBT(CompoundNBT compound) {
        if (compound.func_150297_b("bc_managed_data", 10)) {
            CompoundNBT dataTag = compound.func_74775_l("bc_managed_data");
            DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveItem, data -> data.fromNBT(dataTag));
        }
    }
}

