/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ManagedStack
extends AbstractManagedData<ItemStack> {
    private ItemStack value;
    private ItemStack lastValue;
    protected Function<ItemStack, ItemStack> validator = null;

    public ManagedStack(String name, ItemStack defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.lastValue = defaultValue.func_77946_l();
    }

    public ManagedStack(String name, DataFlags ... flags) {
        this(name, ItemStack.field_190927_a, flags);
    }

    public ItemStack set(ItemStack value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            ItemStack prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.lastValue = prev.func_77946_l();
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public ItemStack get() {
        return this.value;
    }

    public ManagedStack setValidator(Function<ItemStack, ItemStack> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public boolean isDirty(boolean reset) {
        if (this.lastValue != null && !this.lastValue.equals(this.value)) {
            if (reset) {
                this.lastValue = this.value.func_77946_l();
            }
            return true;
        }
        return super.isDirty(reset);
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeItemStack(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readItemStack();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        compound.func_218657_a(this.name, (INBT)this.value.func_77955_b(new CompoundNBT()));
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        this.value = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(this.name));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

