/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ContainerBCTile<T extends TileBCore>
extends ContainerBCore<T> {
    public T tile;

    public ContainerBCTile(@Nullable ContainerType<?> type, int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        super(type, windowId, playerInv, extraData);
        this.tile = (TileBCore)ContainerBCTile.getClientTile(extraData);
    }

    public ContainerBCTile(@Nullable ContainerType<?> type, int windowId, PlayerInventory player, PacketBuffer extraData, ContainerSlotLayout.LayoutFactory<T> factory) {
        super(type, windowId, player, extraData, factory);
        this.tile = (TileBCore)ContainerBCTile.getClientTile(extraData);
        this.buildSlotLayout();
    }

    public ContainerBCTile(@Nullable ContainerType<?> type, int windowId, PlayerInventory player, T tile) {
        super(type, windowId, player);
        this.tile = tile;
        ((TileBCore)this.tile).onPlayerOpenContainer(player.field_70458_d);
    }

    public ContainerBCTile(@Nullable ContainerType<?> type, int windowId, PlayerInventory player, T tile, ContainerSlotLayout.LayoutFactory<T> factory) {
        super(type, windowId, player, factory);
        this.tile = tile;
        ((TileBCore)this.tile).onPlayerOpenContainer(player.field_70458_d);
        this.buildSlotLayout();
    }

    @Override
    protected void buildSlotLayout() {
        if (this.tile != null) {
            this.slotLayout = this.factory.buildLayout(this.player, this.tile).retrieveSlotsForContainer(arg_0 -> ((ContainerBCTile)this).func_75146_a(arg_0));
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        ((TileBCore)this.tile).onPlayerCloseContainer(playerIn);
    }

    public void func_75142_b() {
        super.func_75142_b();
        ((TileBCore)this.tile).detectAndSendChangesToListeners(this.field_75149_d);
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (listener instanceof ServerPlayerEntity) {
            ((TileBCore)this.tile).getDataManager().forcePlayerSync((ServerPlayerEntity)listener);
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        if (this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v()) != this.tile) {
            return false;
        }
        return this.player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= (double)((TileBCore)this.tile).getAccessDistanceSq();
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int i) {
        LazyOptional<IItemHandler> optional;
        int playerSlots = 36;
        if (this.slotLayout != null) {
            playerSlots = this.slotLayout.getPlayerSlotCount();
        }
        if ((optional = this.getItemHandler()).isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElse((Object)EmptyHandler.INSTANCE);
            Slot slot = this.func_75139_a(i);
            if (slot != null && slot.func_75216_d()) {
                ItemStack stack = slot.func_75211_c();
                ItemStack result = stack.func_77946_l();
                if (i >= playerSlots ? !this.func_75135_a(stack, 0, playerSlots, false) : !this.func_75135_a(stack, playerSlots, playerSlots + handler.getSlots(), false)) {
                    return ItemStack.field_190927_a;
                }
                if (stack.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                slot.func_190901_a(player, stack);
                return result;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_75141_a(int slotID, ItemStack stack) {
        Slot slot = this.func_75139_a(slotID);
        if (slot != null) {
            slot.func_75215_d(stack);
        }
    }

    @Override
    public Slot func_75139_a(int slotId) {
        if (slotId < this.field_75151_b.size() && slotId >= 0) {
            return (Slot)this.field_75151_b.get(slotId);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_190896_a(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            Slot slot = this.func_75139_a(i);
            if (slot == null) continue;
            slot.func_75215_d(stacks.get(i));
        }
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler() {
        return ((TileBCore)this.tile).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    @Override
    public ContainerSlotLayout getSlotLayout() {
        return this.slotLayout;
    }

    protected static <T extends TileEntity> T getClientTile(PacketBuffer extraData) {
        return (T)Minecraft.func_71410_x().field_71441_e.func_175625_s(extraData.func_179259_c());
    }

    public PacketCustom createServerBoundPacket(int packetType) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, packetType);
        packet.writeInt(this.field_75152_c);
        return packet;
    }

    public void handleContainerMessage(PacketCustom packet, ServerPlayerEntity player) {
        int containerId = packet.readInt();
        if (containerId != this.field_75152_c) {
            return;
        }
        byte packetID = packet.readByte();
        ((TileBCore)this.tile).receivePacketFromClient((MCDataInput)packet, player, packetID);
    }

    public void handleTileDataPacket(PacketCustom packet, ServerPlayerEntity player) {
        int containerId = packet.readInt();
        if (containerId != this.field_75152_c) {
            return;
        }
        ((TileBCore)this.tile).getDataManager().receiveDataFromClient((MCDataInput)packet);
    }
}

