/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.EmptyGlyph;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ICharacterConsumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TextProcessing;

public class MarkdownTextRenderer {
    private static Vector3f SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, 0.03f);
    private Style activeStyle = Style.field_240709_b_;
    private GuiElement<?> guiElement;
    private FontRenderer fontRenderer;

    public MarkdownTextRenderer(GuiElement<?> guiElement, FontRenderer fontRenderer) {
        this.guiElement = guiElement;
        this.fontRenderer = fontRenderer;
    }

    public int drawFormattedString(String text, float x, float y, int colour, boolean dropShadow) {
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack textStack = new MatrixStack();
        textStack.func_227861_a_(0.0, 0.0, (double)this.guiElement.getRenderZLevel());
        Matrix4f textLocation = textStack.func_227866_c_().func_227870_a_();
        float charX = x;
        int texLen = text.length();
        for (int i = 0; i < texLen; ++i) {
            char character = text.charAt(i);
            if (character == '\u00a7') {
                if (i + 1 >= texLen) break;
                char formatChar = text.charAt(i + 1);
                TextFormatting textformatting = TextFormatting.func_211165_a((char)formatChar);
                if (textformatting != null) {
                    if (textformatting == TextFormatting.RESET) {
                        this.activeStyle = Style.field_240709_b_;
                    } else {
                        switch (textformatting) {
                            case OBFUSCATED: {
                                this.activeStyle = this.activeStyle.setObfuscated(Boolean.valueOf(!this.activeStyle.func_150233_f()));
                                break;
                            }
                            case BOLD: {
                                this.activeStyle = this.activeStyle.func_240713_a_(Boolean.valueOf(!this.activeStyle.func_150223_b()));
                                break;
                            }
                            case STRIKETHROUGH: {
                                this.activeStyle = this.activeStyle.setStrikethrough(Boolean.valueOf(!this.activeStyle.func_150236_d()));
                                break;
                            }
                            case UNDERLINE: {
                                this.activeStyle = this.activeStyle.setUnderlined(Boolean.valueOf(!this.activeStyle.func_150234_e()));
                                break;
                            }
                            case ITALIC: {
                                this.activeStyle = this.activeStyle.func_240722_b_(Boolean.valueOf(!this.activeStyle.func_150242_c()));
                                break;
                            }
                            default: {
                                Color colourFlag = Color.func_240744_a_((TextFormatting)textformatting);
                                this.activeStyle = colourFlag == null ? this.activeStyle.func_240718_a_((Color)null) : this.activeStyle.func_240718_a_(this.activeStyle.func_240711_a_() == colourFlag ? null : colourFlag);
                            }
                        }
                    }
                }
                ++i;
                continue;
            }
            charX = this.drawInternal(String.valueOf(character), charX, y, colour, dropShadow, textLocation, (IRenderTypeBuffer)getter, false, 0, 0xF000F0, this.fontRenderer.func_78260_a());
        }
        getter.func_228461_a_();
        return 0;
    }

    protected static int adjustColor(int colour) {
        return (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour;
    }

    protected float drawInternal(String text, float x, float y, int colour, boolean shadow, Matrix4f mat4f, IRenderTypeBuffer getter, boolean boolFalse, int int0, int int1, boolean biDirection) {
        SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, 0.03f);
        if (biDirection) {
            text = this.fontRenderer.func_147647_b(text);
        }
        colour = MarkdownTextRenderer.adjustColor(colour);
        Matrix4f matrix4f = mat4f.func_226601_d_();
        if (shadow) {
            this.renderText(text, x, y, colour, true, mat4f, getter, boolFalse, int0, int1);
            matrix4f.func_226597_a_(SHADOW_OFFSET);
        }
        x = this.renderText(text, x, y, colour, false, matrix4f, getter, boolFalse, int0, int1);
        return (int)x + (shadow ? 1 : 0);
    }

    protected float renderText(String text, float x, float y, int colour, boolean isShadow, Matrix4f mat4f, IRenderTypeBuffer getter, boolean boolFalse, int int0, int int1) {
        MDCharacterRenderer characterRenderer = new MDCharacterRenderer(getter, x, y, colour, isShadow, mat4f, boolFalse, int1);
        TextProcessing.func_238346_c_((String)text, (Style)this.activeStyle, (ICharacterConsumer)characterRenderer);
        return characterRenderer.finish(int0, x);
    }

    public void reset() {
        this.activeStyle = Style.field_240709_b_;
    }

    class MDCharacterRenderer
    implements ICharacterConsumer {
        final IRenderTypeBuffer bufferSource;
        private final boolean dropShadow;
        private final float dimFactor;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final Matrix4f pose;
        private final boolean seeThrough;
        private final int packedLightCoords;
        private float x;
        private float y;
        @Nullable
        private List<TexturedGlyph.Effect> effects;

        private void addEffect(TexturedGlyph.Effect p_238442_1_) {
            if (this.effects == null) {
                this.effects = Lists.newArrayList();
            }
            this.effects.add(p_238442_1_);
        }

        public MDCharacterRenderer(IRenderTypeBuffer typeBuffer, float p_i232250_3_, float p_i232250_4_, int p_i232250_5_, boolean p_i232250_6_, Matrix4f p_i232250_7_, boolean p_i232250_8_, int p_i232250_9_) {
            this.bufferSource = typeBuffer;
            this.x = p_i232250_3_;
            this.y = p_i232250_4_;
            this.dropShadow = p_i232250_6_;
            this.dimFactor = p_i232250_6_ ? 0.25f : 1.0f;
            this.r = (float)(p_i232250_5_ >> 16 & 0xFF) / 255.0f * this.dimFactor;
            this.g = (float)(p_i232250_5_ >> 8 & 0xFF) / 255.0f * this.dimFactor;
            this.b = (float)(p_i232250_5_ & 0xFF) / 255.0f * this.dimFactor;
            this.a = (float)(p_i232250_5_ >> 24 & 0xFF) / 255.0f;
            this.pose = p_i232250_7_;
            this.seeThrough = p_i232250_8_;
            this.packedLightCoords = p_i232250_9_;
        }

        private Font getFontSet(ResourceLocation p_238419_1_) {
            return (Font)((MarkdownTextRenderer)MarkdownTextRenderer.this).fontRenderer.field_211127_e.apply(p_238419_1_);
        }

        public boolean accept(int p_accept_1_, Style p_accept_2_, int p_accept_3_) {
            float f7;
            float f2;
            float f1;
            float f;
            Font font = this.getFontSet(p_accept_2_.func_240729_k_());
            IGlyph iglyph = font.func_238557_a_(p_accept_3_);
            TexturedGlyph texturedglyph = p_accept_2_.func_150233_f() && p_accept_3_ != 32 ? font.func_211188_a(iglyph) : font.func_238559_b_(p_accept_3_);
            boolean flag = p_accept_2_.func_150223_b();
            float f3 = this.a;
            Color color = p_accept_2_.func_240711_a_();
            if (color != null) {
                int i = color.func_240742_a_();
                f = (float)(i >> 16 & 0xFF) / 255.0f * this.dimFactor;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f * this.dimFactor;
                f2 = (float)(i & 0xFF) / 255.0f * this.dimFactor;
            } else {
                f = this.r;
                f1 = this.g;
                f2 = this.b;
            }
            if (!(texturedglyph instanceof EmptyGlyph)) {
                float f5 = flag ? iglyph.func_223275_b_() : 0.0f;
                float f4 = this.dropShadow ? iglyph.func_223276_c_() : 0.0f;
                IVertexBuilder ivertexbuilder = this.bufferSource.getBuffer(texturedglyph.func_228163_a_(this.seeThrough));
                this.renderChar(texturedglyph, flag, p_accept_2_.func_150242_c(), f5, this.x + f4, this.y + f4, this.pose, ivertexbuilder, f, f1, f2, f3, this.packedLightCoords);
            }
            float f6 = iglyph.func_223274_a_(flag);
            float f4 = f7 = this.dropShadow ? 1.0f : 0.0f;
            if (p_accept_2_.func_150236_d()) {
                this.addEffect(new TexturedGlyph.Effect(this.x + f7 - 1.0f, this.y + f7 + 4.5f, this.x + f7 + f6, this.y + f7 + 4.5f - 1.0f, 0.01f, f, f1, f2, f3));
            }
            if (p_accept_2_.func_150234_e()) {
                this.addEffect(new TexturedGlyph.Effect(this.x + f7 - 1.0f, this.y + f7 + 9.0f, this.x + f7 + f6, this.y + f7 + 9.0f - 1.0f, 0.01f, f, f1, f2, f3));
            }
            this.x += f6;
            return true;
        }

        public float finish(int p_238441_1_, float p_238441_2_) {
            if (p_238441_1_ != 0) {
                float f = (float)(p_238441_1_ >> 24 & 0xFF) / 255.0f;
                float f1 = (float)(p_238441_1_ >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(p_238441_1_ >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(p_238441_1_ & 0xFF) / 255.0f;
                this.addEffect(new TexturedGlyph.Effect(p_238441_2_ - 1.0f, this.y + 9.0f, this.x + 1.0f, this.y - 1.0f, 0.01f, f1, f2, f3, f));
            }
            if (this.effects != null) {
                TexturedGlyph texturedglyph = this.getFontSet(Style.field_240708_a_).func_228157_b_();
                IVertexBuilder ivertexbuilder = this.bufferSource.getBuffer(texturedglyph.func_228163_a_(this.seeThrough));
                for (TexturedGlyph.Effect texturedglyph$effect : this.effects) {
                    texturedglyph.func_228162_a_(texturedglyph$effect, this.pose, ivertexbuilder, this.packedLightCoords);
                }
            }
            return this.x;
        }

        private void renderChar(TexturedGlyph p_228077_1_, boolean p_228077_2_, boolean p_228077_3_, float p_228077_4_, float p_228077_5_, float p_228077_6_, Matrix4f p_228077_7_, IVertexBuilder p_228077_8_, float p_228077_9_, float p_228077_10_, float p_228077_11_, float p_228077_12_, int p_228077_13_) {
            p_228077_1_.func_225595_a_(p_228077_3_, p_228077_5_, p_228077_6_, p_228077_7_, p_228077_8_, p_228077_9_, p_228077_10_, p_228077_11_, p_228077_12_, p_228077_13_);
            if (p_228077_2_) {
                p_228077_1_.func_225595_a_(p_228077_3_, p_228077_5_ + p_228077_4_, p_228077_6_, p_228077_7_, p_228077_8_, p_228077_9_, p_228077_10_, p_228077_11_, p_228077_12_, p_228077_13_);
            }
        }
    }
}

