/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class GuiTextCompLabel
extends GuiElement<GuiTextCompLabel> {
    protected boolean trim = true;
    protected boolean wrap = false;
    protected boolean dropShadow = true;
    protected GuiAlign alignment = GuiAlign.CENTER;
    private ITextComponent textComponent = null;
    private Supplier<ITextComponent> textSupplier;
    private Supplier<Boolean> shadowStateSupplier;

    public GuiTextCompLabel() {
    }

    public GuiTextCompLabel(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiTextCompLabel(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    public GuiTextCompLabel(ITextComponent textComponent) {
        this.textComponent = textComponent;
    }

    public GuiTextCompLabel(Supplier<ITextComponent> displayStringSupplier) {
        this.setTextSupplier(displayStringSupplier);
    }

    public GuiTextCompLabel(int xPos, int yPos, ITextComponent textComponent) {
        this(xPos, yPos);
        this.textComponent = textComponent;
    }

    public GuiTextCompLabel(int xPos, int yPos, int xSize, int ySize, ITextComponent textComponent) {
        this(xPos, yPos, xSize, ySize);
        this.textComponent = textComponent;
    }

    public GuiTextCompLabel setTextComponent(ITextComponent textComponent) {
        this.textComponent = textComponent;
        return this;
    }

    public GuiTextCompLabel setTextSupplier(Supplier<ITextComponent> textSupplier) {
        this.textSupplier = textSupplier;
        return this;
    }

    public ITextComponent getText() {
        if (this.textSupplier != null) {
            return this.textSupplier.get();
        }
        return this.textComponent;
    }

    public GuiTextCompLabel setAlignment(GuiAlign alignment) {
        this.alignment = alignment;
        return this;
    }

    public GuiAlign getAlignment() {
        return this.alignment;
    }

    public GuiTextCompLabel setTrim(boolean trim) {
        this.trim = trim;
        if (trim) {
            this.wrap = false;
        }
        return this;
    }

    public GuiTextCompLabel setWrap(boolean wrap) {
        this.wrap = wrap;
        if (wrap) {
            this.trim = false;
        }
        return this;
    }

    public GuiTextCompLabel setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        this.shadowStateSupplier = null;
        return this;
    }

    public GuiTextCompLabel setShadowStateSupplier(Supplier<Boolean> shadowStateSupplier) {
        this.shadowStateSupplier = shadowStateSupplier;
        return this;
    }

    public boolean hasShadow() {
        return this.shadowStateSupplier != null ? this.shadowStateSupplier.get() : this.dropShadow;
    }

    @Override
    public void renderElement(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(mc, mouseX, mouseY, partialTicks);
        ITextComponent text = this.getText();
        if (text != null) {
            int widthLimit = this.getInsetRect().width;
            ((Object)((Object)this.fontRenderer)).getClass();
            int ySize = 9;
            if (this.wrap && !this.trim) {
                ySize = this.fontRenderer.func_78267_b(text.getString(), widthLimit);
            }
            boolean wrap = this.wrap && this.fontRenderer.func_238414_a_((ITextProperties)text) > widthLimit;
            int yPos = this.getInsetRect().y + this.getInsetRect().height / 2 - ySize / 2;
            int xPos = this.getInsetRect().x;
            this.drawCustomString(this.fontRenderer, (ITextProperties)text, xPos, yPos, widthLimit, 0xFFFFFF, this.getAlignment(), wrap, this.trim, this.hasShadow());
        }
    }
}

