/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.render.BCShaders;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Rectangle;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiEnergyBar
extends GuiElement<GuiEnergyBar> {
    public static ShaderProgram barShaderH = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("brandonscore", "shaders/common.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("brandonscore", "shaders/power_bar_horizontal.frag")).uniform("time", UniformType.FLOAT).uniform("charge", UniformType.FLOAT).uniform("ePos", UniformType.I_VEC2).uniform("eSize", UniformType.I_VEC2).uniform("screenSize", UniformType.I_VEC2)).whenUsed(cache -> cache.glUniform1f("time", (float)BCClientEventHandler.elapsedTicks / 10.0f)).build();
    public static ShaderProgram barShaderV = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("brandonscore", "shaders/common.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("brandonscore", "shaders/power_bar.frag")).uniform("time", UniformType.FLOAT).uniform("charge", UniformType.FLOAT).uniform("ePos", UniformType.I_VEC2).uniform("eSize", UniformType.I_VEC2).uniform("screenSize", UniformType.I_VEC2)).whenUsed(cache -> cache.glUniform1f("time", (float)BCClientEventHandler.elapsedTicks / 10.0f)).build();
    private IOPStorage energyHandler = null;
    private Supplier<Long> capacitySupplier = null;
    private Supplier<Long> energySupplier = null;
    private boolean horizontal = false;
    private boolean rfMode = false;
    private Supplier<Boolean> shaderEnabled = () -> true;
    private Supplier<Boolean> drawHoveringText = () -> true;
    private Supplier<Boolean> disabled = () -> false;

    public GuiEnergyBar() {
        this.setSize(14, 14);
        this.elementTranslationExt = "energy_bar";
    }

    public GuiEnergyBar(int xPos, int yPos) {
        super(xPos, yPos);
        this.elementTranslationExt = "energy_bar";
    }

    public GuiEnergyBar(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
        this.elementTranslationExt = "energy_bar";
    }

    public GuiEnergyBar setEnergySupplier(Supplier<Long> energySupplier) {
        this.energySupplier = energySupplier;
        return this;
    }

    public GuiEnergyBar setCapacitySupplier(Supplier<Long> capacitySupplier) {
        this.capacitySupplier = capacitySupplier;
        return this;
    }

    public GuiEnergyBar setItemSupplier(Supplier<ItemStack> stackSupplier) {
        this.capacitySupplier = () -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getMaxEnergyStored((ItemStack)stackSupplier.get()) : 0L;
        this.energySupplier = () -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getEnergyStored((ItemStack)stackSupplier.get()) : 0L;
        return this;
    }

    public GuiEnergyBar setShaderEnabled(Supplier<Boolean> shaderEnabled) {
        this.shaderEnabled = shaderEnabled;
        return this;
    }

    public GuiEnergyBar setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public GuiEnergyBar setRfMode(boolean rfMode) {
        this.rfMode = rfMode;
        return this;
    }

    public GuiEnergyBar setDrawHoveringText(boolean drawHoveringText) {
        this.drawHoveringText = () -> drawHoveringText;
        return this;
    }

    public GuiEnergyBar setDrawHoveringText(Supplier<Boolean> drawHoveringText) {
        this.drawHoveringText = drawHoveringText;
        return this;
    }

    public GuiEnergyBar setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        return this;
    }

    public GuiEnergyBar setEnergyStorage(IOPStorage energyHandler) {
        this.energyHandler = energyHandler;
        return this;
    }

    protected boolean isRfMode() {
        return this.rfMode;
    }

    protected long getCapacity() {
        if (this.capacitySupplier != null) {
            return this.capacitySupplier.get();
        }
        if (this.energyHandler != null) {
            return this.energyHandler.getMaxOPStored();
        }
        return 0L;
    }

    protected long getEnergy() {
        if (this.energySupplier != null) {
            return this.energySupplier.get();
        }
        if (this.energyHandler != null) {
            return this.energyHandler.getOPStored();
        }
        return 0L;
    }

    protected IOInfo getIOInfo() {
        return this.energyHandler != null ? this.energyHandler.getIOInfo() : null;
    }

    protected float getSOC() {
        return MathHelper.clip((float)((float)this.getEnergy() / (float)Math.max(1L, this.getCapacity())), (float)0.0f, (float)1.0f);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        int barLength = this.horizontal ? this.xSize() : this.ySize();
        int barWidth = this.horizontal ? this.ySize() : this.xSize();
        double charge = this.getSOC();
        if (Double.isNaN(charge)) {
            charge = 0.0;
        }
        int draw = (int)(charge * (double)(barLength - 2));
        int posY = this.yPos();
        int posX = this.xPos();
        if (this.horizontal) {
            int x = posY;
            posY = posX;
            posX = x;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(barLength + posY * 2), (double)0.0, (double)0.0);
            RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        int light = BCConfig.darkMode ? -1 : -1;
        int dark = BCConfig.darkMode ? -8355712 : -11513776;
        this.drawShadedRect((IRenderTypeBuffer)getter, posX, posY, barWidth, barLength, 1.0, 0, dark, light, GuiEnergyBar.midColour(light, dark));
        getter.func_228461_a_();
        if (this.disabled.get().booleanValue()) {
            this.drawColouredRect(posX + 1, posY + 1, barWidth - 2, barLength - 2, -16777216);
        } else if (!this.shaderEnabled.get().booleanValue()) {
            RenderMaterial matBase = BCSprites.get("bars/energy_empty");
            RenderMaterial matOverlay = BCSprites.get("bars/energy_full");
            this.sliceSprite(getter.getBuffer(BCSprites.GUI_TYPE), posX + 1, posY + 1, barWidth - 2, barLength - 2, matBase.func_229314_c_());
            this.sliceSprite(getter.getBuffer(BCSprites.GUI_TYPE), posX + 1, posY + barLength - draw - 1, barWidth - 2, draw, matOverlay.func_229314_c_());
            getter.func_228461_a_();
        } else {
            this.bindShader(this.horizontal ? barShaderH : barShaderV);
            this.drawColouredRect(posX + 1, posY + 1, barWidth - 2, barLength - 2, -16777216);
            this.drawColouredRect(posX + 1, posY + barLength - draw - 1, barWidth - 2, draw, -65536);
            this.releaseShader(this.horizontal ? barShaderH : barShaderV);
        }
        if (this.horizontal) {
            RenderSystem.popMatrix();
        }
    }

    public void sliceSprite(IVertexBuilder buffer, int xPos, int yPos, int xSize, int ySize, TextureAtlasSprite sprite) {
        float texU = sprite.func_94209_e();
        float texV = sprite.func_94206_g();
        int texWidth = sprite.func_94211_a();
        int texHeight = sprite.func_94216_b();
        float uScale = (sprite.func_94212_f() - texU) / (float)texWidth;
        float vScale = (sprite.func_94210_h() - texV) / (float)texHeight;
        for (int i = 0; i < ySize; i += Math.min(texHeight - 2, ySize - i)) {
            int partSize = Math.min(texHeight, ySize - i);
            this.bufferRect(buffer, xPos, yPos + ySize - i, xSize, -partSize, sprite.func_94209_e(), sprite.func_94206_g(), (float)xSize * uScale, (float)partSize * vScale);
        }
    }

    private void bufferRect(IVertexBuilder buffer, float x, float y, float width, float height, float minU, float minV, float tWidth, float tHeight) {
        double zLevel = this.getRenderZLevel();
        buffer.func_225582_a_((double)x, (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV + tHeight).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU + tWidth, minV + tHeight).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU + tWidth, minV).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, zLevel).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV).func_181675_d();
    }

    public Rectangle toScreenSpace(int xPos, int yPos, int xSize, int ySize) {
        double yResScale = (double)this.displayHeight() / (double)this.screenHeight;
        double xResScale = (double)this.displayWidth() / (double)this.screenWidth;
        double scaledWidth = (double)xSize * xResScale;
        double scaledHeight = (double)ySize * yResScale;
        int x = (int)((double)xPos * xResScale);
        int y = (int)((double)this.displayHeight() - (double)yPos * yResScale - scaledHeight);
        return new Rectangle(x, y, (int)scaledWidth, (int)scaledHeight);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoveringText.get().booleanValue() && this.isMouseOver(mouseX, mouseY)) {
            long maxEnergy = this.getCapacity();
            long energy = this.getEnergy();
            String title = this.rfMode ? this.i18ni("energy_storage") : this.i18ni("operational_potential");
            boolean shift = Screen.func_231173_s_();
            String suffix = this.rfMode ? this.i18ni("rf") : this.i18ni("op");
            String capString = (shift ? Utils.addCommas(maxEnergy) : Utils.formatNumber(maxEnergy)) + " " + suffix;
            String storedString = (shift ? Utils.addCommas(energy) : Utils.formatNumber(energy)) + " " + suffix;
            String percent = " (" + MathUtils.round((double)energy / (double)maxEnergy * 100.0, 100.0) + "%)";
            StringBuilder builder = new StringBuilder();
            builder.append(TextFormatting.DARK_AQUA).append(I18n.func_135052_a((String)title, (Object[])new Object[0])).append("\n");
            builder.append(TextFormatting.GOLD).append(this.i18ni("capacity")).append(" ").append(TextFormatting.GRAY).append(capString).append("\n");
            builder.append(TextFormatting.GOLD).append(this.i18ni("stored")).append(" ").append(TextFormatting.GRAY).append(storedString).append(percent).append("\n");
            IOInfo ioInfo = this.getIOInfo();
            if (ioInfo != null) {
                if (shift) {
                    builder.append(TextFormatting.GOLD).append(this.i18ni("input")).append(" ").append(TextFormatting.GREEN).append("+").append(Utils.formatNumber(ioInfo.currentInput()));
                    builder.append(" ").append(suffix).append("/t\n");
                    builder.append(TextFormatting.GOLD).append(this.i18ni("output")).append(" ").append(TextFormatting.RED).append("-").append(Utils.formatNumber(ioInfo.currentOutput()));
                    builder.append(" ").append(suffix).append("/t\n");
                } else {
                    long io = ioInfo.currentInput() - ioInfo.currentOutput();
                    builder.append(TextFormatting.GOLD).append(this.i18ni("io")).append(" ").append((Object)(io > 0L ? TextFormatting.GREEN + "+" : (io < 0L ? TextFormatting.RED : TextFormatting.GRAY)));
                    builder.append(Utils.formatNumber(io)).append(" ").append(suffix).append("/t\n");
                }
            }
            this.drawHoveringText(Lists.newArrayList((Object[])builder.toString().split("\n")), mouseX, mouseY, this.fontRenderer, this.displayWidth(), this.displayHeight());
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onUpdate() {
        return super.onUpdate();
    }

    public void bindShader(ShaderProgram program) {
        if (this.useShaders()) {
            Rectangle rect = this.toScreenSpace(this.xPos() + 1, this.yPos() + 1, this.xSize() - 2, this.ySize() - 2);
            UniformCache uniforms = program.pushCache();
            uniforms.glUniform1f("charge", this.getSOC() * 1.01f);
            uniforms.glUniform2i("ePos", rect.x, rect.y);
            uniforms.glUniform2i("eSize", rect.width, rect.height);
            uniforms.glUniform2i("screenSize", this.displayWidth(), this.displayHeight());
            program.use();
            program.popCache(uniforms);
        }
    }

    public void releaseShader(ShaderProgram program) {
        if (this.useShaders()) {
            program.release();
        }
    }

    public boolean useShaders() {
        return !this.rfMode && this.shaderEnabled.get() != false && BCShaders.useShaders();
    }
}

