/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import com.brandon3055.brandonscore.api.IFOVModifierItem;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BCClientEventHandler {
    private static int remountTicksRemaining = 0;
    private static int remountEntityID = 0;
    private static int debugTimeout = 0;
    private static Map<RegistryKey<World>, Integer[]> dimTickTimes = new HashMap<RegistryKey<World>, Integer[]>();
    private static Integer[] overallTickTime = new Integer[200];
    private static int renderIndex = 0;
    private static LinkedList<RegistryKey<World>> sortingOrder = new LinkedList();
    public static int elapsedTicks = 0;
    private static Comparator<RegistryKey<World>> sorter = (value, compare) -> {
        long totalValue = 0L;
        for (Integer time : dimTickTimes.get(value)) {
            totalValue += (long)time.intValue();
        }
        totalValue /= 200L;
        long totalCompare = 0L;
        for (Integer time : dimTickTimes.get(compare)) {
            totalCompare += (long)time.intValue();
        }
        return Long.compare(totalCompare /= 200L, totalValue);
    };

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++elapsedTicks;
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (debugTimeout > 0) {
            --debugTimeout;
        }
        if (elapsedTicks % 100 == 0 && debugTimeout > 0) {
            sortingOrder.clear();
            sortingOrder.addAll(dimTickTimes.keySet());
            sortingOrder.sort(sorter);
        }
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
    }

    @SubscribeEvent
    public void renderScreen(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || debugTimeout <= 0 || Minecraft.func_71410_x().field_71462_r instanceof ChatScreen) {
            return;
        }
        GlStateManager.func_227626_N_();
        GlStateManager.func_227670_b_((double)0.0, (double)0.0, (double)600.0);
        this.renderGraph(event.getMatrixStack(), 220, 0, event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), overallTickTime, "Overall");
        int i = 0;
        for (RegistryKey registryKey : sortingOrder) {
            if (dimTickTimes.get(registryKey) == null || registryKey == null) continue;
            this.renderGraph(event.getMatrixStack(), 0, i, event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), dimTickTimes.get(registryKey), registryKey.func_240901_a_().toString());
            ++i;
        }
        if (debugTimeout < 190) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_238405_a_(event.getMatrixStack(), "Server Stopped Sending Updates!", 0.0f, (float)(event.getWindow().func_198087_p() - 21), 0xFF0000);
            fontRenderer.func_238405_a_(event.getMatrixStack(), "Display will time out in " + MathUtils.round((double)debugTimeout / 20.0, 10.0), 0.0f, (float)(event.getWindow().func_198087_p() - 11), 0xFF0000);
        }
        GlStateManager.func_227627_O_();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void fovUpdate(FOVUpdateEvent event) {
        float originalFOV;
        PlayerEntity player = event.getEntity();
        float newFOV = originalFOV = event.getFov();
        int slotIndex = 2;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IFOVModifierItem) {
                newFOV = ((IFOVModifierItem)stack.func_77973_b()).getNewFOV(player, stack, newFOV, originalFOV, EquipmentSlotType.values()[slotIndex]);
            }
            ++slotIndex;
        }
        ItemStack stack = player.func_184592_cb();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IFOVModifierItem) {
            newFOV = ((IFOVModifierItem)stack.func_77973_b()).getNewFOV(player, stack, newFOV, originalFOV, EquipmentSlotType.OFFHAND);
        }
        if (!(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof IFOVModifierItem) {
            newFOV = ((IFOVModifierItem)stack.func_77973_b()).getNewFOV(player, stack, newFOV, originalFOV, EquipmentSlotType.MAINHAND);
        }
        if (newFOV != originalFOV) {
            event.setNewfov(newFOV);
        }
    }

    private void searchForPlayerMount() {
        if (remountTicksRemaining > 0) {
            Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(remountEntityID);
            if (e != null) {
                Minecraft.func_71410_x().field_71439_g.func_184220_m(e);
                LogHelperBC.info("Successfully placed player on mount after " + (500 - remountTicksRemaining) + " ticks");
                remountTicksRemaining = 0;
                return;
            }
            if (--remountTicksRemaining == 0) {
                LogHelperBC.error("Unable to locate player mount after 500 ticks! Aborting");
            }
        }
    }

    public static void tryRepositionPlayerOnMount(int id) {
        if (remountTicksRemaining == 500) {
            return;
        }
        remountTicksRemaining = 500;
        remountEntityID = id;
        LogHelperBC.info("Started checking for player mount");
    }

    private void renderGraph(MatrixStack matrix, int x, int y, int screenWidth, int screenHeight, Integer[] times, String name) {
        int yHeight = screenHeight - 23 - y * 45;
        GuiHelperOld.drawColouredRect(x, yHeight - 34, 202, 32, -1442840576);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_238405_a_(matrix, name, (float)(x + 2), (float)(yHeight - 43), 0xFFFFFF);
        GuiHelperOld.drawBorderedRect(x, yHeight - 34, 202, 17, 1, 0x44AA0000, -1429418804);
        GuiHelperOld.drawBorderedRect(x, yHeight - 18, 202, 17, 1, 0x4400AA00, -1429418804);
        fontRenderer.func_238421_b_(matrix, "50ms", (float)(x + 2), (float)(yHeight - 16), 0xFFFFFF);
        fontRenderer.func_238421_b_(matrix, "100ms", (float)(x + 2), (float)(yHeight - 32), 0xFFFFFF);
        for (int i = 0; i < 200; ++i) {
            int time = times[i] == null ? 0 : times[i];
            int height = (int)((double)time / 100.0 / 100.0 * 30.0);
            int j1 = BCClientEventHandler.getFrameColor(MathHelper.func_76125_a((int)height, (int)0, (int)30), 0, 15, 30);
            GuiHelperOld.drawColouredRect(x + (i - renderIndex) % 200 + 200, yHeight - 2 - height, 1, height, j1);
        }
    }

    public static int getFrameColor(int input, int min, int mid, int max) {
        return input < mid ? BCClientEventHandler.blendColors(-16711936, -256, (float)input / (float)mid) : BCClientEventHandler.blendColors(-256, -65536, (float)(input - mid) / (float)(max - mid));
    }

    public static int blendColors(int p_181553_1_, int p_181553_2_, float p_181553_3_) {
        int i = p_181553_1_ >> 24 & 0xFF;
        int j = p_181553_1_ >> 16 & 0xFF;
        int k = p_181553_1_ >> 8 & 0xFF;
        int l = p_181553_1_ & 0xFF;
        int i1 = p_181553_2_ >> 24 & 0xFF;
        int j1 = p_181553_2_ >> 16 & 0xFF;
        int k1 = p_181553_2_ >> 8 & 0xFF;
        int l1 = p_181553_2_ & 0xFF;
        int i2 = MathHelper.func_76125_a((int)((int)((float)i + (float)(i1 - i) * p_181553_3_)), (int)0, (int)255);
        int j2 = MathHelper.func_76125_a((int)((int)((float)j + (float)(j1 - j) * p_181553_3_)), (int)0, (int)255);
        int k2 = MathHelper.func_76125_a((int)((int)((float)k + (float)(k1 - k) * p_181553_3_)), (int)0, (int)255);
        int l2 = MathHelper.func_76125_a((int)((int)((float)l + (float)(l1 - l) * p_181553_3_)), (int)0, (int)255);
        return i2 << 24 | j2 << 16 | k2 << 8 | l2;
    }
}

