/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.util.Updatable;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2586;
import team.reborn.energy.api.EnergyStorage;

public class FabricBlockEnergyContainer
extends SnapshotParticipant<EnergySnapshot>
implements EnergyStorage {
    private final EnergyContainer container;
    private final Updatable<class_2586> updatable;
    private final class_2586 block;

    public FabricBlockEnergyContainer(EnergyContainer container, Updatable<class_2586> updatable, class_2586 block) {
        this.container = container;
        this.updatable = updatable;
        this.block = block;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        return this.container.insertEnergy(Math.min(maxAmount, this.container.maxInsert()), false);
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        return this.container.extractEnergy(Math.min(maxAmount, this.container.maxExtract()), false);
    }

    public long getAmount() {
        return this.container.getStoredEnergy();
    }

    public long getCapacity() {
        return this.container.getMaxCapacity();
    }

    public boolean supportsInsertion() {
        return this.container.allowsInsertion();
    }

    public boolean supportsExtraction() {
        return this.container.allowsExtraction();
    }

    protected EnergySnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    protected void readSnapshot(EnergySnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    protected void onFinalCommit() {
        this.updatable.update(this.block);
    }
}

