/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class TileMechanicalDaisy
extends TileEntityBase
implements ITickableTileEntity {
    private int ticksToNextUpdate = 5;
    private int[] workingTicks = new int[8];
    private final InventoryHandler inventory = new InventoryHandler();
    private final LazyOptional<IItemHandlerModifiable> lazyInventory = ItemStackHandlerWrapper.create((IItemHandlerModifiable)this.inventory);
    private final LazyOptional<IItemHandlerModifiable> hopperInventory = ItemStackHandlerWrapper.create((IItemHandlerModifiable)this.inventory, slot -> this.workingTicks[slot] < 0, null);
    private final LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> this.inventory);

    public TileMechanicalDaisy(TileEntityType<?> type) {
        super(type);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        if (cmp.func_74764_b("inv")) {
            this.inventory.deserializeNBT(cmp.func_74775_l("inv"));
        }
        if (cmp.func_74764_b("workingTicks")) {
            this.workingTicks = cmp.func_74759_k("workingTicks");
        }
    }

    public void func_73660_a() {
        boolean hasSpawnedParticles = false;
        for (int i = 0; i < 8; ++i) {
            IPureDaisyRecipe recipe = this.getRecipe(i);
            if (recipe != null) {
                if (!this.field_145850_b.field_72995_K) {
                    if (this.workingTicks[i] >= recipe.getTime() * LibXServerConfig.WorkingDurationMultiplier.mechanicalDaisy) {
                        BlockState state = recipe.getOutputState();
                        if (state.func_177230_c().func_199767_j() != Items.field_190931_a) {
                            this.inventory.setStackInSlot(i, state.func_177230_c().func_185473_a((IBlockReader)this.field_145850_b, this.field_174879_c, state));
                        } else if (state.func_204520_s().func_206886_c().getFluid() != Fluids.field_204541_a) {
                            this.inventory.setStackInSlot(i, new FluidStack(state.func_204520_s().func_206886_c(), 1000));
                        }
                        this.workingTicks[i] = -1;
                        this.markDispatchable();
                        continue;
                    }
                    int n = i;
                    this.workingTicks[n] = this.workingTicks[n] + 1;
                    continue;
                }
                if (hasSpawnedParticles || !LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalDaisy) continue;
                hasSpawnedParticles = true;
                double x = (double)this.field_174879_c.func_177958_n() + Math.random();
                double y = (double)this.field_174879_c.func_177956_o() + Math.random() + 0.25;
                double z = (double)this.field_174879_c.func_177952_p() + Math.random();
                WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 2.0f), (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_145850_b.func_195594_a((IParticleData)data, x, y, z, 0.0, 0.0, 0.0);
                continue;
            }
            this.workingTicks[i] = this.workingTicks[i] < 0 && !this.inventory.getStackInSlot(i).func_190926_b() ? -1 : 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksToNextUpdate <= 0) {
                this.ticksToNextUpdate = 5;
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
            } else {
                --this.ticksToNextUpdate;
            }
        }
    }

    @Nullable
    private IPureDaisyRecipe getRecipe(int slot) {
        BlockState state = this.getState(slot);
        if (state == null) {
            return null;
        }
        return this.getRecipe(state);
    }

    @Nullable
    public BlockState getState(int slot) {
        BlockState state = null;
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof BlockItem) {
                state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            }
        } else {
            FluidStack fluid = this.inventory.getFluidInTank(slot);
            if (!fluid.isEmpty() && fluid.getAmount() >= 1000) {
                state = fluid.getFluid().func_207188_f().func_206883_i();
            }
        }
        return state;
    }

    @Nullable
    public BlockState getState(ItemStack stack) {
        BlockState state = null;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem) {
            state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
        }
        return state;
    }

    @Nullable
    public IPureDaisyRecipe getRecipe(BlockState state) {
        if (this.field_145850_b == null) {
            return null;
        }
        for (IRecipe genericRecipe : this.field_145850_b.func_199532_z().func_215366_a(ModRecipeTypes.PURE_DAISY_TYPE).values()) {
            IPureDaisyRecipe recipe;
            if (!(genericRecipe instanceof IPureDaisyRecipe) || !(recipe = (IPureDaisyRecipe)genericRecipe).matches(this.field_145850_b, this.field_174879_c, null, state)) continue;
            return recipe;
        }
        return null;
    }

    public InventoryHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return side == null ? this.lazyInventory : this.hopperInventory;
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidInventory;
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT cmp) {
        cmp.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        cmp.func_74783_a("workingTicks", this.workingTicks);
        return super.func_189515_b(cmp);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleUpdateTag(state, cmp);
        if (cmp.func_74764_b("inv")) {
            this.inventory.deserializeNBT(cmp.func_74775_l("inv"));
        }
        if (cmp.func_74764_b("workingTicks")) {
            this.workingTicks = cmp.func_74759_k("workingTicks");
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        cmp.func_74783_a("workingTicks", this.workingTicks);
        return cmp;
    }

    public class InventoryHandler
    extends ItemStackHandler
    implements IFluidHandler {
        private final List<FluidStack> fluids;

        public InventoryHandler() {
            super(8);
            this.fluids = new ArrayList<FluidStack>(8);
            for (int i = 0; i < 8; ++i) {
                this.fluids.add(FluidStack.EMPTY);
            }
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (!stack.func_190926_b()) {
                this.fluids.set(slot, FluidStack.EMPTY);
            }
            super.setStackInSlot(slot, stack);
        }

        public void setStackInSlot(int slot, @Nonnull FluidStack stack) {
            this.fluids.set(slot, stack);
            if (!stack.isEmpty()) {
                super.setStackInSlot(slot, ItemStack.field_190927_a);
            } else {
                this.onContentsChanged(slot);
            }
        }

        public int getSlots() {
            return 8;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.fluids.get(slot).isEmpty()) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.fluids.get(slot).isEmpty()) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem && TileMechanicalDaisy.this.getRecipe(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P()) != null;
        }

        public int getTanks() {
            return 8;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (!this.getStackInSlot(tank).func_190926_b()) {
                return FluidStack.EMPTY;
            }
            return this.fluids.get(tank);
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return !stack.isEmpty() && TileMechanicalDaisy.this.getRecipe(stack.getFluid().func_207188_f().func_206883_i()) != null;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int transfer;
            int i;
            int leftToFill = resource.getAmount();
            for (i = 0; i < 8 && leftToFill > 0; ++i) {
                if (!this.getStackInSlot(i).func_190926_b() || this.fluids.get(i).getFluid() != resource.getFluid()) continue;
                transfer = Math.min(leftToFill, this.getTankCapacity(i) - this.fluids.get(i).getAmount());
                leftToFill -= transfer;
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.get(i).setAmount(this.fluids.get(i).getAmount() + transfer);
                this.onContentsChanged(i);
            }
            for (i = 0; i < 8 && leftToFill > 0; ++i) {
                if (!this.getStackInSlot(i).func_190926_b() || !this.fluids.get(i).isEmpty()) continue;
                transfer = Math.min(leftToFill, this.getTankCapacity(i));
                leftToFill -= transfer;
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.set(i, new FluidStack(resource.getFluid(), transfer));
                this.onContentsChanged(i);
            }
            return resource.getAmount() - leftToFill;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            int leftToDrain = resource.getAmount();
            for (int i = 0; i < 8 && leftToDrain > 0; ++i) {
                if (!this.getStackInSlot(i).func_190926_b() || this.fluids.get(i).getFluid() != resource.getFluid()) continue;
                int transfer = Math.min(this.fluids.get(i).getAmount(), leftToDrain);
                leftToDrain -= transfer;
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.get(i).setAmount(this.fluids.get(i).getAmount() - transfer);
                if (this.fluids.get(i).getAmount() <= 0) {
                    this.fluids.set(i, FluidStack.EMPTY);
                }
                this.onContentsChanged(i);
            }
            if (resource.getAmount() - leftToDrain > 0) {
                return new FluidStack(resource.getFluid(), resource.getAmount() - leftToDrain);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int leftToDrain = maxDrain;
            Fluid drainFluid = null;
            for (int i = 0; i < 8 && leftToDrain > 0; ++i) {
                if (!this.getStackInSlot(i).func_190926_b() || drainFluid != null && drainFluid != this.fluids.get(i).getFluid()) continue;
                int transfer = Math.min(this.fluids.get(i).getAmount(), leftToDrain);
                leftToDrain -= transfer;
                if (transfer > 0) {
                    drainFluid = this.fluids.get(i).getFluid();
                }
                if (action != IFluidHandler.FluidAction.EXECUTE) continue;
                this.fluids.get(i).setAmount(this.fluids.get(i).getAmount() - transfer);
                if (this.fluids.get(i).getAmount() <= 0) {
                    this.fluids.set(i, FluidStack.EMPTY);
                }
                this.onContentsChanged(i);
            }
            if (drainFluid == null) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(drainFluid, maxDrain - leftToDrain);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = super.serializeNBT();
            ListNBT tag = new ListNBT();
            for (int i = 0; i < 8; ++i) {
                CompoundNBT fluidNbt = new CompoundNBT();
                this.fluids.get(i).writeToNBT(fluidNbt);
                tag.add(i, (INBT)fluidNbt);
            }
            nbt.func_218657_a("fluids", (INBT)tag);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            super.deserializeNBT(nbt);
            if (nbt.func_74764_b("fluids")) {
                ListNBT tag = nbt.func_150295_c("fluids", 10);
                for (int i = 0; i < 8; ++i) {
                    CompoundNBT fluidNbt = tag.func_150305_b(i);
                    this.fluids.set(i, FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidNbt));
                }
            }
        }

        protected void onContentsChanged(int slot) {
            TileMechanicalDaisy.this.func_70296_d();
            TileMechanicalDaisy.this.markDispatchable();
        }
    }
}

