/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.blocks.base.IWorkingTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class TileIndustrialAgglomerationFactory
extends BotanicalTile
implements IWorkingTile {
    public static final int MAX_MANA_PER_TICK = 5000;
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(4, slot -> {
        this.update = true;
        this.markDispatchable();
    }, this::isValidStack);
    private boolean update;
    private int progress;
    private int maxProgress = -1;
    private ITerraPlateRecipe recipe;

    public TileIndustrialAgglomerationFactory(TileEntityType<?> type) {
        super(type, LibXServerConfig.MaxManaCapacity.industrialAgglomerationFactory);
        this.inventory.setInputSlots(new int[]{0, 1, 2});
        this.inventory.setOutputSlots(new int[]{3});
        this.inventory.setSlotValidator(this::isValidStack);
        this.update = true;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isValidStack(int slot, ItemStack stack) {
        if (Arrays.stream(this.inventory.getInputSlots()).anyMatch(x -> x == slot) && this.field_145850_b != null) {
            return RecipeHelper.isItemValidInput((RecipeManager)this.field_145850_b.func_199532_z(), (IRecipeType)ModRecipeTypes.TERRA_PLATE_TYPE, (ItemStack)stack);
        }
        return true;
    }

    private void updateRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ArrayList stacks = new ArrayList(this.inventory.getStacks());
            stacks.remove(3);
            for (IRecipe recipe : this.field_145850_b.func_199532_z().func_199510_b()) {
                if (!(recipe instanceof ITerraPlateRecipe) || !RecipeHelper.matches((IRecipe)recipe, stacks, (boolean)false)) continue;
                this.recipe = (ITerraPlateRecipe)recipe;
                this.markDispatchable();
                return;
            }
        }
        this.recipe = null;
    }

    public void func_73660_a() {
        double time;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.update) {
                this.updateRecipe();
                this.update = false;
            }
            if (this.recipe != null) {
                ItemStack output = this.recipe.func_77571_b().func_77946_l();
                ItemStack currentOutput = this.inventory.getStackInSlot(3);
                if (this.getInventory().getStackInSlot(3).func_190926_b() || output.func_77973_b() == currentOutput.func_77973_b() && currentOutput.func_77976_d() > currentOutput.func_190916_E()) {
                    this.maxProgress = this.recipe.getMana();
                    int manaTransfer = Math.min(this.getCurrentMana(), Math.min(this.getMaxManaPerTick(), this.getMaxProgress() - this.progress));
                    this.progress += manaTransfer;
                    this.receiveMana(-manaTransfer);
                    if (this.progress >= this.getMaxProgress()) {
                        block0: for (Ingredient ingredient : this.recipe.func_192400_c()) {
                            for (int slot : this.inventory.getInputSlots()) {
                                ItemStack stack = this.inventory.getStackInSlot(slot);
                                if (!ingredient.test(stack)) continue;
                                stack.func_190918_g(1);
                                continue block0;
                            }
                        }
                        this.inventory.getUnrestricted().insertItem(3, output, false);
                        this.progress = 0;
                        this.maxProgress = 0;
                        this.update = true;
                    }
                    this.func_70296_d();
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                this.maxProgress = -1;
                this.func_70296_d();
                this.markDispatchable();
            }
        } else if (this.field_145850_b != null && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory && this.progress > 0 && (time = (double)this.progress / (double)this.getMaxProgress()) < 0.8) {
            double y = (double)this.field_174879_c.func_177956_o() + 0.375 + 0.3125 * (time *= 1.25);
            double x1 = (double)this.field_174879_c.func_177958_n() + 0.2 + 0.3 * time;
            double x2 = (double)this.field_174879_c.func_177958_n() + 0.8 - 0.3 * time;
            double z1 = (double)this.field_174879_c.func_177952_p() + 0.2 + 0.3 * time;
            double z2 = (double)this.field_174879_c.func_177952_p() + 0.8 - 0.3 * time;
            WispParticleData data = WispParticleData.wisp((float)0.1f, (float)0.0f, (float)((float)time), (float)((float)(1.0 - time)), (float)1.0f);
            this.field_145850_b.func_195594_a((IParticleData)data, x1, y, z1, 0.0, 0.0, 0.0);
            this.field_145850_b.func_195594_a((IParticleData)data, x1, y, z2, 0.0, 0.0, 0.0);
            this.field_145850_b.func_195594_a((IParticleData)data, x2, y, z1, 0.0, 0.0, 0.0);
            this.field_145850_b.func_195594_a((IParticleData)data, x2, y, z2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getMaxManaPerTick() {
        return 5000 / LibXServerConfig.WorkingDurationMultiplier.industrialAgglomerationFactory;
    }

    @Override
    public int getComparatorOutput() {
        return this.getProgress() > 0 ? 15 : 0;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.maxProgress = cmp.func_74762_e("maxProgress");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT cmp) {
        cmp.func_74768_a("progress", this.progress);
        cmp.func_74768_a("maxProgress", this.maxProgress);
        return super.func_189515_b(cmp);
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleUpdateTag(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.maxProgress = cmp.func_74762_e("maxProgress");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_74768_a("progress", this.progress);
        cmp.func_74768_a("maxProgress", this.maxProgress);
        return cmp;
    }
}

