/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.blocks.base.IWorkingTile;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.Explosion;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class TileAlfheimMarket
extends BotanicalTile
implements IWorkingTile {
    public static final int MAX_MANA_PER_TICK = 25;
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(5, slot -> {
        this.update = true;
        this.markDispatchable();
    }, this::isValidStack);
    private IElvenTradeRecipe recipe = null;
    private int progress;
    private boolean update;
    private ItemStack currentInput = ItemStack.field_190927_a;
    private ItemStack currentOutput = ItemStack.field_190927_a;

    public TileAlfheimMarket(TileEntityType<?> type) {
        super(type, LibXServerConfig.MaxManaCapacity.alfheimMarket);
        this.inventory.setInputSlots(IntStream.range(0, 4).toArray());
        this.inventory.setOutputSlots(new int[]{4});
        this.update = true;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isValidStack(int slot, ItemStack stack) {
        if (this.field_145850_b == null) {
            return false;
        }
        return Arrays.stream(this.inventory.getInputSlots()).noneMatch(x -> x == slot) || RecipeHelper.isItemValidInput((RecipeManager)this.field_145850_b.func_199532_z(), (IRecipeType)ModRecipeTypes.ELVEN_TRADE_TYPE, (ItemStack)stack);
    }

    private void updateRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ArrayList stacks = new ArrayList(this.inventory.getStacks());
            stacks.remove(4);
            for (IRecipe recipe : this.field_145850_b.func_199532_z().func_199510_b()) {
                if (!(recipe instanceof IElvenTradeRecipe) || !RecipeHelper.matches((IRecipe)recipe, stacks, (boolean)false)) continue;
                this.recipe = (IElvenTradeRecipe)recipe;
                this.currentInput = TileAlfheimMarket.getInputStack(this.recipe).func_77946_l();
                this.currentOutput = ((ItemStack)this.recipe.getOutputs().get(0)).func_77946_l();
                this.markDispatchable();
                return;
            }
        }
        this.currentInput = ItemStack.field_190927_a;
        this.currentOutput = ItemStack.field_190927_a;
        this.recipe = null;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.update) {
                this.updateRecipe();
                this.func_70296_d();
                this.update = false;
            }
            if (this.recipe != null) {
                ArrayList outputs = new ArrayList(this.recipe.getOutputs());
                if (outputs.size() == 1 && this.inventory.getUnrestricted().insertItem(4, (ItemStack)outputs.get(0), true).func_190926_b()) {
                    int manaTransfer = Math.min(this.getCurrentMana(), Math.min(this.getMaxManaPerTick(), this.getMaxProgress() - this.progress));
                    this.progress += manaTransfer;
                    this.receiveMana(-manaTransfer);
                    if (this.progress >= LibXServerConfig.AlfheimMarket.recipeCost) {
                        this.inventory.getUnrestricted().insertItem(4, ((ItemStack)outputs.get(0)).func_77946_l(), false);
                        block0: for (Ingredient ingredient : this.recipe.func_192400_c()) {
                            for (int slot : this.inventory.getInputSlots()) {
                                ItemStack stack = this.inventory.getStackInSlot(slot);
                                if (!ingredient.test(stack)) continue;
                                stack.func_190918_g(1);
                                continue block0;
                            }
                        }
                        this.update = true;
                        this.recipe = null;
                        this.progress = 0;
                        this.func_70296_d();
                        this.markDispatchable();
                    }
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                this.func_70296_d();
                this.markDispatchable();
            }
            if (this.getCurrentMana() > 0) {
                for (int i : this.inventory.getInputSlots()) {
                    if (this.inventory.getStackInSlot(i).func_77973_b() != Items.field_151025_P) continue;
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                    this.field_145850_b.func_217385_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 3.0f, Explosion.Mode.BREAK);
                    break;
                }
            }
        }
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return LibXServerConfig.AlfheimMarket.recipeCost;
    }

    public int getMaxManaPerTick() {
        return 25 * LibXServerConfig.WorkingDurationMultiplier.alfheimMarket;
    }

    private static ItemStack getInputStack(IElvenTradeRecipe recipe) {
        if (recipe.func_192400_c().isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack[] stacks = ((Ingredient)recipe.func_192400_c().get(0)).func_193365_a();
        if (stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        return stacks[0];
    }

    public ItemStack getCurrentInput() {
        return this.currentInput;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    @Override
    public int getComparatorOutput() {
        return this.getProgress() > 0 ? 15 : 0;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.currentInput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentInput"));
        this.currentOutput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentOutput"));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT cmp) {
        cmp.func_74768_a("progress", this.progress);
        cmp.func_218657_a("currentInput", (INBT)this.currentInput.serializeNBT());
        cmp.func_218657_a("currentOutput", (INBT)this.currentOutput.serializeNBT());
        return super.func_189515_b(cmp);
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleUpdateTag(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.currentInput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentInput"));
        this.currentOutput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentOutput"));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_74768_a("progress", this.progress);
        cmp.func_218657_a("currentInput", (INBT)this.currentInput.serializeNBT());
        cmp.func_218657_a("currentOutput", (INBT)this.currentOutput.serializeNBT());
        return cmp;
    }
}

