/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.melanx.botanicalmachinery.blocks.tiles.TileMechanicalBrewery;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import io.github.noeppi_noeppi.libx.block.tesr.HorizontalRotatedTesr;
import io.github.noeppi_noeppi.libx.render.RenderHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.item.ModItems;

public class TesrMechanicalBrewery
extends HorizontalRotatedTesr<TileMechanicalBrewery> {
    public static final Map<Item, Integer> INGREDIENT_COLORS = ImmutableMap.builder().put((Object)Items.field_151075_bm, (Object)12468042).put((Object)Items.field_179563_cD, (Object)9553335).put((Object)Items.field_151114_aO, (Object)16759902).put((Object)Items.field_151153_ao, (Object)14393875).put((Object)Items.field_151174_bG, (Object)15317602).put((Object)Items.field_151102_aT, (Object)0xD5D5DF).put((Object)Items.field_151074_bl, (Object)0xF9F969).put((Object)Items.field_151042_j, (Object)0xD8D8D8).put((Object)Items.field_151116_aA, (Object)12999733).put((Object)Items.field_151064_bs, (Object)13993248).put((Object)Items.field_151071_bq, (Object)6620715).put((Object)Items.field_196128_bn, (Object)3432131).put((Object)Items.field_151059_bz, (Object)15641624).put((Object)Items.field_151060_bw, (Object)13191432).put((Object)Items.field_151073_bk, (Object)10470339).put((Object)Items.field_151016_H, (Object)0x727272).put((Object)Items.field_151078_bh, (Object)8602648).put((Object)Items.field_151103_aS, (Object)16579565).put((Object)Items.field_151007_F, (Object)0xDBDBDB).put((Object)Items.field_151079_bi, (Object)3447176).put((Object)Items.field_151065_br, (Object)0xFFE000).put((Object)ModItems.manaSteel, (Object)27647).put((Object)Items.field_151070_bp, (Object)10296877).put((Object)Items.field_151150_bK, (Object)14393875).put((Object)Items.field_151121_aF, (Object)15330027).put((Object)Items.field_151034_e, (Object)14489381).put((Object)Items.field_151008_G, (Object)0x969696).put((Object)Items.field_151172_bF, (Object)16748041).put((Object)Items.field_151137_ax, (Object)15336448).put((Object)Items.field_196086_aW, (Object)13017713).put((Object)Items.field_151128_bU, (Object)14537926).put((Object)Items.field_151126_ay, (Object)0xFFFFFF).put((Object)Items.field_151166_bC, (Object)1564002).put((Object)Items.field_151127_ba, (Object)12529955).build();
    private final int waterColor = Fluids.field_204546_a.getAttributes().getColor();

    public TesrMechanicalBrewery(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    protected void doRender(@Nonnull TileMechanicalBrewery tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalBrewery) {
            return;
        }
        int slotToMove = -1;
        double travelCenter = 1.0;
        Quaternion vialRotate = null;
        double vialDown = 0.0;
        boolean showOutput = false;
        if (tile.getProgress() > 0) {
            double progress = (double)tile.getProgress() / (double)tile.getMaxProgress();
            int segments = 3;
            for (int i = 1; i <= 6; ++i) {
                if (tile.getInventory().getStackInSlot(i).func_190926_b()) continue;
                ++segments;
            }
            double segment = 1.0 / (double)segments;
            double segmentProgress = progress % segment * (double)segments;
            if (progress >= 1.0 - segment) {
                slotToMove = Integer.MAX_VALUE;
                double progressMinusHalf = segmentProgress - 0.5;
                vialDown = progressMinusHalf * progressMinusHalf - 0.25;
                vialRotate = Vector3f.field_229179_b_.func_229187_a_((float)(480.0 * vialDown));
                vialDown = 1.8 * vialDown;
                showOutput = progressMinusHalf >= 0.0;
                this.renderFluid(matrixStack, buffer, partialTicks, light, (float)(1.0 - segmentProgress), this.getTargetColor(tile));
            } else if (progress >= 1.0 - 2.0 * segment) {
                slotToMove = Integer.MAX_VALUE;
                int fromColor = this.waterColor;
                for (int i = 6; i >= 1; --i) {
                    if (tile.getInventory().getStackInSlot(i).func_190926_b()) continue;
                    fromColor = this.getColor(tile.getInventory().getStackInSlot(i));
                    break;
                }
                this.renderFluid(matrixStack, buffer, partialTicks, light, 1.0f, fromColor, this.getTargetColor(tile), segmentProgress);
            } else if (progress < segment) {
                this.renderFluid(matrixStack, buffer, partialTicks, light, (float)segmentProgress, this.waterColor);
            } else {
                int idx = (int)((progress - segment) / segment);
                int fromColor = this.waterColor;
                int toColor = this.waterColor;
                for (int i = 1; i <= 6; ++i) {
                    if (tile.getInventory().getStackInSlot(i).func_190926_b()) continue;
                    if (idx <= 0) {
                        slotToMove = i;
                        travelCenter = segmentProgress;
                        toColor = this.getColor(tile.getInventory().getStackInSlot(i));
                        break;
                    }
                    if (idx == 1) {
                        fromColor = this.getColor(tile.getInventory().getStackInSlot(i));
                    }
                    --idx;
                }
                this.renderFluid(matrixStack, buffer, partialTicks, light, 1.0f, fromColor, toColor, segmentProgress);
            }
        }
        ItemStack topStack = tile.getInventory().getStackInSlot(7);
        if (showOutput && !tile.getCurrentOutput().func_190926_b()) {
            topStack = tile.getCurrentOutput();
        } else if (topStack.func_190926_b() || tile.getProgress() > 0) {
            topStack = tile.getInventory().getStackInSlot(0);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.8 + vialDown, 0.5);
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)ClientTickHandler.ticksInGame + partialTicks) / 1.3f));
        if (vialRotate != null) {
            matrixStack.func_227863_a_(vialRotate);
        }
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(topStack, ItemCameraTransforms.TransformType.GROUND, light, OverlayTexture.field_229196_a_, matrixStack, buffer);
        matrixStack.func_227865_b_();
        int itemAmount = 0;
        for (int i = 1; i <= 6; ++i) {
            if (tile.getInventory().getStackInSlot(i).func_190926_b()) continue;
            ++itemAmount;
        }
        double angle = 360.0 / (double)itemAmount;
        float time = (float)ClientTickHandler.ticksInGame + partialTicks;
        int idx = 0;
        for (int i = 1; i <= 6; ++i) {
            if (tile.getInventory().getStackInSlot(i).func_190926_b()) continue;
            int idxNow = idx++;
            if (i < slotToMove) continue;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.7, 0.5);
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-(angle * (double)idxNow + (double)time))));
            if (i == slotToMove) {
                matrixStack.func_227861_a_((1.0 - travelCenter) * 1.125, travelCenter * -1.0, (1.0 - travelCenter) * 0.25);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(90.0 * travelCenter)));
            } else {
                matrixStack.func_227861_a_(1.125, 0.0, 0.25);
            }
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, 0.075 * Math.sin((double)(time + (float)(idxNow * 10)) / 5.0), 0.0);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(tile.getInventory().getStackInSlot(i), ItemCameraTransforms.TransformType.GROUND, light, OverlayTexture.field_229196_a_, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
    }

    private int getColor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return this.waterColor;
        }
        if (INGREDIENT_COLORS.containsKey(stack.func_77973_b())) {
            return INGREDIENT_COLORS.get(stack.func_77973_b());
        }
        if (stack.func_77973_b() instanceof DyeItem) {
            return ((DyeItem)stack.func_77973_b()).func_195962_g().getColorValue();
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            return ((BlockItem)stack.func_77973_b()).func_179223_d().func_235697_s_().field_76291_p;
        }
        return this.waterColor;
    }

    private int getTargetColor(TileMechanicalBrewery tile) {
        if (tile.getCurrentOutput().func_77973_b() instanceof IBrewItem) {
            return ((IBrewItem)tile.getCurrentOutput().func_77973_b()).getBrew(tile.getCurrentOutput()).getColor(tile.getCurrentOutput());
        }
        return this.waterColor;
    }

    private void renderFluid(MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, float partialTicks, int light, float fillLevel, int colorFrom, int colorTo, double progress) {
        int fromRed = colorFrom >> 16 & 0xFF;
        int fromGreen = colorFrom >> 8 & 0xFF;
        int fromBlue = colorFrom & 0xFF;
        int toRed = colorTo >> 16 & 0xFF;
        int toGreen = colorTo >> 8 & 0xFF;
        int toBlue = colorTo & 0xFF;
        int red = (int)Math.round((double)fromRed + (double)(toRed - fromRed) * progress);
        int green = (int)Math.round((double)fromGreen + (double)(toGreen - fromGreen) * progress);
        int blue = (int)Math.round((double)fromBlue + (double)(toBlue - fromBlue) * progress);
        int color = red << 16 | green << 8 | blue;
        this.renderFluid(matrixStack, buffer, partialTicks, light, fillLevel, color);
    }

    private void renderFluid(MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, float partialTicks, int light, float fillLevel, int color) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.func_227861_a_(4.0, 3.0 + 4.4 * (double)fillLevel, 4.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(Fluids.field_204546_a.getAttributes().getStillTexture());
        IVertexBuilder vertex = buffer.getBuffer(Atlases.func_228785_j_());
        RenderHelper.renderIconColored((MatrixStack)matrixStack, (IVertexBuilder)vertex, (float)0.0f, (float)0.0f, (TextureAtlasSprite)sprite, (float)8.0f, (float)8.0f, (float)1.0f, (int)color, (int)light, (int)OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }
}

