/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.melanx.botanicalmachinery.blocks.tiles.TileMechanicalApothecary;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import io.github.noeppi_noeppi.libx.block.tesr.HorizontalRotatedTesr;
import io.github.noeppi_noeppi.libx.render.RenderHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class TesrMechanicalApothecary
extends HorizontalRotatedTesr<TileMechanicalApothecary> {
    public TesrMechanicalApothecary(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    protected void doRender(@Nonnull TileMechanicalApothecary tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalApothecary) {
            return;
        }
        if (!tile.getInventory().getStackInSlot(0).func_190926_b()) {
            float time = (float)ClientTickHandler.ticksInGame + partialTicks;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.89375, 0.5);
            matrixStack.func_227862_a_(0.375f, 0.375f, 0.375f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(time / 1.3f));
            ItemStack stack = tile.getInventory().getStackInSlot(0);
            if (tile.getProgress() > 0) {
                int progress = tile.getProgress();
                if (progress > TileMechanicalApothecary.getRecipeDuration() / 2) {
                    progress = TileMechanicalApothecary.getRecipeDuration() / 2 - Math.abs(TileMechanicalApothecary.getRecipeDuration() / 2 - progress);
                    stack = tile.getCurrentOutput();
                }
                double amount = (double)progress / ((double)TileMechanicalApothecary.getRecipeDuration() / 2.0);
                matrixStack.func_227861_a_(0.0, -amount, 0.0);
            }
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, 200, OverlayTexture.field_229196_a_, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
        double fluidAmount = ((double)tile.getFluidInventory().getFluidAmount() - (double)tile.getProgress() / (double)TileMechanicalApothecary.getRecipeDuration() * 1000.0) / (double)tile.getFluidInventory().getCapacity();
        if (tile.getFluidInventory().getFluidAmount() > 0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.25, (10.0 + fluidAmount * 3.8) / 16.0, 0.25);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
            FluidStack fluidStack = tile.getFluidInventory().getFluid();
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStack.getFluid().getAttributes().getStillTexture(fluidStack));
            int fluidColor = Fluids.field_204546_a.getAttributes().getColor((IBlockDisplayReader)tile.func_145831_w(), tile.func_174877_v());
            IVertexBuilder vertex = buffer.getBuffer(Atlases.func_228785_j_());
            RenderHelper.renderIconColored((MatrixStack)matrixStack, (IVertexBuilder)vertex, (float)0.0f, (float)0.0f, (TextureAtlasSprite)sprite, (float)8.0f, (float)8.0f, (float)1.0f, (int)fluidColor, (int)light, (int)OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        int items = 0;
        for (int slot : tile.getInventory().getInputSlots()) {
            if (tile.getInventory().getStackInSlot(slot).func_190926_b()) continue;
            ++items;
        }
        double offsetPerPetal = 360.0 / (double)items;
        double flowerTicks = (double)((float)ClientTickHandler.ticksInGame + partialTicks) / 2.0;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, (10.0 + fluidAmount * 3.8 / 1.5) / 16.0, 0.5);
        matrixStack.func_227862_a_(0.125f, 0.125f, 0.125f);
        int nextIdx = 0;
        boolean hasFluid = tile.getFluidInventory().getFluidAmount() > 0;
        for (int slot : tile.getInventory().getInputSlots()) {
            double radiusZ;
            double radiusX;
            if (tile.getInventory().getStackInSlot(slot).func_190926_b()) continue;
            int i = nextIdx++;
            double offset = offsetPerPetal * (double)i;
            double deg = hasFluid ? flowerTicks / 0.25 % 360.0 + offset : offset;
            double rad = deg * Math.PI / 180.0;
            if (hasFluid) {
                radiusX = (double)1.2f + (double)0.1f * Math.sin(flowerTicks / 6.0);
                radiusZ = (double)1.2f + (double)0.1f * Math.cos(flowerTicks / 6.0);
            } else {
                radiusX = 1.300000049173832;
                radiusZ = 1.300000049173832;
            }
            double x = radiusX * Math.cos(rad);
            double z = radiusZ * Math.sin(rad);
            double y = hasFluid ? (double)((float)Math.cos((flowerTicks + (double)(50 * i)) / 5.0) / 10.0f) : 0.0;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(x, y, z);
            matrixStack.func_227861_a_(0.0625, 0.0625, 0.0625);
            if (hasFluid) {
                float xRotate = (float)Math.sin(flowerTicks * 0.25) / 2.0f;
                float yRotate = (float)Math.max((double)0.6f, Math.sin(flowerTicks * (double)0.1f) / 2.0 + 0.5);
                float zRotate = (float)Math.cos(flowerTicks * 0.25) / 2.0f;
                matrixStack.func_227863_a_(new Vector3f(xRotate, yRotate, zRotate).func_229187_a_((float)deg));
            } else {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            }
            matrixStack.func_227861_a_(-0.0625, -0.0625, -0.0625);
            ItemStack stack = tile.getInventory().getStackInSlot(slot);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }
}

