/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.base;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.botanicalmachinery.blocks.base.IManaMachineTile;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.mana.IKeyLocked;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IThrottledPacket;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.client.core.handler.HUDHandler;

public abstract class BotanicalTile
extends TileEntityBase
implements IManaPool,
IManaMachineTile,
IKeyLocked,
ISparkAttachable,
IThrottledPacket,
ITickableTileEntity {
    private int mana;
    private final int manaCap;
    private String inputKey = "";
    private String outputKey = "";
    private final LazyOptional<IItemHandlerModifiable> capability = this.createCap(this::getInventory);

    public BotanicalTile(TileEntityType<?> tileEntityTypeIn, int manaCap) {
        super(tileEntityTypeIn);
        this.manaCap = manaCap;
    }

    protected LazyOptional<IItemHandlerModifiable> createCap(Supplier<IItemHandlerModifiable> inventory) {
        return ItemStackHandlerWrapper.createLazy(inventory);
    }

    @Nonnull
    public abstract BaseItemStackHandler getInventory();

    public abstract boolean isValidStack(int var1, ItemStack var2);

    public abstract int getComparatorOutput();

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, Direction direction) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.capability.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.getInventory().deserializeNBT(cmp.func_74775_l("inv"));
        this.mana = cmp.func_74762_e("mana");
        if (cmp.func_74764_b("inputKey")) {
            this.inputKey = cmp.func_74779_i("inputKey");
        }
        if (cmp.func_74764_b("outputKey")) {
            this.outputKey = cmp.func_74779_i("outputKey");
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT cmp) {
        cmp.func_218657_a("inv", (INBT)this.getInventory().serializeNBT());
        cmp.func_74768_a("mana", this.getCurrentMana());
        cmp.func_74778_a("inputKey", this.inputKey);
        cmp.func_74778_a("outputKey", this.outputKey);
        return super.func_189515_b(cmp);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        this.getInventory().deserializeNBT(cmp.func_74775_l("inv"));
        this.mana = cmp.func_74762_e("mana");
        if (cmp.func_74764_b("inputKey")) {
            this.inputKey = cmp.func_74779_i("inputKey");
        }
        if (cmp.func_74764_b("outputKey")) {
            this.outputKey = cmp.func_74779_i("outputKey");
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_218657_a("inv", (INBT)this.getInventory().serializeNBT());
        cmp.func_74768_a("mana", this.getCurrentMana());
        cmp.func_74778_a("inputKey", this.inputKey);
        cmp.func_74778_a("outputKey", this.outputKey);
        return cmp;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc) {
        ItemStack block = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c());
        String name = block.func_200301_q().getString();
        int color = 0x4444FF;
        HUDHandler.drawSimpleManaHUD((MatrixStack)ms, (int)color, (int)this.getCurrentMana(), (int)this.getManaCap(), (String)name);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
        RenderSystem.disableLighting();
        RenderSystem.disableBlend();
    }

    public String getInputKey() {
        return this.inputKey;
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public boolean canAttachSpark(ItemStack itemStack) {
        return true;
    }

    public void attachSpark(ISparkEntity iSparkEntity) {
    }

    public int getAvailableSpaceForMana() {
        return Math.max(Math.max(0, this.getManaCap() - this.getCurrentMana()), 0);
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity entity = (Entity)sparks.get(0);
            return (ISparkEntity)entity;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public boolean isFull() {
        return this.getCurrentMana() >= this.getManaCap();
    }

    public void receiveMana(int i) {
        int old = this.getCurrentMana();
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + i, this.getManaCap()));
        if (old != this.getCurrentMana()) {
            this.func_70296_d();
            this.markDispatchable();
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public int getManaCap() {
        return this.manaCap;
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public DyeColor getColor() {
        return null;
    }

    public void setColor(DyeColor dyeColor) {
    }
}

