/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.UnaryOperator;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.impl.commands.args.FontArgument;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1843;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_8242;

public class CommandFont {
    public static LiteralArgumentBuilder<class_2168> build() {
        LiteralArgumentBuilder font = class_2170.method_9247((String)"font");
        font.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"item").requires(p -> p.method_9259(2))).then(FontArgument.argument().executes(CommandFont::renameItemWithFont)));
        font.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"block").requires(p -> p.method_9259(2))).then(FontArgument.argument().then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(CommandFont::renameBlockWithFont))));
        font.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"book").requires(p -> p.method_9259(2))).then(FontArgument.argument().executes(CommandFont::setBookFont)));
        font.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"say").requires(p -> p.method_9259(2))).then(FontArgument.argument().then(class_2170.method_9244((String)"message", (ArgumentType)class_2196.method_9340()).executes(CommandFont::speakWithFont))));
        return font;
    }

    private static int speakWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 fontId = FontArgument.getFont(context);
        class_2561 inputMessage = TextHelper.applyFont(class_2196.method_9339(context, (String)"message"), fontId);
        class_5250 txtMessage = class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{((class_2168)context.getSource()).method_9223(), inputMessage});
        ((class_2168)context.getSource()).method_9211().method_3760().method_43514((class_2561)txtMessage, false);
        return 0;
    }

    private static int renameItemWithFont(CommandContext<class_2168> context) {
        class_2960 fontId = FontArgument.getFont(context);
        class_1297 sender = ((class_2168)context.getSource()).method_9228();
        if (sender instanceof class_1309) {
            class_1309 living = (class_1309)sender;
            class_1799 stack = living.method_6047();
            stack.method_7977(TextHelper.applyFont(stack.method_7964(), fontId));
            return 1;
        }
        return 0;
    }

    private static int renameBlockWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2960 fontId = FontArgument.getFont(context);
        class_2338 pos = class_2262.method_9696(context, (String)"pos");
        class_2586 tile = world.method_8321(pos);
        if (tile != null) {
            if (tile instanceof class_2624) {
                class_2624 container = (class_2624)tile;
                container.method_17488(TextHelper.applyFont(container.method_5477(), fontId));
            }
            if (tile instanceof class_2625) {
                class_2625 sign = (class_2625)tile;
                sign.method_49841(CommandFont.applySignFont(fontId), true);
                sign.method_49841(CommandFont.applySignFont(fontId), false);
                sign.method_10997().method_8413(sign.method_11016(), sign.method_11010(), sign.method_11010(), 3);
            }
        }
        return 1;
    }

    private static UnaryOperator<class_8242> applySignFont(class_2960 fontId) {
        return text -> {
            for (int i = 0; i < 4; ++i) {
                text.method_49857(i, TextHelper.applyFont(text.method_49859(i, false), fontId));
            }
            return text;
        };
    }

    private static int setBookFont(CommandContext<class_2168> context) {
        class_1309 living;
        class_1799 stack;
        class_2960 fontId = FontArgument.getFont(context);
        class_1297 sender = ((class_2168)context.getSource()).method_9228();
        if (sender instanceof class_1309 && (stack = (living = (class_1309)sender).method_6047()).method_7909() instanceof class_1843 && stack.method_7985()) {
            stack.method_7977(TextHelper.applyFont(stack.method_7964(), fontId));
            class_2487 stackTag = stack.method_7969();
            if (stackTag != null) {
                class_2499 pageData = stackTag.method_10554("pages", 8);
                for (int pageNum = 0; pageNum < pageData.size(); ++pageNum) {
                    class_5250 pageText = class_2561.class_2562.method_10873((String)pageData.method_10608(pageNum));
                    TextHelper.applyFont((class_2561)pageText, fontId);
                    pageData.method_10606(pageNum, (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)pageText)));
                }
                stackTag.method_10566("pages", (class_2520)pageData);
            }
            return 1;
        }
        return 0;
    }
}

