/*
 * Decompiled with CFR 0.152.
 */
package hibi.boathud;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static String speedFormat = "%03.0f km/h";
    public static final String angleFormat = "%03.0f \u00b0";
    public static final String gFormat = "%+.1f g";
    public static boolean enabled = true;
    public static boolean extended = true;
    public static double speedRate = 3.6;
    public static int configSpeedType = 1;
    public static int barType = 0;
    private static File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "boathud.properties");

    private Config() {
    }

    public static void load() {
        try {
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                String line = br.readLine();
                do {
                    if (line.startsWith("enabled ")) {
                        enabled = Boolean.parseBoolean(line.substring(8));
                    }
                    if (line.startsWith("extended ")) {
                        extended = Boolean.parseBoolean(line.substring(9));
                    }
                    if (line.startsWith("barType ")) {
                        barType = Integer.parseInt(line.substring(8));
                    }
                    if (!line.startsWith("speedUnit ")) continue;
                    Config.setUnit(Integer.parseInt(line.substring(10)));
                } while ((line = br.readLine()) != null);
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (barType > 2 || barType < 0) {
            barType = 0;
        }
    }

    public static void save() {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("enabled " + Boolean.toString(enabled) + "\n");
            writer.write("extended " + Boolean.toString(extended) + "\n");
            writer.write("barType " + Integer.toString(barType) + "\n");
            writer.write("speedUnit " + Integer.toString(configSpeedType) + "\n");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setUnit(int type) {
        switch (type) {
            case 0: {
                speedRate = 1.0;
                speedFormat = "%03.0f m/s";
                configSpeedType = 0;
                break;
            }
            case 2: {
                speedRate = 2.236936;
                speedFormat = "%03.0f mph";
                configSpeedType = 2;
                break;
            }
            case 3: {
                speedRate = 1.943844;
                speedFormat = "%03.0f kt";
                configSpeedType = 3;
                break;
            }
            default: {
                speedRate = 3.6;
                speedFormat = "%03.0f km/h";
                configSpeedType = 1;
            }
        }
    }
}

