/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.arc.IARCTool;
import wayoftime.bloodmagic.common.item.inventory.InventoryWrapper;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.network.ARCTanksPacket;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.tile.TileInventory;
import wayoftime.bloodmagic.tile.container.ContainerAlchemicalReactionChamber;
import wayoftime.bloodmagic.util.MultiSlotItemHandler;

public class TileAlchemicalReactionChamber
extends TileInventory
implements ITickableTileEntity,
INamedContainerProvider,
ISidedInventory,
IFluidHandler {
    @ObjectHolder(value="bloodmagic:alchemicalreactionchamber")
    public static TileEntityType<TileAlchemicalReactionChamber> TYPE;
    public static final int ARC_TOOL_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int NUM_OUTPUTS = 5;
    public static final int INPUT_SLOT = 6;
    public static final int INPUT_BUCKET_SLOT = 7;
    public static final int OUTPUT_BUCKET_SLOT = 8;
    public FluidTank inputTank = new FluidTank(20000);
    public FluidTank outputTank = new FluidTank(20000);
    public double currentProgress = 0.0;
    public static final double DEFAULT_SPEED = 0.005;
    private LazyOptional fluidOptional;

    public TileAlchemicalReactionChamber(TileEntityType<?> type) {
        super(type, 9, "alchemicalreactionchamber");
        this.initializeFluidCapabilities();
    }

    public TileAlchemicalReactionChamber() {
        this(TYPE);
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.currentProgress = tag.func_74769_h("progress");
        CompoundNBT inputTankTag = tag.func_74775_l("inputtank");
        this.inputTank.readFromNBT(inputTankTag);
        CompoundNBT outputTankTag = tag.func_74775_l("outputtank");
        this.outputTank.readFromNBT(outputTankTag);
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        super.serialize(tag);
        tag.func_74780_a("progress", this.currentProgress);
        CompoundNBT inputTankTag = new CompoundNBT();
        this.inputTank.writeToNBT(inputTankTag);
        tag.func_218657_a("inputtank", (INBT)inputTankTag);
        CompoundNBT outputTankTag = new CompoundNBT();
        this.outputTank.writeToNBT(outputTankTag);
        tag.func_218657_a("outputtank", (INBT)outputTankTag);
        return tag;
    }

    public void func_73660_a() {
        RecipeARC recipe;
        boolean outputChanged = false;
        ItemStack fullBucketStack = this.func_70301_a(7);
        ItemStack emptyBucketStack = this.func_70301_a(8);
        ItemStack[] outputInventory = new ItemStack[]{this.func_70301_a(1), this.func_70301_a(2), this.func_70301_a(3), this.func_70301_a(4), this.func_70301_a(5)};
        MultiSlotItemHandler outputSlotHandler = new MultiSlotItemHandler(outputInventory, 64);
        if (!this.field_145850_b.field_72995_K) {
            ItemStack testEmptyBucketStack;
            ArrayList<ItemStack> arrayList;
            IFluidHandlerItem fluidHandler;
            FluidStack transferedStack;
            ItemStack testFullBucketStack;
            LazyOptional fluidHandlerWrapper;
            if (!fullBucketStack.func_190926_b() && this.inputTank.getSpace() >= 1000 && (fluidHandlerWrapper = FluidUtil.getFluidHandler((ItemStack)(testFullBucketStack = ItemHandlerHelper.copyStackWithSize((ItemStack)fullBucketStack, (int)1)))).isPresent() && !(transferedStack = FluidUtil.tryFluidTransfer((IFluidHandler)this.inputTank, (IFluidHandler)(fluidHandler = (IFluidHandlerItem)fluidHandlerWrapper.resolve().get()), (int)1000, (boolean)false)).isEmpty()) {
                fluidHandler.drain(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                arrayList = new ArrayList<ItemStack>();
                arrayList.add(fluidHandler.getContainer());
                if (outputSlotHandler.canTransferAllItemsToSlots(arrayList, true)) {
                    outputChanged = true;
                    this.inputTank.fill(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                    outputSlotHandler.canTransferAllItemsToSlots(arrayList, false);
                    if (fullBucketStack.func_190916_E() > 1) {
                        fullBucketStack.func_190920_e(fullBucketStack.func_190916_E() - 1);
                    } else {
                        this.func_70299_a(7, ItemStack.field_190927_a);
                    }
                }
            }
            if (!emptyBucketStack.func_190926_b() && this.outputTank.getFluidAmount() >= 1000 && (fluidHandlerWrapper = FluidUtil.getFluidHandler((ItemStack)(testEmptyBucketStack = ItemHandlerHelper.copyStackWithSize((ItemStack)emptyBucketStack, (int)1)))).isPresent() && !(transferedStack = FluidUtil.tryFluidTransfer((IFluidHandler)(fluidHandler = (IFluidHandlerItem)fluidHandlerWrapper.resolve().get()), (IFluidHandler)this.outputTank, (int)1000, (boolean)false)).isEmpty()) {
                fluidHandler.fill(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                arrayList = new ArrayList();
                arrayList.add(fluidHandler.getContainer());
                if (outputSlotHandler.canTransferAllItemsToSlots(arrayList, true)) {
                    outputChanged = true;
                    this.outputTank.drain(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                    outputSlotHandler.canTransferAllItemsToSlots(arrayList, false);
                    if (emptyBucketStack.func_190916_E() > 1) {
                        emptyBucketStack.func_190920_e(emptyBucketStack.func_190916_E() - 1);
                    } else {
                        this.func_70299_a(8, ItemStack.field_190927_a);
                    }
                }
            }
        }
        ItemStack inputStack = this.func_70301_a(6);
        ItemStack toolStack = this.func_70301_a(0);
        double craftingMultiplier = 1.0;
        if (toolStack.func_77973_b() instanceof IARCTool) {
            craftingMultiplier = ((IARCTool)toolStack.func_77973_b()).getCraftingSpeedMultiplier(toolStack);
        }
        if (this.canCraft(recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getARC(this.field_145850_b, inputStack, toolStack, this.inputTank.getFluid()), outputSlotHandler)) {
            this.currentProgress += craftingMultiplier * 0.005;
            if (this.currentProgress >= 1.0) {
                if (!this.field_145850_b.field_72995_K) {
                    outputChanged = true;
                    this.craftItem(recipe, outputSlotHandler);
                }
                this.currentProgress = 0.0;
            }
        } else if (toolStack.func_77973_b().func_206844_a(BloodMagicTags.ARC_TOOL_FURNACE)) {
            InventoryWrapper invWrapper = new InventoryWrapper(1);
            invWrapper.func_70299_a(0, inputStack.func_77946_l());
            Optional furnaceRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)invWrapper, this.field_145850_b);
            if (furnaceRecipe.isPresent()) {
                ItemStack outputStack = ((FurnaceRecipe)furnaceRecipe.get()).func_77572_b((IInventory)invWrapper);
                if (this.canCraftFurnace(outputStack, outputSlotHandler)) {
                    this.currentProgress += craftingMultiplier * 0.005;
                    if (this.currentProgress >= 1.0) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.craftFurnace(outputStack, outputSlotHandler);
                            outputChanged = true;
                        }
                        this.currentProgress = 0.0;
                    }
                }
            } else {
                this.currentProgress = 0.0;
            }
        } else {
            this.currentProgress = 0.0;
        }
        if (outputChanged && !this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                this.func_70299_a(1 + i, outputSlotHandler.getStackInSlot(i));
            }
        }
    }

    private boolean canCraft(RecipeARC recipe, MultiSlotItemHandler outputSlotHandler) {
        if (recipe == null) {
            return false;
        }
        FluidStackIngredient inputFluidIngredient = recipe.getFluidIngredient();
        if (inputFluidIngredient != null && !inputFluidIngredient.test(this.inputTank.getFluid())) {
            return false;
        }
        if (outputSlotHandler.canTransferAllItemsToSlots(recipe.getAllListedOutputs(), true)) {
            FluidStack outputStack = recipe.getFluidOutput();
            return outputStack.isEmpty() ? true : this.outputTank.fill(outputStack, IFluidHandler.FluidAction.SIMULATE) >= outputStack.getAmount();
        }
        return false;
    }

    private void craftItem(RecipeARC recipe, MultiSlotItemHandler outputSlotHandler) {
        if (this.canCraft(recipe, outputSlotHandler)) {
            if (recipe.getFluidIngredient() != null) {
                FluidStack inputStack = recipe.getFluidIngredient().getMatchingInstance(this.inputTank.getFluid());
                this.inputTank.drain(inputStack, IFluidHandler.FluidAction.EXECUTE);
            }
            outputSlotHandler.canTransferAllItemsToSlots(recipe.getAllOutputs(this.field_145850_b.field_73012_v), false);
            this.outputTank.fill(recipe.getFluidOutput().copy(), IFluidHandler.FluidAction.EXECUTE);
            this.consumeInventory(recipe.getConsumeIngredient());
        }
    }

    private boolean canCraftFurnace(ItemStack outputStack, MultiSlotItemHandler outputSlotHandler) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        outputList.add(outputStack);
        return outputSlotHandler.canTransferAllItemsToSlots(outputList, true);
    }

    private void craftFurnace(ItemStack outputStack, MultiSlotItemHandler outputSlotHandler) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        outputList.add(outputStack);
        outputSlotHandler.canTransferAllItemsToSlots(outputList, false);
        this.consumeInventory(false);
    }

    public void consumeInventory(boolean consumeInput) {
        ItemStack toolStack;
        ItemStack inputStack = this.func_70301_a(6);
        if (!inputStack.func_190926_b()) {
            if (!consumeInput && inputStack.func_77973_b().hasContainerItem(inputStack)) {
                this.func_70299_a(6, inputStack.func_77973_b().getContainerItem(inputStack));
            } else {
                inputStack.func_190918_g(1);
                if (inputStack.func_190926_b()) {
                    this.func_70299_a(6, ItemStack.field_190927_a);
                }
            }
        }
        if (!(toolStack = this.func_70301_a(0)).func_190926_b()) {
            if (toolStack.func_77984_f()) {
                int unbreakingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)toolStack);
                if (unbreakingLevel == 0 || this.field_145850_b.field_73012_v.nextInt(unbreakingLevel + 1) == 0) {
                    toolStack.func_196085_b(toolStack.func_77952_i() + 1);
                    if (toolStack.func_77952_i() >= toolStack.func_77958_k()) {
                        this.func_70299_a(0, ItemStack.field_190927_a);
                    }
                }
            } else if (toolStack.func_77973_b().hasContainerItem(toolStack)) {
                this.func_70299_a(0, toolStack.func_77973_b().getContainerItem(inputStack));
            } else {
                toolStack.func_190918_g(1);
                if (toolStack.func_190926_b()) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                }
            }
        }
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        assert (this.field_145850_b != null);
        return new ContainerAlchemicalReactionChamber(this, p_createMenu_1_, p_createMenu_2_);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Alchemical Reaction Chamber");
    }

    public double getProgressForGui() {
        return this.currentProgress;
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case UP: {
                return new int[]{0};
            }
            case DOWN: {
                return new int[]{1, 2, 3, 4, 5};
            }
        }
        return new int[]{6, 7, 8};
    }

    public boolean func_180462_a(int index, ItemStack itemStack, Direction direction) {
        if (index == 7 || index == 8) {
            Optional fluidStackOptional = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluidStackOptional.isPresent() && (index == 8 && !((FluidStack)fluidStackOptional.get()).isEmpty() || index == 7 && ((FluidStack)fluidStackOptional.get()).isEmpty());
        }
        if (index >= 1 && index < 6) {
            return false;
        }
        if (index == 0) {
            return itemStack.func_77973_b().func_206844_a(BloodMagicTags.ARC_TOOL);
        }
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index >= 1 && index < 6;
    }

    protected void initializeFluidCapabilities() {
        this.fluidOptional = LazyOptional.of(() -> this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
            this.fluidOptional = null;
        }
    }

    public int getTanks() {
        return 2;
    }

    public FluidStack getFluidInTank(int tank) {
        switch (tank) {
            case 0: {
                return this.inputTank.getFluid();
            }
        }
        return this.outputTank.getFluid();
    }

    public int getTankCapacity(int tank) {
        switch (tank) {
            case 0: {
                return this.inputTank.getCapacity();
            }
        }
        return this.outputTank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        switch (tank) {
            case 0: {
                return this.inputTank.isFluidValid(stack);
            }
        }
        return this.outputTank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int fillAmount = this.inputTank.fill(resource, action);
        if (fillAmount > 0 && !this.field_145850_b.field_72995_K) {
            BloodMagic.packetHandler.sendToAllTracking(new ARCTanksPacket(this), this);
        }
        return fillAmount;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drainedStack = this.outputTank.drain(resource, action);
        if (!drainedStack.isEmpty() && !this.field_145850_b.field_72995_K) {
            BloodMagic.packetHandler.sendToAllTracking(new ARCTanksPacket(this), this);
        }
        return drainedStack;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drainedStack = this.outputTank.drain(maxDrain, action);
        if (!drainedStack.isEmpty() && !this.field_145850_b.field_72995_K) {
            BloodMagic.packetHandler.sendToAllTracking(new ARCTanksPacket(this), this);
        }
        return drainedStack;
    }
}

