/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="sphere")
public class RitualSphereCreate
extends Ritual {
    public static final String SPHEROID_RANGE = "spheroidRange";
    private boolean cached = false;
    private BlockPos currentPos;

    public RitualSphereCreate() {
        super("ritualSphere", 0, 20000, "ritual.bloodmagic.sphereRitual");
        this.addBlockRange(SPHEROID_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-16, -35, -16), new BlockPos(17, -2, 17)));
        this.setMaximumVolumeAndDistanceOfRange(SPHEROID_RANGE, 0, 32, 70);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.currentPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        if (this.currentPos != null) {
            tag.func_74768_a("xCoord", this.currentPos.func_177958_n());
            tag.func_74768_a("yCoord", this.currentPos.func_177956_o());
            tag.func_74768_a("zCoord", this.currentPos.func_177952_p());
        }
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor sphereRange = masterRitualStone.getBlockRange(SPHEROID_RANGE);
        AxisAlignedBB sphereBB = sphereRange.getAABB(masterPos);
        int minX = (int)((double)masterPos.func_177958_n() - sphereBB.field_72340_a);
        int maxX = (int)(sphereBB.field_72336_d - (double)masterPos.func_177958_n()) - 1;
        int minY = (int)((double)masterPos.func_177956_o() - sphereBB.field_72338_b);
        int maxY = (int)(sphereBB.field_72337_e - (double)masterPos.func_177956_o()) - 1;
        int minZ = (int)((double)masterPos.func_177952_p() - sphereBB.field_72339_c);
        int maxZ = (int)(sphereBB.field_72334_f - (double)masterPos.func_177952_p()) - 1;
        double sphereCenterX = (maxX + -minX) / 2;
        double sphereCenterY = (maxY + -minY) / 2;
        double sphereCenterZ = (maxZ + -minZ) / 2;
        int yTeleportOffset = (int)(-sphereCenterY * 2.0);
        double xR = (double)(maxX + minX) / 2.0;
        double yR = (double)(maxY + minY) / 2.0;
        double zR = (double)(maxZ + minZ) / 2.0;
        int j = -minY;
        int i = -minX;
        int k = -minZ;
        if (this.currentPos != null) {
            j = this.currentPos.func_177956_o();
            i = this.currentPos.func_177958_n();
            k = this.currentPos.func_177952_p();
        }
        int checks = 0;
        int maxChecks = 100;
        if (j <= maxY) {
            while (i <= maxX) {
                while (k <= maxZ) {
                    if (++checks >= maxChecks) {
                        this.currentPos = new BlockPos(i, j, k);
                        return;
                    }
                    if (this.checkIfEllipsoid(xR, yR, zR, (double)i - sphereCenterX, (double)j - sphereCenterY, (double)k - sphereCenterZ)) {
                        BlockPos newPos = masterPos.func_177982_a(i, j, k);
                        if (world.func_175623_d(newPos)) {
                            ++k;
                            continue;
                        }
                        BlockPos swapPos = newPos.func_177982_a(0, yTeleportOffset, 0);
                        Utils.swapLocations(world, newPos, world, swapPos);
                        if (world.func_175623_d(newPos)) {
                            // empty if block
                        }
                        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                        this.currentPos = new BlockPos(i, j, ++k);
                        return;
                    }
                    ++k;
                }
                ++i;
                k = -minZ;
            }
            i = -minX;
            this.currentPos = new BlockPos(i, ++j, k);
            return;
        }
        masterRitualStone.setActive(false);
    }

    public boolean checkIfEllipsoidShell(double xR, double yR, double zR, double xOff, double yOff, double zOff) {
        if (!this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff)) {
            return false;
        }
        return !this.checkIfEllipsoid(xR, yR, zR, xOff + 1.0, yOff, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff - 1.0, yOff, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff + 1.0, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff - 1.0, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff + 1.0) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff - 1.0);
    }

    public boolean checkIfEllipsoid(double xR, double yR, double zR, double xOff, double yOff, double zOff) {
        float possOffset = 0.5f;
        return xOff * xOff / ((xR + (double)possOffset) * (xR + (double)possOffset)) + yOff * yOff / ((yR + (double)possOffset) * (yR + (double)possOffset)) + zOff * zOff / ((zR + (double)possOffset) * (zR + (double)possOffset)) <= 1.0;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 1, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 1, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, 2, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, 2, EnumRuneType.EARTH);
        this.addRune(components, -2, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, -2, EnumRuneType.EARTH);
        this.addRune(components, 2, 1, 2, EnumRuneType.AIR);
        this.addRune(components, 2, 1, -2, EnumRuneType.AIR);
        this.addRune(components, -2, 1, 2, EnumRuneType.AIR);
        this.addRune(components, -2, 1, -2, EnumRuneType.AIR);
        this.addRune(components, 2, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, 2, EnumRuneType.FIRE);
        this.addRune(components, -2, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, -2, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSphereCreate();
    }
}

