/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="full_stomach")
public class RitualFullStomach
extends Ritual {
    public static final String FILL_RANGE = "fillRange";
    public static final String CHEST_RANGE = "chest";
    public int foodLevel = 0;
    public float storedSaturation = 0.0f;

    public RitualFullStomach() {
        super("ritualFullStomach", 0, 100000, "ritual.bloodmagic.fullStomachRitual");
        this.addBlockRange(FILL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-25, -25, -25), 51));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FILL_RANGE, 0, 25, 25);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        if (this.getRefreshCost() > currentEssence) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
        if (tile == null) {
            return;
        }
        IItemHandler inventory = Utils.getInventory(tile, null);
        if (inventory == null) {
            return;
        }
        int lastSlot = 0;
        AreaDescriptor fillingRange = masterRitualStone.getBlockRange(FILL_RANGE);
        List playerList = world.func_217357_a(PlayerEntity.class, fillingRange.getAABB(pos));
        if (this.foodLevel <= 0) {
            for (int i = lastSlot; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.extractItem(i, 1, true);
                if (stack.func_190926_b() || !stack.func_77973_b().func_219971_r()) continue;
                Food food = stack.func_77973_b().func_219967_s();
                this.foodLevel = food.func_221466_a();
                this.storedSaturation = food.func_221469_b();
                inventory.extractItem(i, 1, false);
                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                break;
            }
            if (this.foodLevel <= 0) {
                return;
            }
        }
        for (PlayerEntity player : playerList) {
            FoodStats foodStats = player.func_71024_bL();
            float satLevel = foodStats.func_75115_e();
            float saturationAmount = this.storedSaturation * 1.0f * 2.0f;
            while ((saturationAmount + satLevel <= 20.0f || satLevel < 5.0f) && this.foodLevel > 0) {
                foodStats.func_75122_a(1, this.storedSaturation);
                satLevel = foodStats.func_75115_e();
                --this.foodLevel;
            }
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.foodLevel = tag.func_74762_e("foodLevel");
        this.storedSaturation = tag.func_74760_g("storedSaturation");
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("foodLevel", this.foodLevel);
        tag.func_74776_a("storedSaturation", this.storedSaturation);
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 100;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFullStomach();
    }
}

