/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.api.IBloodMagicBlacklist;
import wayoftime.bloodmagic.util.BMLog;

public class BloodMagicBlacklist
implements IBloodMagicBlacklist {
    private final Set<BlockState> teleposer = Sets.newHashSet();
    private final Set<ResourceLocation> teleposerEntities = Sets.newHashSet();
    private final Set<BlockState> transposition = Sets.newHashSet();
    private final Set<BlockState> greenGrove = Sets.newHashSet();
    private final Set<ResourceLocation> sacrifice = Sets.newHashSet();

    @Override
    public void addTeleposer(@Nonnull BlockState state) {
        if (!this.teleposer.contains(state)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Teleposer blacklist.", state);
            this.teleposer.add(state);
        }
    }

    public void addTeleposer(@Nonnull Block block) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            this.addTeleposer(state);
        }
    }

    @Override
    public void addTeleposer(@Nonnull ResourceLocation entityId) {
        if (!this.teleposerEntities.contains(entityId)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Teleposer blacklist.", entityId);
            this.teleposerEntities.add(entityId);
        }
    }

    @Override
    public void addTransposition(@Nonnull BlockState state) {
        if (!this.transposition.contains(state)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Transposition blacklist.", state);
            this.transposition.add(state);
        }
    }

    public void addTransposition(@Nonnull Block block) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            this.addTransposition(state);
        }
    }

    @Override
    public void addGreenGrove(@Nonnull BlockState state) {
        if (!this.greenGrove.contains(state)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Green Grove blacklist.", state);
            this.greenGrove.add(state);
        }
    }

    public void addGreenGrove(@Nonnull Block block) {
        for (BlockState state : block.func_176194_O().func_177619_a()) {
            this.addGreenGrove(state);
        }
    }

    @Override
    public void addWellOfSuffering(@Nonnull ResourceLocation entityId) {
        if (!this.sacrifice.contains(entityId)) {
            BMLog.API_VERBOSE.info("Blacklist: Added {} to the Well of Suffering blacklist.", entityId);
            this.sacrifice.add(entityId);
        }
    }

    public Set<BlockState> getTeleposer() {
        return ImmutableSet.copyOf(this.teleposer);
    }

    public Set<ResourceLocation> getTeleposerEntities() {
        return ImmutableSet.copyOf(this.teleposerEntities);
    }

    public Set<BlockState> getTransposition() {
        return ImmutableSet.copyOf(this.transposition);
    }

    public Set<BlockState> getGreenGrove() {
        return ImmutableSet.copyOf(this.greenGrove);
    }

    public Set<ResourceLocation> getSacrifice() {
        return ImmutableSet.copyOf(this.sacrifice);
    }
}

