/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.entity.projectile.AbstractEntityThrowingDagger;
import wayoftime.bloodmagic.entity.projectile.EntityThrowingDagger;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemThrowingDagger
extends Item {
    public static int[] soulBracket = new int[]{1, 60, 200, 400, 1000, 2000, 4000};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 15.0, 18.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 4.0};

    public ItemThrowingDagger() {
        super(new Item.Properties().func_200917_a(64).func_200916_a(BloodMagic.TAB));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        playerIn.func_184811_cZ().func_185145_a((Item)this, 50);
        worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EnumDemonWillType largestType = PlayerDemonWillHandler.getLargestWillType(playerIn);
            double souls = PlayerDemonWillHandler.getTotalDemonWill(largestType, playerIn);
            ItemStack copyStack = stack.func_77946_l();
            copyStack.func_190920_e(1);
            AbstractEntityThrowingDagger dagger = this.getDagger(copyStack, worldIn, playerIn);
            int level = this.getLevel(souls);
            if (level >= 0) {
                double willDrop = soulDrop[level] * worldIn.field_73012_v.nextDouble() + staticDrop[level];
                dagger.setWillDrop(willDrop);
                dagger.setWillType(largestType);
            }
            worldIn.func_217376_c((Entity)dagger);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public AbstractEntityThrowingDagger getDagger(ItemStack stack, World world, PlayerEntity player) {
        EntityThrowingDagger dagger = new EntityThrowingDagger(stack, world, (LivingEntity)player);
        dagger.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 0.5f);
        dagger.setDamage(10.0);
        return dagger;
    }

    private int getLevel(double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.throwing_dagger.desc").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

