/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.common.item.ItemBindableBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemBloodOrb
extends ItemBindableBase
implements IBloodOrb,
IForgeItem {
    private final Supplier<BloodOrb> sup;

    public ItemBloodOrb(Supplier<BloodOrb> sup) {
        this.sup = sup;
    }

    @Override
    public BloodOrb getOrb(ItemStack stack) {
        return this.sup.get();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BloodOrb orb = this.getOrb(stack);
        if (orb == null) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (world == null) {
            return super.func_77659_a(world, player, hand);
        }
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(world, player, hand);
        }
        if (!stack.func_77942_o()) {
            return super.func_77659_a(world, player, hand);
        }
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return super.func_77659_a(world, player, hand);
        }
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        SoulNetwork ownerNetwork = NetworkHelper.getSoulNetwork(binding);
        if (binding.getOwnerId().equals(player.func_146103_bH().getId())) {
            ownerNetwork.setOrbTier(orb.getTier());
        }
        ownerNetwork.add(SoulTicket.item(stack, world, (Entity)player, 200), orb.getCapacity());
        ownerNetwork.hurtPlayer(player, 200.0f);
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.orb.desc").func_240699_a_(TextFormatting.GRAY));
        BloodOrb orb = this.getOrb(stack);
        if (flag.func_194127_a() && orb != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.orb.owner", new Object[]{stack.func_77973_b().getRegistryName()}).func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }
}

