/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.item.inventory.ContainerFilter;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.network.RouterFilterPacket;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ScreenFilter
extends ScreenBase<ContainerFilter> {
    private static final ResourceLocation background = BloodMagic.rl("textures/gui/routingfilter.png");
    public IInventory filterInventory;
    private PlayerEntity player;
    private int left;
    private int top;
    private TextFieldWidget textBox;
    private int numberOfAddedButtons = 0;
    private List<String> buttonKeyList = new ArrayList<String>();

    public ScreenFilter(ContainerFilter container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.filterInventory = container.inventoryFilter;
        this.field_146999_f = 176;
        this.field_147000_g = 187;
        this.player = playerInventory.field_70458_d;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.left = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.top = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.textBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.left + 23, this.top + 19, 70, 12, (ITextComponent)new StringTextComponent("itemGroup.search"));
        this.textBox.func_146185_a(false);
        this.textBox.func_146203_f(50);
        this.textBox.func_146189_e(true);
        this.textBox.func_146193_g(0xFFFFFF);
        this.textBox.func_146180_a("");
        this.numberOfAddedButtons = 0;
        this.buttonKeyList.clear();
        ItemStack filterStack = ((ContainerFilter)this.field_147002_h).filterStack;
        if (filterStack.func_77973_b() instanceof IItemFilterProvider) {
            IItemFilterProvider provider = (IItemFilterProvider)filterStack.func_77973_b();
            List<Pair<String, Button.IPressable>> buttonActionList = provider.getButtonAction((ContainerFilter)this.field_147002_h);
            for (Pair<String, Button.IPressable> pair : buttonActionList) {
                if (this.buttonKeyList.contains(pair.getKey())) continue;
                this.buttonKeyList.add((String)pair.getKey());
                Pair<Integer, Integer> buttonLocation = this.getButtonLocation(this.numberOfAddedButtons);
                Button addedButton = new Button(this.left + (Integer)buttonLocation.getLeft(), this.top + (Integer)buttonLocation.getRight(), 20, 20, (ITextComponent)new StringTextComponent(""), (Button.IPressable)pair.getRight());
                if (!provider.isButtonGlobal(filterStack, (String)pair.getKey())) {
                    addedButton.field_230693_o_ = false;
                }
                this.func_230480_a_((Widget)addedButton);
                ++this.numberOfAddedButtons;
            }
        }
    }

    public Pair<Integer, Integer> getButtonLocation(int addedButton) {
        int x = 7;
        int y = 32;
        return Pair.of((Object)(x += addedButton * 20), (Object)y);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.textBox.func_146178_a();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        String str;
        if (this.textBox.func_230999_j_() && (keyCode == 259 || keyCode == 261) && ((ContainerFilter)this.field_147002_h).lastGhostSlotClicked != -1 && (str = this.textBox.func_146179_b()) != null && str.length() > 0) {
            str = str.substring(0, str.length() - 1);
            this.textBox.func_146180_a(str);
            int amount = 0;
            if (str.length() > 0) {
                try {
                    Integer testVal = Integer.decode(str);
                    if (testVal != null) {
                        amount = testVal;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.setValueOfGhostItemInSlot(((ContainerFilter)this.field_147002_h).lastGhostSlotClicked, amount);
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        block8: {
            try {
                Integer charVal = Integer.decode("" + typedChar);
                if (charVal == null) break block8;
                if (this.textBox.func_231042_a_(typedChar, keyCode)) {
                    if (((ContainerFilter)this.field_147002_h).lastGhostSlotClicked != -1) {
                        String str = this.textBox.func_146179_b();
                        int amount = 0;
                        if (!str.isEmpty()) {
                            try {
                                Integer testVal = Integer.decode(str);
                                if (testVal != null) {
                                    amount = testVal;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        this.setValueOfGhostItemInSlot(((ContainerFilter)this.field_147002_h).lastGhostSlotClicked, amount);
                    }
                    return true;
                }
                return super.func_231042_a_(typedChar, keyCode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    private void setValueOfGhostItemInSlot(int ghostItemSlot, int amount) {
        Slot slot = ((ContainerFilter)this.field_147002_h).func_75139_a(ghostItemSlot);
        ItemStack ghostStack = slot.func_75211_c();
        if (!ghostStack.func_190926_b()) {
            GhostItemHelper.setItemGhostAmount(ghostStack, amount);
            GhostItemHelper.setItemGhostAmount(((ContainerFilter)this.field_147002_h).inventoryFilter.func_70301_a(ghostItemSlot), amount);
            if (((ContainerFilter)this.field_147002_h).filterStack.func_77973_b() instanceof IItemFilterProvider) {
                ((IItemFilterProvider)((ContainerFilter)this.field_147002_h).filterStack.func_77973_b()).setGhostItemAmount(((ContainerFilter)this.field_147002_h).filterStack, ghostItemSlot, amount);
            }
        }
        BloodMagic.packetHandler.sendToServer(new RouterFilterPacket(this.player.field_71071_by.field_70461_c, ghostItemSlot, amount));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean testBool = super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (this.textBox.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (((ContainerFilter)this.field_147002_h).lastGhostSlotClicked != -1) {
            this.enableAllButtons();
            Slot slot = ((ContainerFilter)this.field_147002_h).func_75139_a(((ContainerFilter)this.field_147002_h).lastGhostSlotClicked);
            ItemStack stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount == 0) {
                    this.textBox.func_146180_a("");
                } else {
                    this.textBox.func_146180_a("" + amount);
                }
            } else {
                this.textBox.func_146180_a("");
            }
        }
        return true;
    }

    private void enableAllButtons() {
        for (Widget button : this.field_230710_m_) {
            button.field_230693_o_ = true;
        }
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("container.inventory"), 8.0f, 93.0f, 0x404040);
        this.field_230712_o_.func_243248_b(stack, ((ContainerFilter)this.field_147002_h).filterStack.func_200301_q(), 8.0f, 4.0f, 0x404040);
        if (((ContainerFilter)this.field_147002_h).filterStack.func_77973_b() instanceof IItemFilterProvider) {
            for (int i = 0; i < this.numberOfAddedButtons; ++i) {
                int currentButtonState = ((IItemFilterProvider)((ContainerFilter)this.field_147002_h).filterStack.func_77973_b()).getCurrentButtonState(((ContainerFilter)this.field_147002_h).filterStack, this.buttonKeyList.get(i), ((ContainerFilter)this.field_147002_h).lastGhostSlotClicked);
                Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
                Pair<Integer, Integer> textureLocation = ((IItemFilterProvider)((ContainerFilter)this.field_147002_h).filterStack.func_77973_b()).getTexturePositionForState(((ContainerFilter)this.field_147002_h).filterStack, this.buttonKeyList.get(i), currentButtonState);
                int w = 20;
                int h = 20;
                int xl = (Integer)buttonLocation.getLeft();
                int yl = (Integer)buttonLocation.getRight();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.getMinecraft().func_110434_K().func_110577_a(background);
                this.func_238474_b_(stack, xl, yl, (Integer)textureLocation.getLeft(), (Integer)textureLocation.getRight(), w, h);
            }
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(background);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(stack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        ItemStack held = this.player.func_184586_b(Hand.MAIN_HAND);
        if (((ContainerFilter)this.field_147002_h).lastGhostSlotClicked >= 0) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(stack, 106 + x + 21 * (((ContainerFilter)this.field_147002_h).lastGhostSlotClicked % 3), y + 11 + 21 * (((ContainerFilter)this.field_147002_h).lastGhostSlotClicked / 3), 0, 187, 24, 24);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.textBox.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (((ContainerFilter)this.field_147002_h).filterStack.func_77973_b() instanceof IItemFilterProvider) {
            for (int i = 0; i < this.numberOfAddedButtons; ++i) {
                List<ITextComponent> components;
                Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
                int w = 20;
                int h = 20;
                int x = this.field_147003_i + (Integer)buttonLocation.getLeft();
                int y = this.field_147009_r + (Integer)buttonLocation.getRight();
                if (mouseX < x || mouseX >= x + w || mouseY < y || mouseY >= y + h || (components = ((IItemFilterProvider)((ContainerFilter)this.field_147002_h).filterStack.func_77973_b()).getTextForHoverItem(((ContainerFilter)this.field_147002_h).filterStack, this.buttonKeyList.get(i), ((ContainerFilter)this.field_147002_h).lastGhostSlotClicked)) == null || components.isEmpty()) continue;
                tooltip.addAll(components);
            }
        }
        if (!tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, tooltip, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }
}

