/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorBlade;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorShaft;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBearingTile;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;

public class BladeRenderer
extends TileEntityRenderer<TurbineRotorBearingTile> {
    public BladeRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void render(TurbineRotorBearingTile bearing, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int blade180RotationMultiplier;
        BlockState state = bearing.func_195044_w();
        if ((Boolean)state.func_177229_b((Property)MultiblockBlock.ASSEMBLED) == false) return;
        if (!bearing.isRenderBearing) {
            return;
        }
        if (bearing.rotationAxis == null) return;
        if (bearing.rotorConfiguration == null) return;
        if (bearing.rotationAxis.func_195899_a() == 0.0f && bearing.rotationAxis.func_195900_b() == 0.0f && bearing.rotationAxis.func_195902_c() == 0.0f) {
            return;
        }
        double angle = bearing.angle;
        long elapsedTimeNano = System.nanoTime() - BiggerReactors.lastRenderTime;
        double speed = bearing.speed / 10.0;
        if (speed > (double)0.001f) {
            double elapsedTimeMilis = (double)elapsedTimeNano / 1000000.0;
            angle += speed * (double)((float)elapsedTimeMilis / 60000.0f) * 360.0;
            bearing.angle = angle %= 360.0;
        }
        if ((blade180RotationMultiplier = (int)(-bearing.rotationAxis.func_195899_a()) | (int)(-bearing.rotationAxis.func_195900_b()) | (int)bearing.rotationAxis.func_195902_c()) > 0) {
            angle += 180.0;
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        Quaternion axisRotation = null;
        if (bearing.rotationAxis.func_195899_a() != 0.0f) {
            axisRotation = new Quaternion(Vector3f.field_229183_f_, -90.0f * bearing.rotationAxis.func_195899_a(), true);
            angle -= 90.0;
        } else if (bearing.rotationAxis.func_195902_c() != 0.0f) {
            axisRotation = new Quaternion(Vector3f.field_229179_b_, 90.0f * bearing.rotationAxis.func_195902_c(), true);
        } else if (bearing.rotationAxis.func_195900_b() != 1.0f) {
            axisRotation = new Quaternion(Vector3f.field_229179_b_, 180.0f, true);
        }
        if (axisRotation != null) {
            matrixStackIn.func_227863_a_(axisRotation);
        }
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, (float)angle, true));
        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
        int bearingNum = 0;
        Iterator<Vector4i> iterator = bearing.rotorConfiguration.iterator();
        block5: while (true) {
            if (!iterator.hasNext()) {
                matrixStackIn.func_227865_b_();
                return;
            }
            Vector4i vector4i = iterator.next();
            matrixStackIn.func_227861_a_(0.0, 1.0, 0.0);
            BlockPos shaftPos = bearing.func_174877_v().func_177963_a((double)bearing.rotationAxis.func_195899_a(), (double)bearing.rotationAxis.func_195900_b(), (double)bearing.rotationAxis.func_195902_c());
            int skyLight = bearing.func_145831_w().func_226658_a_(LightType.SKY, shaftPos);
            int blockLight = bearing.func_145831_w().func_226658_a_(LightType.BLOCK, shaftPos);
            int combinedLight = skyLight << 16 | blockLight;
            ++bearingNum;
            Minecraft.func_71410_x().func_175602_ab().renderBlock(TurbineRotorShaft.INSTANCE.func_176223_P(), matrixStackIn, bufferIn, combinedLight *= 16, 655360, (IModelData)EmptyModelData.INSTANCE);
            int i = 0;
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (true) {
                block19: {
                    if (n2 >= n) continue block5;
                    Direction direction = directionArray[n2];
                    switch (direction) {
                        case UP: 
                        case DOWN: {
                            if (bearing.rotationAxis.func_195900_b() == 0.0f) break;
                            break block19;
                        }
                        case NORTH: 
                        case SOUTH: {
                            if (bearing.rotationAxis.func_195902_c() == 0.0f) break;
                            break block19;
                        }
                        case WEST: 
                        case EAST: {
                            if (bearing.rotationAxis.func_195899_a() != 0.0f) break block19;
                        }
                    }
                    for (int j = 0; j < vector4i.get(i); ++j) {
                        matrixStackIn.func_227860_a_();
                        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
                        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, (float)(180 * (i & 1) + blade180RotationMultiplier * 135 * (i & 2)), true));
                        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
                        matrixStackIn.func_227861_a_(0.0, 0.0, (double)(-(j + 1)));
                        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
                        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
                        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
                        Minecraft.func_71410_x().func_175602_ab().renderBlock(TurbineRotorBlade.INSTANCE.func_176223_P(), matrixStackIn, bufferIn, combinedLight, 655360, (IModelData)EmptyModelData.INSTANCE);
                        matrixStackIn.func_227865_b_();
                    }
                    ++i;
                }
                ++n2;
            }
            break;
        }
    }

    public boolean isGlobalRenderer(@Nonnull TurbineRotorBearingTile te) {
        return true;
    }
}

