/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.experimental;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorBattery;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorCoolantTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorFuelTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.experimental.Battery;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.experimental.CoolantTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.experimental.FuelTank;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3d;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3dc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.HeatBody;

public class ExperimentalReactorSimulation
implements IReactorSimulation {
    private int x;
    private int y;
    private int z;
    private ReactorModeratorRegistry.IModeratorProperties[][][] moderatorProperties;
    private ControlRod[][] controlRodsXZ;
    private final ArrayList<ControlRod> controlRods = new ArrayList();
    private double fuelToCasingRFKT;
    private double fuelToManifoldSurfaceArea;
    private double casingToCoolantSystemRFKT;
    private double casingToAmbientRFKT;
    private final HeatBody fuelHeat = new HeatBody();
    private final HeatBody caseHeat = new HeatBody();
    private final HeatBody ambientHeat = new HeatBody();
    private double fuelFertility = 1.0;
    private HeatBody output;
    private final Battery battery = new Battery();
    private final CoolantTank coolantTank = new CoolantTank();
    private final FuelTank fuelTank = new FuelTank();
    private boolean passivelyCooled = true;
    private boolean active = false;
    public double fuelConsumedLastTick = 0.0;
    private static final Vector2ic[] cardinalDirections = new Vector2ic[]{new Vector2i(1, 0), new Vector2i(-1, 0), new Vector2i(0, 1), new Vector2i(0, -1)};
    private static final Vector3ic[] axisDirections = new Vector3ic[]{new Vector3i(1, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 1, 0), new Vector3i(0, -1, 0), new Vector3i(0, 0, 1), new Vector3i(0, 0, -1)};
    private static final ArrayList<ArrayList<RayStep>> rays = new ArrayList();
    private static final Vector3dc[] rayDirections = new Vector3dc[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, -1.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(1.0, 1.0, 0.0), new Vector3d(1.0, -1.0, 0.0), new Vector3d(-1.0, 1.0, 0.0), new Vector3d(-1.0, -1.0, 0.0), new Vector3d(0.0, 1.0, 1.0), new Vector3d(0.0, 1.0, -1.0), new Vector3d(0.0, -1.0, 1.0), new Vector3d(0.0, -1.0, -1.0), new Vector3d(1.0, 0.0, 1.0), new Vector3d(-1.0, 0.0, 1.0), new Vector3d(1.0, 0.0, -1.0), new Vector3d(-1.0, 0.0, -1.0)};

    @OnModLoad
    private static void onModLoad() {
        Vector3d radiationDirection = new Vector3d();
        Vector3d currentSegment = new Vector3d();
        Vector3d currentSegmentStart = new Vector3d();
        Vector3d currentSegmentEnd = new Vector3d();
        Vector3d currentSectionBlock = new Vector3d();
        Vector3d planes = new Vector3d();
        Vector3d[] intersections = new Vector3d[]{new Vector3d(), new Vector3d(), new Vector3d()};
        for (Vector3dc rayDirection : rayDirections) {
            ArrayList<RayStep> raySteps = new ArrayList<RayStep>();
            radiationDirection.set(rayDirection);
            radiationDirection.sub(0.5, 0.5, 0.5);
            radiationDirection.normalize();
            currentSegmentStart.set((Vector3dc)radiationDirection);
            currentSegmentStart.mul(1.0 / Math.abs(currentSegmentStart.get(currentSegmentStart.maxComponent())));
            currentSegmentStart.mul(0.5);
            radiationDirection.mul(4.0 + currentSegmentStart.length());
            double processedLength = 0.0;
            double totalLength = radiationDirection.length();
            currentSegmentStart.set(0.0);
            planes.set((Vector3dc)radiationDirection);
            planes.absolute();
            planes.div(radiationDirection);
            planes.mul(0.5);
            boolean firstIteration = true;
            while (true) {
                for (int i = 0; i < 3; ++i) {
                    Vector3d intersection = intersections[i];
                    intersection.set((Vector3dc)radiationDirection);
                    double component = intersection.get(i);
                    double plane = planes.get(i);
                    intersection.mul(plane / component);
                }
                int minVec = 0;
                double minLength = Double.POSITIVE_INFINITY;
                for (int i = 0; i < 3; ++i) {
                    double length = intersections[i].lengthSquared();
                    if (!(length < minLength)) continue;
                    minVec = i;
                    minLength = length;
                }
                planes.setComponent(minVec, planes.get(minVec) + planes.get(minVec) / Math.abs(planes.get(minVec)));
                currentSegmentEnd.set((Vector3dc)intersections[minVec]);
                currentSegment.set((Vector3dc)currentSegmentEnd).sub((Vector3dc)currentSegmentStart);
                currentSectionBlock.set((Vector3dc)currentSegmentEnd).sub((Vector3dc)currentSegmentStart).mul(0.5).add(0.5, 0.5, 0.5).add((Vector3dc)currentSegmentStart).floor();
                double segmentLength = currentSegment.length();
                boolean breakAfterLoop = processedLength + segmentLength >= totalLength;
                segmentLength = Math.min(totalLength - processedLength, segmentLength);
                if (!firstIteration && segmentLength != 0.0) {
                    raySteps.add(new RayStep(new Vector3i((Vector3dc)currentSectionBlock, 0), segmentLength));
                }
                firstIteration = false;
                processedLength += segmentLength;
                if (breakAfterLoop) break;
                currentSegmentStart.set((Vector3dc)currentSegmentEnd);
            }
            rays.add(raySteps);
        }
    }

    public ExperimentalReactorSimulation(double ambientTemperature) {
        this.ambientHeat.setInfinite(true);
        this.ambientHeat.setTemperature(ambientTemperature + 273.15);
        this.caseHeat.setTemperature(ambientTemperature + 273.15);
        this.fuelHeat.setTemperature(ambientTemperature + 273.15);
        this.battery.setTemperature(ambientTemperature + 273.15);
    }

    @Override
    public void resize(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.moderatorProperties = new ReactorModeratorRegistry.IModeratorProperties[x][y][z];
        this.controlRodsXZ = new ControlRod[x][z];
        this.controlRods.clear();
    }

    @Override
    public void setModeratorProperties(int x, int y, int z, ReactorModeratorRegistry.IModeratorProperties properties) {
        this.moderatorProperties[x][y][z] = properties;
    }

    @Override
    public void setControlRod(int x, int z) {
        ControlRod rod = new ControlRod(x, z);
        this.controlRods.add(rod);
        this.controlRodsXZ[x][z] = rod;
    }

    @Override
    public void setManifold(int x, int y, int z) {
        this.moderatorProperties[x][y][z] = this.coolantTank;
    }

    @Override
    public void setControlRodInsertion(int x, int z, double insertion) {
        this.controlRodsXZ[x][z].insertion = insertion;
    }

    @Override
    public void setPassivelyCooled(boolean passivelyCooled) {
        this.passivelyCooled = passivelyCooled;
        this.output = passivelyCooled ? this.battery : this.coolantTank;
    }

    @Override
    public boolean isPassive() {
        return this.passivelyCooled;
    }

    @Override
    public void updateInternalValues() {
        this.fuelTank.setCapacity(Config.Reactor.Modern.PerFuelRodCapacity * (long)this.controlRods.size() * (long)this.y);
        this.fuelToCasingRFKT = 0.0;
        this.fuelToManifoldSurfaceArea = 0.0;
        for (ControlRod controlRod : this.controlRods) {
            for (int i = 0; i < this.y; ++i) {
                for (Vector2ic direction : cardinalDirections) {
                    if (controlRod.x + direction.x() < 0 || controlRod.x + direction.x() >= this.x || controlRod.z + direction.y() < 0 || controlRod.z + direction.y() >= this.z) {
                        this.fuelToCasingRFKT += Config.Reactor.Modern.CasingHeatTransferRFMKT;
                        continue;
                    }
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[controlRod.x + direction.x()][i][controlRod.z + direction.y()];
                    if (properties == null) continue;
                    if (properties instanceof CoolantTank) {
                        this.fuelToManifoldSurfaceArea += 1.0;
                        continue;
                    }
                    this.fuelToCasingRFKT += properties.heatConductivity();
                }
            }
        }
        this.fuelToCasingRFKT *= Config.Reactor.Modern.FuelToCasingRFKTMultiplier;
        this.casingToCoolantSystemRFKT = 2 * (this.x * this.y + this.x * this.z + this.z * this.y);
        int manifoldCount = 0;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                for (int k = 0; k < this.z; ++k) {
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[i][j][k];
                    if (!(properties instanceof CoolantTank)) continue;
                    ++manifoldCount;
                    for (Vector3ic axisDirection : axisDirections) {
                        int neighborX = i + axisDirection.x();
                        int neighborY = j + axisDirection.y();
                        int neighborZ = k + axisDirection.z();
                        if (neighborX < 0 || neighborX >= this.x || neighborY < 0 || neighborY >= this.y || neighborZ < 0 || neighborZ >= this.z) {
                            this.casingToCoolantSystemRFKT -= 1.0;
                            continue;
                        }
                        ReactorModeratorRegistry.IModeratorProperties neighborProperties = this.moderatorProperties[neighborX][neighborY][neighborZ];
                        if (neighborProperties instanceof CoolantTank) continue;
                        this.casingToCoolantSystemRFKT += 1.0;
                    }
                }
            }
        }
        this.casingToCoolantSystemRFKT *= Config.Reactor.Modern.CasingToCoolantRFMKT;
        this.casingToAmbientRFKT = (double)(2 * ((this.x + 2) * (this.y + 2) + (this.x + 2) * (this.z + 2) + (this.z + 2) * (this.y + 2))) * Config.Reactor.Modern.CasingToAmbientRFMKT;
        if (this.passivelyCooled) {
            this.casingToCoolantSystemRFKT *= Config.Reactor.Modern.PassiveCoolingTransferEfficiency;
            this.coolantTank.perSideCapacity = 0L;
            this.battery.setCapacity(((long)(this.x + 2) * (long)(this.y + 2) * (long)(this.z + 2) - (long)this.x * (long)this.y * (long)this.z) * Config.Reactor.Modern.PassiveBatteryPerExternalBlock);
        } else {
            this.coolantTank.perSideCapacity = (long)(this.controlRods.size() * this.y) * Config.Reactor.Modern.CoolantTankAmountPerFuelRod;
            this.coolantTank.perSideCapacity += (long)manifoldCount * Config.Reactor.Modern.CoolantTankAmountPerFuelRod;
        }
        this.fuelHeat.setRfPerKelvin((double)(this.controlRods.size() * this.y) * Config.Reactor.Modern.RodFEPerUnitVolumeKelvin);
        this.caseHeat.setRfPerKelvin((double)(this.x * this.y * this.z) * Config.Reactor.Modern.RodFEPerUnitVolumeKelvin);
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void tick() {
        if (this.active) {
            this.radiate();
        } else {
            this.fuelConsumedLastTick = 0.0;
        }
        double denominator = Config.Reactor.Modern.FuelFertilityDecayDenominator;
        if (!this.active) {
            denominator *= Config.Reactor.Modern.FuelFertilityDecayDenominatorInactiveMultiplier;
        }
        this.fuelFertility = Math.max(0.0, this.fuelFertility - Math.max(Config.Reactor.Modern.FuelFertilityMinimumDecay, this.fuelFertility / denominator));
        this.fuelHeat.transferWith(this.caseHeat, this.fuelToCasingRFKT + this.fuelToManifoldSurfaceArea * this.coolantTank.heatConductivity());
        this.output.transferWith(this.caseHeat, this.casingToCoolantSystemRFKT);
        this.caseHeat.transferWith(this.ambientHeat, this.casingToAmbientRFKT);
    }

    private void radiate() {
        double radiationPenaltyBase = Math.exp(-Config.Reactor.Modern.RadPenaltyShiftMultiplier * Math.exp(-0.001 * Config.Reactor.Modern.RadPenaltyRateMultiplier * (this.fuelHeat.temperature() - 273.15)));
        long baseFuelAmount = this.fuelTank.fuel() + this.fuelTank.waste() / 100L;
        double rawRadIntensity = (double)baseFuelAmount * Config.Reactor.Modern.FissionEventsPerFuelUnit;
        double scaledRadIntensity = Math.pow(Math.pow(rawRadIntensity, Config.Reactor.Modern.FuelReactivity) / (double)this.controlRods.size(), Config.Reactor.Modern.FuelReactivity) * (double)this.controlRods.size();
        double initialHardness = Math.min(1.0, (double)0.2f + 0.8 * radiationPenaltyBase);
        double rawIntensity = 1.0 + -Config.Reactor.Modern.RadIntensityScalingMultiplier * Math.exp(-10.0 * Config.Reactor.Modern.RadIntensityScalingShiftMultiplier * Math.exp((double)-0.001f * Config.Reactor.Modern.RadIntensityScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        double fuelAbsorptionTemperatureCoefficient = 1.0 - Config.Reactor.Modern.FuelAbsorptionScalingMultiplier * Math.exp(-10.0 * Config.Reactor.Modern.FuelAbsorptionScalingShiftMultiplier * Math.exp(-0.001 * Config.Reactor.Modern.FuelAbsorptionScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        double fuelHardnessMultiplier = 1.0 / Config.Reactor.Modern.FuelHardnessDivisor;
        double rawFuelUsage = 0.0;
        double fuelRFAdded = 0.0;
        double fuelRadAdded = 0.0;
        double caseRFAdded = 0.0;
        for (int r = 0; r < this.controlRods.size(); ++r) {
            ControlRod rod = this.controlRods.get(r);
            double controlRodModifier = (100.0 - rod.insertion) / 100.0;
            double effectiveRadIntensity = scaledRadIntensity * controlRodModifier;
            double effectiveRawRadIntensity = rawRadIntensity * controlRodModifier;
            double initialIntensity = effectiveRadIntensity * rawIntensity;
            rawFuelUsage += Config.Reactor.Modern.FuelPerRadiationUnit * effectiveRawRadIntensity / this.fertility() * Config.Reactor.FuelUsageMultiplier;
            fuelRFAdded += Config.Reactor.Modern.FEPerRadiationUnit * initialIntensity;
            double rayMultiplier = 1.0 / (double)(rays.size() * this.y);
            for (int i = 0; i < this.y; ++i) {
                block2: for (int j = 0; j < rays.size(); ++j) {
                    ArrayList<RayStep> raySteps = rays.get(j);
                    double neutronHardness = initialHardness;
                    double neutronIntensity = initialIntensity * rayMultiplier;
                    for (int k = 0; k < raySteps.size(); ++k) {
                        RayStep rayStep = raySteps.get(k);
                        int currentX = rod.x + rayStep.offset.x;
                        int currentY = i + rayStep.offset.y;
                        int currentZ = rod.z + rayStep.offset.z;
                        if (currentX < 0 || currentX >= this.x || currentY < 0 || currentY >= this.y || currentZ < 0 || currentZ >= this.z) continue block2;
                        ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[currentX][currentY][currentZ];
                        if (properties != null) {
                            double radiationAbsorbed = neutronIntensity * properties.absorption() * (1.0 - neutronHardness) * rayStep.length;
                            neutronIntensity = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                            neutronHardness /= (properties.moderation() - 1.0) * rayStep.length + 1.0;
                            caseRFAdded += properties.heatEfficiency() * radiationAbsorbed * Config.Reactor.Modern.FEPerRadiationUnit;
                            continue;
                        }
                        double controlRodInsertion = this.controlRodsXZ[currentX][currentZ].insertion * 0.001;
                        double baseAbsorption = fuelAbsorptionTemperatureCoefficient * (1.0 - neutronHardness / Config.Reactor.Modern.FuelHardnessDivisor);
                        double scaledAbsorption = baseAbsorption * Config.Reactor.Modern.FuelAbsorptionCoefficient * rayStep.length;
                        double controlRodBonus = (1.0 - scaledAbsorption) * controlRodInsertion * 0.5;
                        double controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5;
                        double radiationAbsorbed = (scaledAbsorption + controlRodBonus) * neutronIntensity;
                        double fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * neutronIntensity;
                        double fuelModerationFactor = Config.Reactor.Modern.FuelModerationFactor;
                        fuelModerationFactor += fuelModerationFactor * controlRodInsertion + controlRodInsertion;
                        neutronIntensity = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                        neutronHardness /= (fuelModerationFactor - 1.0) * rayStep.length + 1.0;
                        fuelRFAdded += radiationAbsorbed * Config.Reactor.Modern.FEPerRadiationUnit;
                        fuelRadAdded += fertilityAbsorbed;
                    }
                }
            }
        }
        rawFuelUsage /= (double)this.controlRods.size();
        fuelRFAdded /= (double)this.controlRods.size();
        caseRFAdded /= (double)this.controlRods.size();
        if (!Double.isNaN(fuelRadAdded /= (double)this.controlRods.size())) {
            this.fuelFertility += fuelRadAdded;
        }
        if (!Double.isNaN(fuelRFAdded)) {
            this.fuelHeat.absorbRF(fuelRFAdded);
        }
        if (!Double.isNaN(caseRFAdded)) {
            this.caseHeat.absorbRF(caseRFAdded);
        }
        this.fuelConsumedLastTick = this.fuelTank.burn(rawFuelUsage);
    }

    @Override
    public IReactorBattery battery() {
        return this.battery;
    }

    @Override
    public IReactorCoolantTank coolantTank() {
        return this.coolantTank;
    }

    @Override
    public IReactorFuelTank fuelTank() {
        return this.fuelTank;
    }

    @Override
    public long FEProducedLastTick() {
        return this.passivelyCooled ? this.battery.generatedLastTick() : this.coolantTank.rfTransferredLastTick();
    }

    @Override
    public long MBProducedLastTick() {
        return this.coolantTank.transitionedLastTick();
    }

    @Override
    public long maxMBProductionLastTick() {
        return this.coolantTank.maxTransitionedLastTick();
    }

    @Override
    public long outputLastTick() {
        return this.passivelyCooled ? this.battery.generatedLastTick() : this.coolantTank.transitionedLastTick();
    }

    @Override
    public double fuelConsumptionLastTick() {
        return this.fuelConsumedLastTick;
    }

    @Override
    public double fertility() {
        if (this.fuelFertility <= 1.0) {
            return 1.0;
        }
        return Math.log10(this.fuelFertility) + 1.0;
    }

    @Override
    public double fuelHeat() {
        return this.fuelHeat.temperature() - 273.15;
    }

    @Override
    public double caseHeat() {
        return this.caseHeat.temperature() - 273.15;
    }

    @Override
    public double ambientTemperature() {
        return this.ambientHeat.temperature() - 273.15;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("fuelTank", (INBT)this.fuelTank.serializeNBT());
        nbt.func_218657_a("coolantTank", (INBT)this.coolantTank.serializeNBT());
        nbt.func_218657_a("battery", (INBT)this.battery.serializeNBT());
        nbt.func_74780_a("fuelFertility", this.fuelFertility);
        nbt.func_74780_a("fuelHeat", this.fuelHeat.temperature() - 273.15);
        nbt.func_74780_a("reactorHeat", this.caseHeat.temperature() - 273.15);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.fuelTank.deserializeNBT(nbt.func_74775_l("fuelTank"));
        this.coolantTank.deserializeNBT(nbt.func_74775_l("coolantTank"));
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        this.fuelFertility = nbt.func_74769_h("fuelFertility");
        this.fuelHeat.setTemperature(nbt.func_74769_h("fuelHeat") + 273.15);
        this.caseHeat.setTemperature(nbt.func_74769_h("reactorHeat") + 273.15);
    }

    private static class RayStep {
        final Vector3i offset;
        final double length;

        private RayStep(Vector3i offset, double length) {
            this.offset = offset;
            this.length = length;
        }
    }

    private static class ControlRod {
        final int x;
        final int z;
        double insertion = 0.0;

        private ControlRod(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }
}

