/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorFuelRod;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic.ClassicReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.experimental.MultithreadedReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.modern.ModernReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorAccessPortTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorControlRodTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorCoolantPortTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorFuelRodTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorGlassTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorManifoldTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorPowerTapTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorTerminalTile;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.generic.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.rectangular.RectangularMultiblockController;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.Util;

public class ReactorMultiblockController
extends RectangularMultiblockController<ReactorMultiblockController, ReactorBaseTile, ReactorBaseBlock> {
    private ReactorActivity reactorActivity = ReactorActivity.INACTIVE;
    private final Set<ReactorTerminalTile> terminals = new HashSet<ReactorTerminalTile>();
    private final List<ReactorControlRodTile> controlRods = new ArrayList<ReactorControlRodTile>();
    private final Set<ReactorFuelRodTile> fuelRods = new LinkedHashSet<ReactorFuelRodTile>();
    private final ArrayList<Set<ReactorFuelRodTile>> fuelRodsByLevel = new ArrayList();
    private final Set<ReactorPowerTapTile> powerPorts = new HashSet<ReactorPowerTapTile>();
    private final Set<ReactorAccessPortTile> accessPorts = new HashSet<ReactorAccessPortTile>();
    private final Set<ReactorCoolantPortTile> coolantPorts = new HashSet<ReactorCoolantPortTile>();
    private final Set<ReactorManifoldTile> manifolds = new LinkedHashSet<ReactorManifoldTile>();
    boolean updateBlockStates = false;
    private IReactorSimulation simulation = this.createSimulation();
    private boolean forceDirty = false;
    long currentFuelRenderLevel = 0L;
    long currentWasteRenderLevel = 0L;
    private boolean autoEjectWaste = true;

    public ReactorMultiblockController(@Nonnull World world) {
        super(world, tile -> tile instanceof ReactorBaseTile, block -> block instanceof ReactorBaseBlock);
        this.minSize.set(3);
        this.maxSize.set(Config.Reactor.MaxLength, Config.Reactor.MaxHeight, Config.Reactor.MaxWidth);
        this.interiorValidator = ReactorModeratorRegistry::isBlockAllowed;
        this.setAssemblyValidator(genericController -> {
            if (this.terminals.isEmpty()) {
                throw new ValidationError("multiblock.error.biggerreactors.no_terminal");
            }
            if (this.controlRods.isEmpty()) {
                throw new ValidationError("multiblock.error.biggerreactors.no_rods");
            }
            if (!this.powerPorts.isEmpty() && !this.coolantPorts.isEmpty()) {
                throw new ValidationError("multiblock.error.biggerreactors.coolant_and_power_ports");
            }
            BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
            long tick = Phosphophyllite.tickNumber();
            for (ReactorControlRodTile reactorControlRodTile : this.controlRods) {
                mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)reactorControlRodTile.func_174877_v());
                if (mutableBlockPos.func_177956_o() != this.maxCoord().y()) {
                    throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.control_rod_not_on_top", new Object[]{reactorControlRodTile.func_174877_v().func_177958_n(), reactorControlRodTile.func_174877_v().func_177956_o(), reactorControlRodTile.func_174877_v().func_177952_p()}));
                }
                for (int i = 0; i < this.maxCoord().y() - this.minCoord().y() - 1; ++i) {
                    mutableBlockPos.func_196234_d(0, -1, 0);
                    ReactorBaseTile tile = (ReactorBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                    if (!(tile instanceof ReactorFuelRodTile)) {
                        throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.fuel_rod_gap", new Object[]{reactorControlRodTile.func_174877_v().func_177958_n(), reactorControlRodTile.func_174877_v().func_177956_o() + (-1 - i), reactorControlRodTile.func_174877_v().func_177952_p()}));
                    }
                    ((ReactorFuelRodTile)tile).lastCheckedTick = tick;
                }
            }
            for (ReactorFuelRodTile reactorFuelRodTile : this.fuelRods) {
                if (reactorFuelRodTile.lastCheckedTick == tick) continue;
                throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.no_control_rod_for_fuel_rod", new Object[]{reactorFuelRodTile.func_174877_v().func_177958_n(), reactorFuelRodTile.func_174877_v().func_177952_p()}));
            }
            ArrayList<ReactorManifoldTile> manifoldsToCheck = new ArrayList<ReactorManifoldTile>();
            block3: for (ReactorManifoldTile manifold : this.manifolds) {
                BlockPos pos2 = manifold.func_174877_v();
                if (pos2.func_177958_n() != this.minCoord().x() + 1 && pos2.func_177958_n() != this.maxCoord().x() - 1 && pos2.func_177956_o() != this.minCoord().y() + 1 && pos2.func_177956_o() != this.maxCoord().y() - 1 && pos2.func_177952_p() != this.minCoord().z() + 1 && pos2.func_177952_p() != this.maxCoord().z() - 1) continue;
                for (Direction value : Direction.values()) {
                    mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)pos2);
                    mutableBlockPos.func_189536_c(value);
                    TileEntity edgeTile = this.blocks.getTile((BlockPos)mutableBlockPos);
                    if (edgeTile == null || edgeTile instanceof ReactorGlassTile || !((ReactorBaseBlock)edgeTile.func_195044_w().func_177230_c()).isGoodForExterior()) continue;
                    manifoldsToCheck.add(manifold);
                    manifold.lastCheckedTick = tick;
                    continue block3;
                }
            }
            while (!manifoldsToCheck.isEmpty()) {
                ReactorManifoldTile reactorManifoldTile = (ReactorManifoldTile)((Object)((Object)manifoldsToCheck.remove(manifoldsToCheck.size() - 1)));
                reactorManifoldTile.lastCheckedTick = tick;
                for (Direction value : Direction.values()) {
                    mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)reactorManifoldTile.func_174877_v());
                    mutableBlockPos.func_189536_c(value);
                    ReactorBaseTile tile = (ReactorBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                    if (!(tile instanceof ReactorManifoldTile) || ((ReactorManifoldTile)tile).lastCheckedTick == tick) continue;
                    manifoldsToCheck.add((ReactorManifoldTile)tile);
                }
            }
            for (ReactorManifoldTile manifold : this.manifolds) {
                if (manifold.lastCheckedTick == tick) continue;
                BlockPos pos3 = manifold.func_174877_v();
                throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.dangling_manifold", new Object[]{pos3.func_177958_n(), pos3.func_177956_o(), pos3.func_177952_p()}));
            }
            Util.chunkCachedBlockStateIteration((Vector3ic)this.minCoord(), (Vector3ic)this.maxCoord(), (World)world, (block, pos) -> {
                if (block.func_177230_c() instanceof ReactorBaseBlock) {
                    mutableBlockPos.func_181079_c(pos.x, pos.y, pos.z);
                    if (!this.blocks.containsPos((BlockPos)mutableBlockPos)) {
                        throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.dangling_internal_part", new Object[]{pos.x, pos.y, pos.z}));
                    }
                }
            });
            return true;
        });
    }

    protected void onPartPlaced(@Nonnull ReactorBaseTile placed) {
        this.onPartAttached(placed);
    }

    protected synchronized void onPartAttached(@Nonnull ReactorBaseTile tile) {
        if (tile instanceof ReactorTerminalTile) {
            this.terminals.add((ReactorTerminalTile)tile);
        }
        if (tile instanceof ReactorControlRodTile && !this.controlRods.contains((Object)tile)) {
            this.controlRods.add((ReactorControlRodTile)tile);
        }
        if (tile instanceof ReactorFuelRodTile) {
            this.fuelRods.add((ReactorFuelRodTile)tile);
        }
        if (tile instanceof ReactorPowerTapTile) {
            this.powerPorts.add((ReactorPowerTapTile)tile);
        }
        if (tile instanceof ReactorAccessPortTile) {
            this.accessPorts.add((ReactorAccessPortTile)tile);
        }
        if (tile instanceof ReactorCoolantPortTile) {
            this.coolantPorts.add((ReactorCoolantPortTile)tile);
        }
        if (tile instanceof ReactorManifoldTile) {
            this.manifolds.add((ReactorManifoldTile)tile);
        }
    }

    protected void onPartBroken(@Nonnull ReactorBaseTile broken) {
        this.onPartDetached(broken);
    }

    protected synchronized void onPartDetached(@Nonnull ReactorBaseTile tile) {
        int index;
        if (tile instanceof ReactorTerminalTile) {
            this.terminals.remove((Object)tile);
        }
        if (tile instanceof ReactorControlRodTile && (index = this.controlRods.indexOf((Object)tile)) != -1) {
            this.controlRods.set(index, this.controlRods.get(this.controlRods.size() - 1));
            this.controlRods.remove(this.controlRods.size() - 1);
        }
        if (tile instanceof ReactorFuelRodTile) {
            this.fuelRods.remove((Object)tile);
        }
        if (tile instanceof ReactorPowerTapTile) {
            this.powerPorts.remove((Object)tile);
        }
        if (tile instanceof ReactorAccessPortTile) {
            this.accessPorts.remove((Object)tile);
        }
        if (tile instanceof ReactorCoolantPortTile) {
            this.coolantPorts.remove((Object)tile);
        }
        if (tile instanceof ReactorManifoldTile) {
            this.manifolds.remove((Object)tile);
        }
    }

    public void updateBlockStates() {
        this.terminals.forEach(terminal -> {
            this.world.func_175656_a(terminal.func_174877_v(), (BlockState)terminal.func_195044_w().func_206870_a(ReactorActivity.REACTOR_ACTIVITY_ENUM_PROPERTY, (Comparable)((Object)this.reactorActivity)));
            terminal.func_70296_d();
        });
    }

    public synchronized void setActive(@Nonnull ReactorActivity newState) {
        if (this.reactorActivity != newState) {
            this.reactorActivity = newState;
            this.updateBlockStates = true;
        }
        this.simulation.setActive(this.reactorActivity == ReactorActivity.ACTIVE);
    }

    public void toggleActive() {
        this.setActive(this.reactorActivity == ReactorActivity.ACTIVE ? ReactorActivity.INACTIVE : ReactorActivity.ACTIVE);
    }

    public boolean isActive() {
        return this.reactorActivity == ReactorActivity.ACTIVE;
    }

    protected void read(@Nonnull CompoundNBT compound) {
        if (compound.func_74764_b("reactorState")) {
            this.reactorActivity = ReactorActivity.valueOf(compound.func_74779_i("reactorState").toUpperCase());
            this.simulation.setActive(this.reactorActivity == ReactorActivity.ACTIVE);
        }
        if (compound.func_74764_b("simulationData")) {
            this.simulation.deserializeNBT((INBT)compound.func_74775_l("simulationData"));
        }
        this.updateBlockStates = true;
    }

    @Nonnull
    protected CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("reactorState", this.reactorActivity.toString());
        compound.func_218657_a("simulationData", this.simulation.serializeNBT());
        return compound;
    }

    protected void onMerge(@Nonnull ReactorMultiblockController otherController) {
        this.setActive(ReactorActivity.INACTIVE);
        this.distributeFuel();
        otherController.distributeFuel();
        this.simulation = this.createSimulation();
    }

    protected void onAssembled() {
        this.simulation.resize(this.maxCoord().x() - this.minCoord().x() - 1, this.maxCoord().y() - this.minCoord().y() - 1, this.maxCoord().z() - this.minCoord().z() - 1);
        Vector3i start = new Vector3i(1).add(this.minCoord());
        Vector3i end = new Vector3i(-1).add(this.maxCoord());
        Util.chunkCachedBlockStateIteration((Vector3ic)start, (Vector3ic)end, (World)this.world, (state, pos) -> {
            pos.sub((Vector3ic)start);
            if (!(state.func_177230_c() instanceof ReactorBaseBlock)) {
                this.simulation.setModeratorProperties(pos.x, pos.y, pos.z, ReactorModeratorRegistry.blockModeratorProperties(state.func_177230_c()));
            }
        });
        for (ReactorManifoldTile manifold : this.manifolds) {
            BlockPos manifoldPos = manifold.func_174877_v();
            this.simulation.setManifold(manifoldPos.func_177958_n() - start.x, manifoldPos.func_177956_o() - start.y, manifoldPos.func_177952_p() - start.z);
        }
        for (ReactorControlRodTile controlRod : this.controlRods) {
            BlockPos rodPos = controlRod.func_174877_v();
            this.simulation.setControlRod(rodPos.func_177958_n() - start.x, rodPos.func_177952_p() - start.z);
        }
        this.simulation.setPassivelyCooled(this.coolantPorts.isEmpty());
        this.simulation.updateInternalValues();
        this.updateControlRodLevels();
        this.collectFuel();
        int levels = this.maxCoord().y() - this.minCoord().y() - 1;
        this.fuelRodsByLevel.clear();
        this.fuelRodsByLevel.ensureCapacity(levels);
        for (int i = 0; i < levels; ++i) {
            this.fuelRodsByLevel.add(new LinkedHashSet());
        }
        this.fuelRods.forEach(rod -> {
            int rodLevel = rod.func_174877_v().func_177956_o();
            rodLevel -= this.minCoord().y();
            this.fuelRodsByLevel.get(--rodLevel).add((ReactorFuelRodTile)((Object)rod));
        });
        this.updateFuelRenderingLevel(true);
    }

    protected void onUnpaused() {
        this.onAssembled();
    }

    protected void onDisassembled() {
        this.distributeFuel();
        this.setActive(ReactorActivity.INACTIVE);
    }

    IReactorSimulation createSimulation() {
        switch (Config.mode) {
            case CLASSIC: {
                return new ClassicReactorSimulation();
            }
            default: {
                return new ModernReactorSimulation(20.0);
            }
            case EXPERIMENTAL: 
        }
        return new MultithreadedReactorSimulation(20.0);
    }

    public IReactorSimulation simulation() {
        return this.simulation;
    }

    public synchronized void tick() {
        if (this.updateBlockStates) {
            this.updateBlockStates = false;
            this.updateBlockStates();
        }
        this.simulation.tick();
        if (this.autoEjectWaste) {
            this.ejectWaste();
        }
        long totalPowerRequested = 0L;
        long startingPower = this.simulation.battery().stored();
        for (ReactorPowerTapTile powerPort : this.powerPorts) {
            totalPowerRequested += powerPort.distributePower(startingPower, true);
        }
        float distributionMultiplier = Math.min(1.0f, (float)startingPower / (float)totalPowerRequested);
        for (ReactorPowerTapTile powerPort : this.powerPorts) {
            long powerRequested = powerPort.distributePower(startingPower, true);
            powerRequested = (long)((float)powerRequested * distributionMultiplier);
            powerRequested = Math.min(this.simulation.battery().stored(), powerRequested);
            long powerAccepted = powerPort.distributePower(powerRequested, false);
            this.simulation.battery().extract(powerAccepted);
        }
        this.coolantPorts.forEach(ReactorCoolantPortTile::pushFluid);
        this.updateFuelRenderingLevel();
        if (Phosphophyllite.tickNumber() % 2L == 0L || this.forceDirty) {
            this.forceDirty = false;
            this.markDirty();
        }
    }

    private void updateFuelRenderingLevel() {
        this.updateFuelRenderingLevel(false);
    }

    private void updateFuelRenderingLevel(boolean forceFullUpdate) {
        BlockState newState;
        BlockState state;
        long levelBasePixel;
        long i;
        if (this.simulation.fuelTank().capacity() == 0L) {
            return;
        }
        long rodPixels = (long)this.fuelRodsByLevel.size() * 16L;
        long fuelPixels = this.simulation.fuelTank().totalStored() * rodPixels / this.simulation.fuelTank().capacity();
        long wastePixels = this.simulation.fuelTank().waste() * rodPixels / this.simulation.fuelTank().capacity();
        if (fuelPixels == this.currentFuelRenderLevel && wastePixels == this.currentWasteRenderLevel) {
            return;
        }
        long lowerFuelPixel = Math.min(this.currentFuelRenderLevel, fuelPixels);
        long upperFuelPixel = Math.max(this.currentFuelRenderLevel, fuelPixels);
        long lowerWastePixel = Math.min(this.currentWasteRenderLevel, wastePixels);
        long upperWastePixel = Math.max(this.currentWasteRenderLevel, wastePixels);
        if (forceFullUpdate) {
            lowerWastePixel = 0L;
            lowerFuelPixel = 0L;
            upperFuelPixel = upperWastePixel = rodPixels;
        }
        long lowerFuelUpdateLevel = lowerFuelPixel / 16L;
        long upperFuelUpdateLevel = upperFuelPixel / 16L + (long)(upperFuelPixel % 16L > 0L ? 1 : 0);
        long lowerWasteUpdateLevel = lowerWastePixel / 16L;
        long upperWasteUpdateLevel = upperWastePixel / 16L + (long)(upperWastePixel % 16L > 0L ? 1 : 0);
        LinkedHashMap<BlockPos, BlockState> newStates = new LinkedHashMap<BlockPos, BlockState>();
        boolean[] updatedLevels = new boolean[(int)upperFuelUpdateLevel];
        if (lowerFuelPixel != upperFuelPixel) {
            for (i = lowerFuelUpdateLevel; i < upperFuelUpdateLevel; ++i) {
                levelBasePixel = i * 16L;
                int levelFuelPixel = (int)Math.max(Math.min(fuelPixels - levelBasePixel, 16L), 0L);
                for (ReactorFuelRodTile reactorFuelRodTile : this.fuelRodsByLevel.get((int)i)) {
                    state = reactorFuelRodTile.func_195044_w();
                    newState = (BlockState)state.func_206870_a((Property)ReactorFuelRod.FUEL_HEIGHT_PROPERTY, (Comparable)Integer.valueOf(levelFuelPixel));
                    if (newState == state) continue;
                    newStates.put(reactorFuelRodTile.func_174877_v(), newState);
                    updatedLevels[(int)i] = true;
                }
            }
        }
        if (lowerWastePixel != upperWastePixel) {
            for (i = lowerWasteUpdateLevel; i < upperWasteUpdateLevel; ++i) {
                levelBasePixel = i * 16L;
                int levelWastePixel = (int)Math.max(Math.min(wastePixels - levelBasePixel, 16L), 0L);
                for (ReactorFuelRodTile reactorFuelRodTile : this.fuelRodsByLevel.get((int)i)) {
                    state = reactorFuelRodTile.func_195044_w();
                    newState = (BlockState)state.func_206870_a((Property)ReactorFuelRod.WASTE_HEIGHT_PROPERTY, (Comparable)Integer.valueOf(levelWastePixel));
                    if (newState == state) continue;
                    state = ((HashMap)newStates).getOrDefault(reactorFuelRodTile.func_174877_v(), state);
                    newState = (BlockState)state.func_206870_a((Property)ReactorFuelRod.WASTE_HEIGHT_PROPERTY, (Comparable)Integer.valueOf(levelWastePixel));
                    newStates.put(reactorFuelRodTile.func_174877_v(), newState);
                    updatedLevels[(int)i] = true;
                }
            }
        }
        Util.setBlockStates(newStates, (World)this.world);
        for (int i2 = 0; i2 < updatedLevels.length; ++i2) {
            if (!updatedLevels[i2]) continue;
            for (ReactorFuelRodTile reactorFuelRodTile : this.fuelRodsByLevel.get(i2)) {
                reactorFuelRodTile.func_145836_u();
            }
        }
        this.currentFuelRenderLevel = fuelPixels;
        this.currentWasteRenderLevel = wastePixels;
    }

    private void distributeFuel() {
        if (this.simulation.fuelTank().totalStored() > 0L && !this.fuelRods.isEmpty()) {
            long fuelToDistribute = this.simulation.fuelTank().fuel();
            long wasteToDistribute = this.simulation.fuelTank().waste();
            fuelToDistribute /= (long)this.fuelRods.size();
            wasteToDistribute /= (long)this.fuelRods.size();
            for (ReactorFuelRodTile fuelRod : this.fuelRods) {
                fuelRod.fuel += this.simulation.fuelTank().extractFuel(fuelToDistribute, false);
                fuelRod.waste += this.simulation.fuelTank().extractWaste(wasteToDistribute, false);
            }
            for (ReactorFuelRodTile fuelRod : this.fuelRods) {
                fuelRod.fuel += this.simulation.fuelTank().extractFuel(Long.MAX_VALUE, false);
                fuelRod.waste += this.simulation.fuelTank().extractWaste(Long.MAX_VALUE, false);
            }
            this.markDirty();
        }
    }

    private void collectFuel() {
        for (ReactorFuelRodTile fuelRod : this.fuelRods) {
            fuelRod.fuel -= this.simulation.fuelTank().insertFuel(fuelRod.fuel, false);
            fuelRod.waste -= this.simulation.fuelTank().insertWaste(fuelRod.waste, false);
            if (fuelRod.fuel == 0L && fuelRod.waste == 0L) continue;
            BiggerReactors.LOGGER.warn("Reactor overfilled with fuel at " + fuelRod.func_174877_v().toString());
            fuelRod.fuel = 0L;
            fuelRod.waste = 0L;
        }
        this.markDirty();
    }

    public synchronized void ejectWaste() {
        long wastePushed;
        for (ReactorAccessPortTile accessPort : this.accessPorts) {
            if (accessPort.isInlet()) continue;
            wastePushed = accessPort.pushWaste((int)this.simulation.fuelTank().waste(), false);
            this.forceDirty = this.simulation.fuelTank().extractWaste(wastePushed, false) > 0L;
        }
        if (this.simulation.fuelTank().waste() > Config.Reactor.FuelMBPerIngot) {
            for (ReactorAccessPortTile accessPort : this.accessPorts) {
                wastePushed = accessPort.pushWaste((int)this.simulation.fuelTank().waste(), false);
                this.forceDirty = this.simulation.fuelTank().extractWaste(wastePushed, false) > 0L;
            }
        }
    }

    public synchronized long extractWaste(long mb, boolean simulated) {
        if (this.assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long wasteExtracted = this.simulation.fuelTank().extractWaste(mb, simulated);
        this.forceDirty = wasteExtracted > 0L && !simulated;
        return wasteExtracted;
    }

    public synchronized long extractFuel(long mb, boolean simulated) {
        if (this.assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long fuelExtracted = this.simulation.fuelTank().extractFuel(mb, simulated);
        this.forceDirty = fuelExtracted > 0L && !simulated;
        return fuelExtracted;
    }

    public synchronized long refuel(long mb, boolean simulated) {
        if (this.assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long fuelInserted = this.simulation.fuelTank().insertFuel(mb, simulated);
        this.forceDirty = fuelInserted > 0L && !simulated;
        return fuelInserted;
    }

    public void updateReactorState(@Nonnull ReactorState reactorState) {
        reactorState.reactorActivity = this.reactorActivity;
        reactorState.reactorType = this.simulation.isPassive() ? ReactorType.PASSIVE : ReactorType.ACTIVE;
        reactorState.doAutoEject = this.autoEjectWaste;
        reactorState.energyStored = this.simulation.battery().stored();
        reactorState.energyCapacity = this.simulation.battery().capacity();
        reactorState.wasteStored = this.simulation.fuelTank().waste();
        reactorState.fuelStored = this.simulation.fuelTank().fuel();
        reactorState.fuelCapacity = this.simulation.fuelTank().capacity();
        reactorState.coolantStored = this.simulation.coolantTank().liquidAmount();
        reactorState.coolantCapacity = this.simulation.coolantTank().perSideCapacity();
        reactorState.coolantResourceLocation = this.simulation.coolantTank().liquidType() != null ? Objects.requireNonNull(this.simulation.coolantTank().liquidType().getRegistryName()).toString() : Objects.requireNonNull(Fluids.field_204541_a.getRegistryName()).toString();
        reactorState.exhaustStored = this.simulation.coolantTank().vaporAmount();
        reactorState.exhaustCapacity = this.simulation.coolantTank().perSideCapacity();
        reactorState.exhaustResourceLocation = this.simulation.coolantTank().vaporType() != null ? Objects.requireNonNull(this.simulation.coolantTank().vaporType().getRegistryName()).toString() : Objects.requireNonNull(Fluids.field_204541_a.getRegistryName()).toString();
        reactorState.caseHeatStored = this.simulation.caseHeat();
        reactorState.fuelHeatStored = this.simulation.fuelHeat();
        reactorState.reactivityRate = this.simulation.fertility();
        reactorState.fuelUsageRate = this.simulation.fuelConsumptionLastTick();
        reactorState.reactorOutputRate = this.simulation.outputLastTick();
    }

    public void runRequest(@Nonnull String requestName, @Nullable Object requestData) {
        switch (requestName) {
            case "setActive": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setActive(ReactorActivity.fromInt((Integer)requestData));
                return;
            }
            case "setAutoEject": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.autoEjectWaste = (Integer)requestData != 0;
                return;
            }
            case "ejectWaste": {
                this.ejectWaste();
                return;
            }
        }
    }

    @Nonnull
    public String getDebugInfo() {
        return super.getDebugInfo() + "State: " + this.reactorActivity.toString() + "\nStoredPower: " + this.simulation.battery().stored() + "\nPowerProduction: " + this.simulation.FEProducedLastTick() + "\nMBProduction: " + this.simulation.MBProducedLastTick() + "\nFuelUsage: " + this.simulation.fuelConsumptionLastTick() + "\nReactantCapacity: " + this.simulation.fuelTank().capacity() + "\nTotalReactant: " + this.simulation.fuelTank().totalStored() + "\nPercentFull: " + (float)this.simulation.fuelTank().totalStored() * 100.0f / (float)this.simulation.fuelTank().capacity() + "\nFuel: " + this.simulation.fuelTank().fuel() + "\nWaste: " + this.simulation.fuelTank().waste() + "\nAutoEjectWaste: " + this.autoEjectWaste + "\nFertility: " + this.simulation.fertility() + "\nFuelHeat: " + this.simulation.fuelHeat() + "\nReactorHeat: " + this.simulation.caseHeat() + "\nCoolantTankSize: " + this.simulation.coolantTank().perSideCapacity() + "\nLiquidType: " + this.simulation.coolantTank().liquidType() + "\nLiquid: " + this.simulation.coolantTank().liquidAmount() + "\nVaporType: " + this.simulation.coolantTank().vaporType() + "\nVapor: " + this.simulation.coolantTank().vaporAmount() + "\n";
    }

    public synchronized void setAllControlRodLevels(double newLevel) {
        this.controlRods.forEach(rod -> rod.setInsertion(newLevel));
        this.updateControlRodLevels();
    }

    public synchronized void setControlRodLevel(int index, double newLevel) {
        this.controlRods.get(index).setInsertion(newLevel);
        this.updateControlRodLevels();
    }

    public double controlRodLevel(int index) {
        return this.controlRods.get(index).getInsertion();
    }

    public void updateControlRodLevels() {
        this.controlRods.forEach(rod -> {
            BlockPos pos = rod.func_174877_v();
            this.simulation.setControlRodInsertion(pos.func_177958_n() - this.minCoord().x() - 1, pos.func_177952_p() - this.minCoord().z() - 1, rod.getInsertion());
        });
    }

    public int controlRodCount() {
        return this.controlRods.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String controlRodName(int index) {
        List<ReactorControlRodTile> list = this.controlRods;
        synchronized (list) {
            return this.controlRods.get(index).getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControlRodName(int index, String newName) {
        List<ReactorControlRodTile> list = this.controlRods;
        synchronized (list) {
            this.controlRods.get(index).setName(newName);
        }
    }
}

