/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.block.entity;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.block.entity.UsesAltarPower;
import moriyashiine.bewitchment.api.component.CursesComponent;
import moriyashiine.bewitchment.api.misc.PoppetData;
import moriyashiine.bewitchment.api.registry.Curse;
import moriyashiine.bewitchment.common.BWConfig;
import moriyashiine.bewitchment.common.block.entity.WitchAltarBlockEntity;
import moriyashiine.bewitchment.common.item.TaglockItem;
import moriyashiine.bewitchment.common.recipe.CurseRecipe;
import moriyashiine.bewitchment.common.recipe.IncenseRecipe;
import moriyashiine.bewitchment.common.registry.BWBlockEntityTypes;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWEntityTypes;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWParticleTypes;
import moriyashiine.bewitchment.common.registry.BWRecipeTypes;
import moriyashiine.bewitchment.common.registry.BWRegistries;
import moriyashiine.bewitchment.common.registry.BWSoundEvents;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BrazierBlockEntity
extends class_2586
implements class_1263,
UsesAltarPower {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private class_2338 altarPos = null;
    public IncenseRecipe incenseRecipe = null;
    public CurseRecipe curseRecipe = null;
    private int timer = 0;
    private boolean loaded = false;
    private boolean hasIncense;

    public BrazierBlockEntity(class_2338 pos, class_2680 state) {
        super(BWBlockEntityTypes.BRAZIER, pos, state);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("AltarPos")) {
            this.setAltarPos(class_2338.method_10092((long)nbt.method_10537("AltarPos")));
        }
        this.inventory.clear();
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.timer = nbt.method_10550("Timer");
        this.hasIncense = nbt.method_10577("HasIncense");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.getAltarPos() != null) {
            nbt.method_10544("AltarPos", this.getAltarPos().method_10063());
        }
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("Timer", this.timer);
        nbt.method_10556("HasIncense", this.hasIncense);
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    @Override
    public class_2338 getAltarPos() {
        return this.altarPos;
    }

    @Override
    public void setAltarPos(class_2338 pos) {
        this.altarPos = pos;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BrazierBlockEntity blockEntity) {
        if (world != null) {
            if (!blockEntity.loaded) {
                if (!world.field_9236 && ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                    blockEntity.incenseRecipe = world.method_8433().method_30027(BWRecipeTypes.INCENSE_RECIPE_TYPE).stream().filter(recipe -> recipe.method_8115(blockEntity, world)).findFirst().orElse(null);
                    if (BWConfig.enableCurses) {
                        blockEntity.curseRecipe = world.method_8433().method_30027(BWRecipeTypes.CURSE_RECIPE_TYPE).stream().filter(recipe -> recipe.method_8115(blockEntity, world)).findFirst().orElse(null);
                    }
                    blockEntity.hasIncense = blockEntity.incenseRecipe != null;
                    blockEntity.method_5431();
                    blockEntity.syncBrazier();
                }
                blockEntity.loaded = true;
            }
            if (blockEntity.timer < 0) {
                ++blockEntity.timer;
                if (world.field_9236) {
                    if (world.field_9229.method_43056()) {
                        world.method_8406((class_2394)(blockEntity.hasIncense ? (class_2394)BWParticleTypes.INCENSE_SMOKE : class_2398.field_11237), (double)pos.method_10263() + 0.5 + class_3532.method_15366((class_5819)world.field_9229, (double)-0.2, (double)0.2), (double)pos.method_10264() + ((Boolean)state.method_11654((class_2769)class_2741.field_16561) != false ? 0.4 : 1.25), (double)pos.method_10260() + 0.5 + class_3532.method_15366((class_5819)world.field_9229, (double)-0.2, (double)0.2), 0.0, 0.05, 0.0);
                    }
                } else if (blockEntity.timer == 0) {
                    boolean clear = blockEntity.hasIncense;
                    if (blockEntity.curseRecipe != null) {
                        class_1657 closestPlayer = world.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 24.0, false);
                        if (blockEntity.altarPos != null && ((WitchAltarBlockEntity)world.method_8321(blockEntity.altarPos)).drain(blockEntity.curseRecipe.cost, false)) {
                            if (closestPlayer != null) {
                                class_1657 player;
                                class_1297 target = blockEntity.getTarget();
                                if (target instanceof class_1657 && BewitchmentAPI.getFamiliar(player = (class_1657)target) == BWEntityTypes.RAVEN && world.field_9229.method_43056()) {
                                    target = closestPlayer;
                                }
                                if (target instanceof class_1309) {
                                    class_1309 livingEntity = (class_1309)target;
                                    PoppetData poppetData = BewitchmentAPI.getPoppet(world, BWObjects.CURSE_POPPET, target);
                                    if (!poppetData.stack().method_7960() && poppetData.stack().method_7985() && !poppetData.stack().method_7969().method_10577("Cursed")) {
                                        poppetData.stack().method_7969().method_10582("Curse", BWRegistries.CURSE.method_10221((Object)blockEntity.curseRecipe.curse).toString());
                                        poppetData.stack().method_7969().method_10556("Cursed", true);
                                        TaglockItem.removeTaglock(poppetData.stack());
                                        poppetData.update(world, true);
                                    } else {
                                        int duration = 168000;
                                        if (BewitchmentAPI.getFamiliar(closestPlayer) == BWEntityTypes.RAVEN) {
                                            duration *= 2;
                                        }
                                        if (target instanceof class_1657) {
                                            class_1657 player2 = (class_1657)target;
                                            if (((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)((class_1309)target)).get()).isEquipped(BWObjects.NAZAR) && BewitchmentAPI.drainMagic(player2, 50, false)) {
                                                duration /= 2;
                                            }
                                        }
                                        ((CursesComponent)BWComponents.CURSES_COMPONENT.get((Object)livingEntity)).addCurse(new Curse.Instance(blockEntity.curseRecipe.curse, duration));
                                    }
                                    world.method_8396(null, pos, BWSoundEvents.ENTITY_GENERIC_CURSE, class_3419.field_15245, 1.0f, 1.0f);
                                    clear = true;
                                }
                            } else {
                                world.method_8396(null, pos, BWSoundEvents.BLOCK_BRAZIER_FAIL, class_3419.field_15245, 1.0f, 1.0f);
                                if (closestPlayer != null) {
                                    String entityName = "";
                                    for (int i = 0; i < blockEntity.method_5439(); ++i) {
                                        class_1799 stack = blockEntity.method_5438(i);
                                        if (!(stack.method_7909() instanceof TaglockItem) || !TaglockItem.hasTaglock(stack)) continue;
                                        entityName = TaglockItem.getTaglockName(stack);
                                        break;
                                    }
                                    closestPlayer.method_7353((class_2561)class_2561.method_43469((String)"bewitchment.message.invalid_entity", (Object[])new Object[]{entityName}), true);
                                }
                            }
                        } else if (closestPlayer != null) {
                            world.method_8396(null, pos, BWSoundEvents.BLOCK_BRAZIER_FAIL, class_3419.field_15245, 1.0f, 1.0f);
                            closestPlayer.method_7353((class_2561)class_2561.method_43471((String)"bewitchment.message.insufficent_altar_power"), true);
                        }
                    }
                    blockEntity.reset(clear);
                    blockEntity.syncBrazier();
                }
            }
        }
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) < 16.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void syncBrazier() {
        this.sync();
    }

    private int getFirstEmptySlot() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public void onUse(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        if (!((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            class_1799 stack = player.method_5998(hand);
            if (((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                world.method_8501(pos, (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)));
                world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 2.0f);
                this.reset(this.hasIncense);
                this.syncBrazier();
            } else if (stack.method_7909() instanceof class_1786) {
                CurseRecipe foundCurseRecipe;
                world.method_8501(pos, (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)));
                world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
                stack.method_7956(1, (class_1309)player, stackUser -> stackUser.method_20236(hand));
                IncenseRecipe foundIncenseRecipe = world.method_8433().method_30027(BWRecipeTypes.INCENSE_RECIPE_TYPE).stream().filter(recipe -> recipe.method_8115(this, world)).findFirst().orElse(null);
                if (foundIncenseRecipe != null) {
                    this.incenseRecipe = foundIncenseRecipe;
                    this.timer = -6000;
                    this.hasIncense = true;
                    this.syncBrazier();
                } else if (BWConfig.enableCurses && (foundCurseRecipe = (CurseRecipe)world.method_8433().method_30027(BWRecipeTypes.CURSE_RECIPE_TYPE).stream().filter(recipe -> recipe.method_8115(this, world)).findFirst().orElse(null)) != null && this.getTarget() != null) {
                    this.curseRecipe = foundCurseRecipe;
                    this.timer = -100;
                    this.syncBrazier();
                }
            } else if (!stack.method_7960()) {
                int firstEmpty = this.getFirstEmptySlot();
                if (firstEmpty != -1) {
                    this.method_5447(firstEmpty, stack.method_7971(1));
                    this.syncBrazier();
                }
            } else {
                this.reset(this.hasIncense);
                this.syncBrazier();
            }
        }
        this.method_5431();
    }

    private class_1297 getTarget() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            for (int i = 0; i < this.method_5439(); ++i) {
                class_1309 entity = BewitchmentAPI.getTaglockOwner(this.field_11863, this.method_5438(i));
                if (entity == null) continue;
                return entity;
            }
        }
        return null;
    }

    private void reset(boolean clear) {
        if (this.field_11863 != null) {
            if (clear) {
                this.cleanInventory();
            }
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867.method_10086((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_16561) != false ? 0 : 1), (class_1263)this);
            this.incenseRecipe = null;
            this.curseRecipe = null;
            this.timer = 0;
            this.hasIncense = false;
        }
    }

    private void cleanInventory() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7963()) {
                if (!stack.method_7970(1, this.field_11863.field_9229, null) || stack.method_7919() != stack.method_7936()) continue;
                stack.method_7934(1);
                continue;
            }
            class_1792 item = stack.method_7909();
            this.method_5447(i, item.method_7857() ? new class_1799((class_1935)item.method_7858()) : class_1799.field_8037);
        }
    }
}

