/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.handler;

import fuzs.bettertridents.BetterTridents;
import fuzs.bettertridents.config.ServerConfig;
import fuzs.bettertridents.mixin.accessor.ThrownTridentAccessor;
import fuzs.bettertridents.world.entity.LastDamageSourceEntity;
import fuzs.bettertridents.world.entity.item.LoyalExperienceOrb;
import fuzs.bettertridents.world.entity.item.LoyalItemEntity;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import java.util.Collection;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class LoyalDropsHandler {
    public static EventResult onLivingDrops(class_1309 entity, class_1282 source, Collection<class_1542> drops, int lootingLevel, boolean recentlyHit) {
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).loyaltyCapturesDrops) {
            return EventResult.PASS;
        }
        int loyaltyLevel = LoyalDropsHandler.getLoyaltyLevel(source);
        if (loyaltyLevel > 0) {
            for (class_1542 itemEntity : drops) {
                itemEntity = new LoyalItemEntity(itemEntity, source.method_5529().method_5667(), loyaltyLevel);
                entity.method_37908().method_8649((class_1297)itemEntity);
            }
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingExperienceDrop(class_1309 entity, @Nullable class_1657 attackingPlayer, DefaultedInt droppedExperience) {
        int loyaltyLevel;
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).loyaltyCapturesDrops) {
            return EventResult.PASS;
        }
        class_1282 source = ((LastDamageSourceEntity)entity).bettertridents$getLastDamageSource();
        if (source != null && (loyaltyLevel = LoyalDropsHandler.getLoyaltyLevel(source)) > 0) {
            LoyalDropsHandler.awardExperienceOrbs((class_3218)entity.method_37908(), entity.method_19538(), droppedExperience.getAsInt(), (class_1657)source.method_5529(), loyaltyLevel);
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    private static int getLoyaltyLevel(class_1282 source) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            class_1297 class_12973 = source.method_5526();
            if (class_12973 instanceof class_1685) {
                class_1685 trident = (class_1685)class_12973;
                return ((Byte)trident.method_5841().method_12789(ThrownTridentAccessor.getLoyaltyId())).byteValue();
            }
            return class_1890.method_8203((class_1887)class_1893.field_9120, (class_1309)player);
        }
        return 0;
    }

    public static void awardExperienceOrbs(class_3218 level, class_243 pos, int amount, class_1657 player, int loyaltyLevel) {
        while (amount > 0) {
            int i = class_1303.method_5918((int)amount);
            amount -= i;
            level.method_8649((class_1297)new LoyalExperienceOrb((class_1937)level, pos.method_10216(), pos.method_10214(), pos.method_10215(), i, player.method_5667(), loyaltyLevel));
        }
    }

    public static void tickLoyalEntity(class_1297 entity, class_1657 owner, int loyaltyLevel) {
        entity.field_6014 = entity.method_23317();
        entity.field_6036 = entity.method_23318();
        entity.field_5969 = entity.method_23321();
        entity.field_5960 = true;
        class_243 vec3 = owner.method_33571().method_1020(entity.method_19538());
        entity.method_23327(entity.method_23317(), entity.method_23318() + vec3.field_1351 * 0.015 * (double)loyaltyLevel, entity.method_23321());
        if (entity.method_37908().field_9236) {
            entity.field_5971 = entity.method_23318();
        }
        entity.method_18799(entity.method_18798().method_1021(0.95).method_1019(vec3.method_1029().method_1021(0.05 * (double)loyaltyLevel)));
        entity.method_5670();
        if (!entity.method_24828() || entity.method_18798().method_37268() > (double)1.0E-5f || (entity.field_6012 + entity.method_5628()) % 4 == 0) {
            entity.method_5784(class_1313.field_6308, entity.method_18798());
        }
        if (!entity.method_37908().field_9236 && entity.method_18798().method_1020(vec3).method_1027() > 0.01) {
            entity.field_6007 = true;
        }
    }

    @Nullable
    public static class_1657 isAcceptableReturnOwner(class_1937 level, @Nullable class_1297 owner) {
        class_1657 player;
        return owner instanceof class_1657 && (player = (class_1657)owner).method_5805() && !player.method_7325() ? player : null;
    }
}

